/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.args;

import net.morimekta.console.args.ArgumentList;
import net.morimekta.console.args.BaseArgument;

public abstract class BaseOption
extends BaseArgument {
    private final String shortNames;
    private final String metaVar;

    protected BaseOption(String name, String shortNames, String metaVar, String usage, String defaultValue, boolean repeated, boolean required, boolean hidden) {
        super(name, usage, defaultValue, repeated, required, hidden);
        this.shortNames = shortNames == null ? "" : shortNames;
        this.metaVar = metaVar;
        if (this.getName() == null && this.getShortNames().length() == 0) {
            throw new IllegalArgumentException("Option must have name or short name");
        }
        if (this.getName() != null && !this.getName().startsWith("--")) {
            throw new IllegalArgumentException("Option name \"" + this.getName() + "\" does not start with '--'");
        }
    }

    public String getShortNames() {
        return this.shortNames;
    }

    public String getMetaVar() {
        return this.metaVar;
    }

    @Override
    public String getSingleLineUsage() {
        if (this.isHidden()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (!this.isRequired()) {
            sb.append('[');
        }
        if (this.shortNames.length() > 0) {
            sb.append('-').append(this.shortNames.charAt(0));
        } else {
            sb.append(this.getName());
        }
        if (this.getMetaVar() != null) {
            sb.append(' ').append(this.getMetaVar());
        }
        if (!this.isRequired()) {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public String getPrefix() {
        StringBuilder sb = new StringBuilder();
        if (this.getName() != null) {
            sb.append(this.getName());
            if (this.getShortNames().length() > 0) {
                sb.append(" (");
                boolean first = true;
                for (char c : this.getShortNames().toCharArray()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append('-').append(c);
                }
                sb.append(")");
            }
        } else {
            sb.append('-').append(this.getShortNames().subSequence(0, 1));
            if (this.getShortNames().length() > 1) {
                sb.append(" (");
                boolean first = true;
                for (char c : this.getShortNames().substring(1).toCharArray()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append('-').append(c);
                }
                sb.append(")");
            }
        }
        if (this.getMetaVar() != null) {
            sb.append(' ').append(this.getMetaVar());
        }
        return sb.toString();
    }

    public abstract int applyShort(String var1, ArgumentList var2);

    @Override
    public abstract int apply(ArgumentList var1);

    protected String nameOrShort() {
        if (this.getName() != null) {
            return this.getName();
        }
        return "-" + this.getShortNames().substring(0, 1);
    }
}

