/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.args;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.morimekta.console.args.ArgumentException;
import net.morimekta.console.args.ArgumentList;
import net.morimekta.console.args.ArgumentOptions;
import net.morimekta.console.args.BaseArgument;
import net.morimekta.console.args.BaseOption;
import net.morimekta.console.args.Flag;
import net.morimekta.console.args.SubCommandSet;
import net.morimekta.console.chr.CharUtil;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IndentedPrintWriter;
import org.apache.commons.lang3.text.WordUtils;

public class ArgumentParser {
    static final int USAGE_EXTRA_CHARS = 4;
    private final String program;
    private final String version;
    private final String description;
    private final ArgumentOptions argumentOptions;
    private final LinkedList<BaseOption> options;
    private final LinkedList<BaseArgument> arguments;
    private final Map<String, BaseOption> longNameOptions;
    private final Map<Character, BaseOption> shortOptions;

    public ArgumentParser(String program, String version, String description) {
        this(program, version, description, ArgumentOptions.defaults());
    }

    public ArgumentParser(String program, String version, String description, ArgumentOptions argumentOptions) {
        this.program = program;
        this.version = version;
        this.description = description;
        this.argumentOptions = argumentOptions;
        this.options = new LinkedList();
        this.arguments = new LinkedList();
        this.longNameOptions = new HashMap<String, BaseOption>();
        this.shortOptions = new HashMap<Character, BaseOption>();
    }

    public String getProgram() {
        return this.program;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public <O extends BaseOption> ArgumentParser add(O option) {
        String negate;
        this.options.add(option);
        if (option.getName() != null) {
            if (this.longNameOptions.containsKey(option.getName())) {
                throw new IllegalArgumentException("Option " + option.getName() + " already exists.");
            }
            this.longNameOptions.put(option.getName(), option);
        }
        if (option instanceof Flag && (negate = ((Flag)option).getNegateName()) != null) {
            if (this.longNameOptions.containsKey(negate)) {
                throw new IllegalArgumentException("Flag " + negate + " already exists.");
            }
            this.longNameOptions.put(negate, option);
        }
        if (option.getShortNames().length() > 0) {
            for (char s : option.getShortNames().toCharArray()) {
                if (this.shortOptions.containsKey(Character.valueOf(s))) {
                    throw new IllegalArgumentException("Short option -" + s + " already exists.");
                }
                this.shortOptions.put(Character.valueOf(s), option);
            }
        }
        return this;
    }

    public <A extends BaseArgument> ArgumentParser add(A arg) {
        if (arg instanceof BaseOption) {
            return this.add((A)((BaseOption)arg));
        }
        if (this.arguments.size() > 0 && this.arguments.getLast() instanceof SubCommandSet) {
            throw new IllegalArgumentException("No arguments can be added after a sub-command set.");
        }
        this.arguments.add(arg);
        return this;
    }

    public void parse(String ... args) {
        this.parse(new ArgumentList(args));
    }

    public void parse(ArgumentList args) {
        while (args.remaining() > 0) {
            BaseArgument arg;
            File f;
            Object opt;
            String cur = args.get(0);
            if (cur.equals("--")) {
                args.consume(1);
                break;
            }
            if (cur.startsWith("--")) {
                BaseOption opt2;
                if (cur.contains("=")) {
                    cur = cur.substring(0, cur.indexOf("="));
                }
                if ((opt2 = this.longNameOptions.get(cur)) == null) {
                    throw new ArgumentException("No option for " + cur, new Object[0]);
                }
                args.consume(opt2.apply(args));
                continue;
            }
            if (cur.startsWith("-")) {
                String remaining = cur.substring(1);
                int skip = 0;
                while (remaining.length() > 0) {
                    opt = this.shortOptions.get(Character.valueOf(remaining.charAt(0)));
                    if (opt == null) {
                        throw new ArgumentException("No short opt for -" + remaining.charAt(0), new Object[0]);
                    }
                    skip = ((BaseOption)opt).applyShort(remaining, args);
                    if (skip != 0) break;
                    remaining = remaining.substring(1);
                }
                args.consume(Math.max(1, skip));
                continue;
            }
            if (cur.startsWith("@") && (f = new File(cur.substring(1))).exists() && f.isFile()) {
                try {
                    FileInputStream fis = new FileInputStream(f);
                    opt = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(fis));){
                        List<String> lines = reader.lines().map(String::trim).filter(l -> !l.isEmpty() && !l.startsWith("#")).collect(Collectors.toList());
                        if (lines.size() > 0) {
                            ArgumentList list = new ArgumentList(lines.toArray(new String[lines.size()]));
                            this.parse(list);
                        }
                    }
                    catch (Throwable throwable) {
                        opt = throwable;
                        throw throwable;
                    }
                    finally {
                        if (fis != null) {
                            if (opt != null) {
                                try {
                                    fis.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)opt).addSuppressed(throwable);
                                }
                            } else {
                                fis.close();
                            }
                        }
                    }
                }
                catch (ArgumentException e) {
                    throw new ArgumentException(e, "Argument file " + f.getName() + ": " + e.getMessage(), new Object[0]);
                }
                catch (IOException e) {
                    throw new ArgumentException(e, e.getMessage(), new Object[0]);
                }
                args.consume(1);
                continue;
            }
            int consumed = 0;
            Iterator e = this.arguments.iterator();
            while (e.hasNext() && (consumed = (arg = (BaseArgument)e.next()).apply(args)) <= 0) {
            }
            if (consumed == 0) {
                throw new ArgumentException("No option found for " + args.get(0), new Object[0]);
            }
            args.consume(consumed);
        }
        while (args.remaining() > 0) {
            BaseArgument arg;
            int consumed = 0;
            Iterator iterator = this.arguments.iterator();
            while (iterator.hasNext() && (consumed = (arg = (BaseArgument)iterator.next()).apply(args)) <= 0) {
            }
            if (consumed == 0) {
                throw new ArgumentException("No argument found for " + args.get(0), new Object[0]);
            }
            args.consume(consumed);
        }
    }

    public void validate() {
        this.options.forEach(BaseArgument::validate);
        this.arguments.forEach(BaseArgument::validate);
    }

    public void printUsage(OutputStream out) {
        this.printUsage(out, false);
    }

    public void printUsage(OutputStream out, boolean showHidden) {
        this.printUsage(new PrintWriter(out), showHidden);
    }

    public void printUsage(PrintWriter writer, boolean showHidden) {
        this.printUsageInternal(new IndentedPrintWriter(writer), showHidden);
    }

    public String getProgramDescription() {
        return this.description + " - " + this.version;
    }

    public String getSingleLineUsage() {
        String usage;
        StringBuilder writer = new StringBuilder();
        writer.append(this.program);
        String sh = "-";
        for (BaseOption opt : this.options) {
            if (!(opt instanceof Flag)) continue;
            sh = sh + opt.getShortNames();
        }
        if (sh.length() > 1) {
            writer.append('[').append(sh).append(']');
        }
        for (BaseOption opt : this.options) {
            if (opt instanceof Flag && opt.getShortNames().length() > 0 || (usage = opt.getSingleLineUsage()) == null) continue;
            writer.append(' ').append(usage);
        }
        for (BaseArgument arg : this.arguments) {
            usage = arg.getSingleLineUsage();
            if (usage == null) continue;
            writer.append(' ').append(usage);
        }
        return writer.toString();
    }

    private void printUsageInternal(IndentedPrintWriter writer, boolean showHidden) {
        int usageWidth = this.argumentOptions.getUsageWidth();
        int prefixLen = 0;
        for (BaseOption opt : this.options) {
            prefixLen = Math.max(prefixLen, opt.getPrefix().length());
        }
        for (BaseArgument arg : this.arguments) {
            prefixLen = Math.max(prefixLen, arg.getPrefix().length());
        }
        prefixLen = Math.min(prefixLen, usageWidth / 3 - 4);
        String indent = Strings.times(" ", prefixLen + 4);
        if (this.options.size() > 0) {
            boolean first = true;
            if (this.argumentOptions.getOptionComparator() != null) {
                this.options.sort(this.argumentOptions.getOptionComparator());
            }
            for (BaseOption opt : this.options) {
                if (opt.isHidden() && !showHidden) continue;
                String prefix = opt.getPrefix();
                String usage = opt.getUsage();
                if (this.argumentOptions.getDefaultsShown() && opt.getDefaultValue() != null) {
                    usage = usage + " (default:\u00a0" + opt.getDefaultValue() + ")";
                }
                if (first) {
                    first = false;
                } else {
                    writer.appendln();
                }
                writer.begin(indent);
                ArgumentParser.printSingleUsageEntry(writer, prefix, usage, prefixLen, usageWidth);
                writer.end();
            }
        }
        if (this.arguments.size() > 0) {
            for (BaseArgument arg : this.arguments) {
                if (arg.isHidden() && !showHidden) continue;
                String prefix = arg.getPrefix();
                String usage = arg.getUsage();
                if (this.argumentOptions.getDefaultsShown() && arg.getDefaultValue() != null) {
                    usage = usage + " (default:\u00a0" + arg.getDefaultValue() + ")";
                }
                writer.appendln();
                writer.begin(indent);
                ArgumentParser.printSingleUsageEntry(writer, prefix, usage, prefixLen, usageWidth);
                writer.end();
            }
        }
        writer.newline().flush();
    }

    static void printSingleUsageEntry(IndentedPrintWriter writer, String prefix, String usage, int prefixLen, int usageWidth) {
        String[] descLines;
        int printLinesFrom = 0;
        writer.append(" ");
        if (prefix.length() > prefixLen) {
            writer.append(prefix);
            if ((double)prefix.length() > (double)prefixLen * 1.7) {
                descLines = WordUtils.wrap(usage, usageWidth - prefixLen - 4).split("[\\n]");
            } else {
                writer.append(" : ");
                String[] tmp = WordUtils.wrap(usage, usageWidth - prefix.length() - 4).split("[\\n]", 2);
                writer.append(tmp[0]);
                descLines = tmp.length > 1 ? WordUtils.wrap(tmp[1].replaceAll("\\n", " "), usageWidth - prefixLen - 4).split("[\\n]") : new String[]{};
            }
        } else {
            writer.append(CharUtil.leftJust(prefix, prefixLen));
            writer.append(" : ");
            descLines = WordUtils.wrap(usage, usageWidth - prefixLen - 4).split("[\\n]");
            writer.append(descLines[0]);
            printLinesFrom = 1;
        }
        for (int i = printLinesFrom; i < descLines.length; ++i) {
            writer.appendln(descLines[i]);
        }
    }
}

