/*
 * Copyright 2017 Providence Authors
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package net.morimekta.providence.config.util;

import net.morimekta.providence.config.parser.ConfigException;
import net.morimekta.util.Displayable;

import javax.annotation.Nonnull;

/**
 * Unchecked config exception wrapping the providence config exception.
 * Handy for using config in streams etc.
 */
public class UncheckedConfigException extends RuntimeException implements Displayable {
    public UncheckedConfigException(ConfigException cause) {
        super(cause.getMessage(), cause);
    }

    @Override
    public ConfigException getCause() {
        return (ConfigException) super.getCause();
    }

    @Override
    public String toString() {
        return getCause().toString();
    }

    @Nonnull
    @Override
    public String displayString() {
        return getCause().displayString();
    }
}
