/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import net.morimekta.providence.config.util.ContentResolver;

public class ResourceContentResolver
implements ContentResolver {
    @Override
    @Nonnull
    public Path canonical(Path file) {
        if (!file.isAbsolute()) {
            file = Paths.get("/" + file.toString(), new String[0]);
        }
        file = file.normalize();
        try (InputStream tmp = ResourceContentResolver.class.getResourceAsStream(file.toString());){
            if (tmp == null) {
                throw new FileNotFoundException(file.toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    @Override
    @Nonnull
    public Path reference(Path referenceLocation, Path from, String reference) {
        return from.getParent().resolve(reference).normalize();
    }

    @Override
    @Nonnull
    public Path referenceLocationPath(Path referenceLocation, Path from, String reference) {
        return this.reference(referenceLocation, from, reference).getParent();
    }

    @Override
    @Nonnull
    @WillNotClose
    public InputStream open(Path file) {
        return ResourceContentResolver.class.getResourceAsStream(this.canonical(file).toString());
    }
}

