/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.parser;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.morimekta.providence.config.parser.ConfigToken;
import net.morimekta.providence.serializer.JsonSerializerException;
import net.morimekta.providence.serializer.pretty.PrettyException;
import net.morimekta.util.lexer.LexerException;
import net.morimekta.util.lexer.Token;

public class ConfigException
extends LexerException {
    protected String file;

    public ConfigException(String format, Object ... args) {
        super(args.length == 0 ? format : String.format(format, args));
    }

    public ConfigException(@Nonnull PrettyException cause) {
        super((CharSequence)Objects.requireNonNull(cause.getLine()), cause.getLineNo(), cause.getLinePos(), cause.getLength(), cause.getMessage());
        this.initCause(cause);
    }

    public ConfigException(@Nonnull JsonSerializerException cause) {
        super((CharSequence)Objects.requireNonNull(cause.getLine()), cause.getLineNo(), cause.getLinePos(), cause.getLen(), cause.getMessage());
        this.initCause(cause);
    }

    public ConfigException(Throwable cause, String format, Object ... args) {
        super(cause, args.length == 0 ? format : String.format(format, args));
    }

    public ConfigException(ConfigToken token, String format, Object ... args) {
        super((Token)token, args.length == 0 ? format : String.format(format, args));
    }

    public ConfigException setFile(String file) {
        this.file = file;
        return this;
    }

    public String getFile() {
        return this.file;
    }

    protected String getError() {
        if (this.file != null) {
            return "Error in " + this.file;
        }
        return "Error";
    }

    @Nonnull
    public ConfigException initCause(Throwable cause) {
        return (ConfigException)super.initCause(cause);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "\n" + this.displayString();
    }
}

