/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.ConfigSupplier;
import net.morimekta.providence.config.impl.ProvidenceConfigSupplier;
import net.morimekta.providence.config.impl.ResourceConfigSupplier;
import net.morimekta.providence.config.parser.ConfigException;
import net.morimekta.providence.config.parser.ConfigParser;
import net.morimekta.providence.config.parser.ConfigWarning;
import net.morimekta.providence.config.util.FileContentResolver;
import net.morimekta.providence.config.util.ResourceContentResolver;
import net.morimekta.providence.types.TypeRegistry;
import net.morimekta.util.FileWatcher;

public class ConfigLoader
implements AutoCloseable {
    private final FileWatcher watcher;
    private final Clock clock;
    private final ConfigParser resourceParser;
    private final ConfigParser fileParser;

    public ConfigLoader(@Nonnull TypeRegistry registry) {
        this(registry, warning -> System.err.println(warning.displayString()));
    }

    public ConfigLoader(@Nonnull TypeRegistry registry, @Nonnull Consumer<ConfigWarning> warningHandler) {
        this(registry, new FileWatcher(), warningHandler, false);
    }

    public ConfigLoader(@Nonnull TypeRegistry registry, @Nonnull FileWatcher watcher, @Nonnull Consumer<ConfigWarning> warningHandler, boolean strict) {
        this(registry, watcher, warningHandler, strict, Clock.systemUTC());
    }

    public ConfigLoader(@Nonnull TypeRegistry registry, @Nonnull FileWatcher watcher, @Nonnull Consumer<ConfigWarning> warningHandler, boolean strict, @Nonnull Clock clock) {
        this.watcher = watcher;
        this.clock = clock;
        this.resourceParser = new ConfigParser(registry, new ResourceContentResolver(), warningHandler, strict);
        this.fileParser = new ConfigParser(registry, new FileContentResolver(), warningHandler, strict);
    }

    @Nonnull
    public <M extends PMessage<M>> ConfigSupplier<M> loadFile(@Nonnull Path configFile, @Nonnull ConfigSupplier<M> parentConfig) throws ConfigException {
        return new ProvidenceConfigSupplier<M>(configFile, parentConfig, this.watcher, this.fileParser, this.clock);
    }

    @Nonnull
    public <M extends PMessage<M>> ConfigSupplier<M> loadFile(@Nonnull Path configFile) throws ConfigException {
        return new ProvidenceConfigSupplier(configFile, null, this.watcher, this.fileParser, this.clock);
    }

    public <M extends PMessage<M>> ConfigSupplier<M> loadResource(@Nonnull String resourcePath) throws ConfigException {
        return new ResourceConfigSupplier(Paths.get(resourcePath, new String[0]), this.resourceParser, this.clock);
    }

    @Nonnull
    public <M extends PMessage<M>> M getConfig(@Nonnull Path configFile) throws ConfigException {
        return (M)((PMessage)this.fileParser.parseConfig((Path)configFile, null).first);
    }

    @Nonnull
    public <M extends PMessage<M>> M getConfig(@Nonnull Path configFile, @Nonnull M parent) throws ConfigException {
        return (M)((PMessage)this.fileParser.parseConfig((Path)configFile, parent).first);
    }

    @Override
    public void close() {
        this.watcher.close();
    }
}

