/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import net.morimekta.providence.config.util.ContentResolver;
import net.morimekta.util.FileUtil;

public class FileContentResolver
implements ContentResolver {
    @Override
    @Nonnull
    public Path canonical(Path file) throws IOException {
        file = file.normalize().toAbsolutePath();
        if (!Files.exists(file = FileUtil.readCanonicalPath((Path)file), new LinkOption[0])) {
            throw new FileNotFoundException(file.toString());
        }
        return file;
    }

    @Override
    @Nonnull
    public Path reference(Path referenceLocation, Path from, String reference) {
        if (reference.startsWith(".." + File.separator)) {
            return referenceLocation.resolve(reference).normalize();
        }
        return from.getParent().resolve(reference).normalize();
    }

    @Override
    @Nonnull
    public Path referenceLocationPath(Path referenceLocation, Path from, String reference) {
        if (reference.contains(File.separator)) {
            return referenceLocation.resolve(reference).normalize().getParent();
        }
        return referenceLocation;
    }

    @Override
    @Nonnull
    @WillNotClose
    public InputStream open(Path file) throws IOException {
        return new FileInputStream(FileUtil.readCanonicalPath((Path)file).toFile());
    }
}

