/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.parser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.config.parser.ConfigException;
import net.morimekta.providence.config.parser.ConfigLexer;
import net.morimekta.providence.config.parser.ConfigToken;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.util.MessageUtil;
import net.morimekta.util.FileUtil;
import net.morimekta.util.collect.UnmodifiableSet;

public class ConfigUtil {
    static final String IDENTIFIER_SEP = ".";
    static final String FALSE = "false";
    static final String TRUE = "true";
    static final String DEF = "def";
    public static final String UNDEFINED = "undefined";
    static final String INCLUDE = "include";
    static final String AS = "as";
    static final Set<String> RESERVED_WORDS = UnmodifiableSet.setOf((Object)"true", (Object)"false", (Object)"undefined", (Object)"def", (Object)"as", (Object)"include");

    static Object getInMessage(PMessage message, String key) throws ConfigException {
        return ConfigUtil.getInMessage(message, key, null);
    }

    static Object getInMessage(PMessage message, String key, Object defValue) throws ConfigException {
        if (message == null) {
            return null;
        }
        try {
            return MessageUtil.getInMessage((PMessageOrBuilder)message, (PField[])MessageUtil.keyPathToFields((PMessageDescriptor)message.descriptor(), (String)key)).orElse(defValue);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(e, e.getMessage(), new Object[0]);
        }
    }

    static Object asType(PDescriptor descriptor, Object o) throws ConfigException {
        try {
            return MessageUtil.coerce((PDescriptor)descriptor, (Object)o).orElse(null);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(e, e.getMessage(), new Object[0]);
        }
    }

    static void consumeValue(@Nonnull ConfigLexer lexer, @Nonnull ConfigToken token) throws IOException {
        block20: {
            block21: {
                boolean isMessage = false;
                if (UNDEFINED.equals(token.toString())) {
                    return;
                }
                if (token.toString().equals("b64")) {
                    lexer.expectSymbol("b64 body start", new char[]{'('});
                    lexer.readBinary(')');
                } else if (token.toString().equals("hex")) {
                    lexer.expectSymbol("hex body start", new char[]{'('});
                    lexer.readBinary(')');
                } else if (token.isReferenceIdentifier()) {
                    if (!((ConfigToken)lexer.peek("message start")).isSymbol('{')) {
                        return;
                    }
                    isMessage = true;
                    token = (ConfigToken)lexer.expect("start of message");
                }
                if (!token.isSymbol('{')) break block21;
                token = (ConfigToken)lexer.expect("map or message first entry");
                if (token.isSymbol('}')) {
                    return;
                }
                ConfigToken firstSep = (ConfigToken)lexer.peek("First separator");
                if (!(isMessage || firstSep.isSymbol('=') || firstSep.isSymbol('{'))) {
                    while (!token.isSymbol('}')) {
                        if (!token.isIdentifier() && token.isReferenceIdentifier()) {
                            throw new ConfigException(token, "Invalid map key: " + token.toString(), new Object[0]);
                        }
                        ConfigUtil.consumeValue(lexer, token);
                        lexer.expectSymbol("key value sep.", new char[]{':'});
                        ConfigUtil.consumeValue(lexer, (ConfigToken)lexer.expect("map value"));
                        token = ConfigUtil.nextNotSeparator(lexer, "map key, sep or end");
                    }
                } else {
                    while (!token.isSymbol('}')) {
                        if (!token.isIdentifier()) {
                            throw new ConfigException(token, "Invalid field name: " + token.toString(), new Object[0]);
                        }
                        token = (ConfigToken)lexer.expect("field value sep");
                        if (token.isSymbol('{')) {
                            ConfigUtil.consumeValue(lexer, token);
                        } else if (token.isSymbol('=')) {
                            ConfigUtil.consumeValue(lexer, (ConfigToken)lexer.expect("field value"));
                        } else {
                            throw new ConfigException(token, "Unknown field value sep: " + token.toString(), new Object[0]);
                        }
                        token = ConfigUtil.nextNotSeparator(lexer, "message field or end");
                    }
                }
                break block20;
            }
            if (!token.isSymbol('[')) break block20;
            token = (ConfigToken)lexer.expect("list value or end");
            while (!token.isSymbol(']')) {
                ConfigUtil.consumeValue(lexer, token);
                if (!((ConfigToken)lexer.expectSymbol("list separator or end", new char[]{',', ']'})).isSymbol(']')) {
                    token = (ConfigToken)lexer.expect("list value or end");
                    continue;
                }
                break;
            }
        }
    }

    @Nonnull
    static ConfigToken nextNotSeparator(ConfigLexer tokenizer, String message) throws IOException {
        if (((ConfigToken)tokenizer.peek("optional sep")).isSymbol(',') || ((ConfigToken)tokenizer.peek("optional sep")).isSymbol(';')) {
            tokenizer.expect(message);
        }
        return (ConfigToken)tokenizer.expect(message);
    }

    public static Path canonicalFileLocation(@Nonnull Path file) throws ConfigException {
        if (!file.isAbsolute()) {
            file = file.toAbsolutePath();
        }
        if (file.getParent() == null) {
            throw new ConfigException("Trying to read root directory", new Object[0]);
        }
        try {
            Path dir = FileUtil.readCanonicalPath((Path)file.getParent());
            return dir.resolve(file.getFileName());
        }
        catch (IOException e) {
            throw new ConfigException(e, e.getMessage(), new Object[0]);
        }
    }

    static Path resolveFile(Path reference, String path) throws IOException {
        Path file;
        if (reference == null) {
            Path file2 = ConfigUtil.canonicalFileLocation(Paths.get(path, new String[0]));
            if (Files.exists(file2, new LinkOption[0])) {
                if (Files.isRegularFile(file2, new LinkOption[0])) {
                    return file2;
                }
                throw new FileNotFoundException(path + " is a directory, expected file");
            }
            throw new FileNotFoundException("File " + path + " not found");
        }
        if (path.startsWith("/")) {
            throw new FileNotFoundException("Absolute path includes not allowed: " + path);
        }
        if (!Files.isDirectory(reference = FileUtil.readCanonicalPath((Path)reference), new LinkOption[0])) {
            reference = reference.getParent();
        }
        if (Files.exists(file = ConfigUtil.canonicalFileLocation(reference.resolve(path)), new LinkOption[0])) {
            if (Files.isRegularFile(file, new LinkOption[0])) {
                return file;
            }
            throw new FileNotFoundException(path + " is a directory, expected file");
        }
        throw new FileNotFoundException("Included file " + path + " not found");
    }

    private ConfigUtil() {
    }

    static enum Stage {
        INCLUDES,
        DEFINES,
        MESSAGE;

    }
}

