/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.impl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.ConfigListener;
import net.morimekta.providence.config.ConfigSupplier;
import net.morimekta.providence.config.impl.UpdatingConfigSupplier;
import net.morimekta.providence.config.parser.ConfigException;
import net.morimekta.providence.config.parser.ConfigParser;
import net.morimekta.util.FileWatcher;
import net.morimekta.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvidenceConfigSupplier<Message extends PMessage<Message>>
extends UpdatingConfigSupplier<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProvidenceConfigSupplier.class);
    private final Path configFile;
    private final ConfigParser configParser;
    private final Set<String> includedFiles;
    private final FileWatcher fileWatcher;
    private final ConfigListener<Message> configListener;
    private final FileWatcher.Listener fileListener;
    private final ConfigSupplier<Message> parentSupplier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvidenceConfigSupplier(@Nonnull Path configFile, @Nullable ConfigSupplier<Message> parentSupplier, @Nullable FileWatcher fileWatcher, @Nonnull ConfigParser configParser, @Nonnull Clock clock) throws ConfigException {
        super(clock);
        this.configFile = configFile;
        this.configParser = configParser;
        this.parentSupplier = parentSupplier;
        this.includedFiles = Collections.synchronizedSet(new HashSet());
        this.includedFiles.add(configFile.toString());
        this.fileWatcher = fileWatcher;
        ProvidenceConfigSupplier providenceConfigSupplier = this;
        synchronized (providenceConfigSupplier) {
            if (fileWatcher != null) {
                this.fileListener = file -> {
                    if (configFile.equals(file) || this.includedFiles.contains(file.toString())) {
                        this.reload();
                    }
                };
                fileWatcher.weakAddWatcher(configFile, this.fileListener);
            } else {
                this.fileListener = null;
            }
            if (parentSupplier != null) {
                this.configListener = config -> this.reload();
                this.parentSupplier.addListener(this.configListener);
                this.set(this.loadConfig((PMessage)parentSupplier.get()));
            } else {
                this.configListener = null;
                this.set(this.loadConfig(null));
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProvidenceConfig{").append(this.configFile.getFileName().toString());
        if (this.parentSupplier != null) {
            builder.append(", parent=");
            builder.append(this.parentSupplier.getName());
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public String getName() {
        return "ProvidenceConfig{" + this.configFile.getFileName() + "}";
    }

    private void reload() {
        try {
            if (!Files.exists(this.configFile, new LinkOption[0])) {
                LOGGER.warn("Config file deleted " + this.configFile + ", keeping old config.");
                return;
            }
            LOGGER.trace("Config reload triggered for " + this.configFile);
            if (this.parentSupplier != null) {
                this.set(this.loadConfig((PMessage)this.parentSupplier.get()));
            } else {
                this.set(this.loadConfig(null));
            }
        }
        catch (ConfigException e) {
            LOGGER.error("Exception when reloading " + this.configFile, (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Message loadConfig(@Nullable Message parent) throws ConfigException {
        Pair<Message, Set<String>> tmp = this.configParser.parseConfig(this.configFile, parent);
        if (this.fileWatcher != null) {
            ProvidenceConfigSupplier providenceConfigSupplier = this;
            synchronized (providenceConfigSupplier) {
                if (!((Set)tmp.second).equals(this.includedFiles)) {
                    this.includedFiles.clear();
                    this.includedFiles.addAll((Collection)tmp.second);
                    for (String included : this.includedFiles) {
                        this.fileWatcher.weakAddWatcher(Paths.get(included, new String[0]), this.fileListener);
                    }
                }
            }
        }
        return (Message)((PMessage)tmp.first);
    }
}

