/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.impl;

import java.time.Clock;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.ConfigListener;
import net.morimekta.providence.config.ConfigSupplier;
import net.morimekta.providence.config.impl.ReferenceConfigSupplier;
import net.morimekta.providence.config.parser.ConfigException;
import net.morimekta.providence.descriptor.PField;

@Immutable
public class FixedConfigSupplier<M extends PMessage<M>>
implements ConfigSupplier<M> {
    private final M instance;
    private final long timestamp;
    private final Clock clock;

    public FixedConfigSupplier(@Nonnull M initialConfig) {
        this(initialConfig, Clock.systemUTC().millis(), Clock.systemUTC());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedConfigSupplier(@Nonnull ConfigSupplier<M> supplier) {
        ConfigSupplier<M> configSupplier = Objects.requireNonNull(supplier);
        synchronized (configSupplier) {
            this.instance = (PMessage)supplier.get();
            this.timestamp = supplier.configTimestamp();
            this.clock = supplier.getClock();
        }
    }

    public FixedConfigSupplier(@Nonnull M initialConfig, long timestamp, Clock clock) {
        this.instance = initialConfig;
        this.timestamp = timestamp;
        this.clock = clock;
    }

    @Override
    @Nonnull
    public final M get() {
        return this.instance;
    }

    @Override
    public <RM extends PMessage<RM>> ConfigSupplier<RM> reference(PField ... fields) throws ConfigException {
        return new FixedConfigSupplier(ReferenceConfigSupplier.getReference(this.instance, ReferenceConfigSupplier.validate(this.instance.descriptor(), fields)));
    }

    @Override
    public final void addListener(@Nonnull ConfigListener<M> listener) {
    }

    @Override
    public final void removeListener(@Nonnull ConfigListener<M> listener) {
    }

    @Override
    public long configTimestamp() {
        return this.timestamp;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return "InMemoryConfig";
    }
}

