/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.parser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.config.parser.ConfigContext;
import net.morimekta.providence.config.parser.ConfigException;
import net.morimekta.providence.config.parser.ConfigLexer;
import net.morimekta.providence.config.parser.ConfigToken;
import net.morimekta.providence.config.parser.ConfigTokenType;
import net.morimekta.providence.config.parser.ConfigUtil;
import net.morimekta.providence.config.parser.ConfigWarning;
import net.morimekta.providence.config.util.ContentResolver;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.types.TypeReference;
import net.morimekta.providence.types.TypeRegistry;
import net.morimekta.util.Binary;
import net.morimekta.util.Pair;
import net.morimekta.util.io.Utf8StreamReader;

public class ConfigParser {
    private final TypeRegistry registry;
    private final boolean strict;
    private final ContentResolver contentResolver;
    private final Consumer<ConfigWarning> warningHandler;

    public ConfigParser(TypeRegistry registry, ContentResolver contentResolver, Consumer<ConfigWarning> warningHandler, boolean strict) {
        this.registry = registry;
        this.warningHandler = warningHandler;
        this.contentResolver = contentResolver;
        this.strict = strict;
    }

    @Nonnull
    public <M extends PMessage<M>> Pair<M, Set<String>> parseConfig(@Nonnull Path configFile, @Nullable M parent) throws ConfigException {
        try {
            configFile = this.contentResolver.canonical(configFile);
        }
        catch (IOException e) {
            throw new ConfigException(e, "Unable to resolve config file %s", configFile).setFile(configFile.getFileName().toString());
        }
        return this.checkAndParseInternal(configFile, parent, new String[0]);
    }

    private <M extends PMessage<M>> Pair<M, Set<String>> checkAndParseInternal(@Nonnull Path configFile, @Nullable M parent, String ... includeStack) throws ConfigException {
        try {
            String canonicalFile = this.contentResolver.canonical(configFile).toString();
            ArrayList<String> stackList = new ArrayList<String>();
            Collections.addAll(stackList, includeStack);
            if (Arrays.binarySearch(includeStack, canonicalFile) >= 0) {
                stackList.add(canonicalFile);
                throw new ConfigException("Circular includes detected: " + stackList.stream().map(p -> new File((String)p).getName()).collect(Collectors.joining(" -> ")), new Object[0]);
            }
            stackList.add(canonicalFile);
            return this.parseConfigRecursively(configFile, parent, stackList.toArray(new String[0]));
        }
        catch (ConfigException te) {
            if (te.getFile() == null) {
                te.setFile(configFile.getFileName().toString());
            }
            throw te;
        }
        catch (IOException e) {
            throw new ConfigException(e, e.getMessage(), new Object[0]).setFile(configFile.getFileName().toString());
        }
    }

    @Nullable
    private <M extends PMessage<M>> Pair<M, Set<String>> parseConfigRecursively(@Nonnull Path file, M parent, String[] stack) throws IOException {
        ConfigLexer lexer;
        try (BufferedInputStream in = new BufferedInputStream(this.contentResolver.open(file));){
            lexer = new ConfigLexer((Reader)new Utf8StreamReader((InputStream)in));
        }
        ConfigContext context = new ConfigContext();
        TreeSet<String> includedFilePaths = new TreeSet<String>();
        includedFilePaths.add(this.contentResolver.canonical(file).toString());
        ConfigUtil.Stage lastStage = ConfigUtil.Stage.INCLUDES;
        Object result = null;
        ConfigToken token = (ConfigToken)lexer.peek();
        while (token != null) {
            lexer.next();
            if (lastStage == ConfigUtil.Stage.MESSAGE) {
                throw new ConfigException(token, "Unexpected token '" + token.toString() + "', expected end of file.", new Object[0]);
            }
            if ("include".equals(token.toString())) {
                PMessage included;
                if (lastStage != ConfigUtil.Stage.INCLUDES) {
                    throw new ConfigException(token, "Include added after defines or message. Only one def block allowed.", new Object[0]);
                }
                token = (ConfigToken)lexer.expect("file to be included", ConfigTokenType.STRING);
                String includedFilePath = token.decodeString(this.strict);
                try {
                    Path includedFile = this.contentResolver.canonical(file.getParent().resolve(includedFilePath));
                    Pair<Object, Set<String>> tmp = this.checkAndParseInternal(includedFile, null, stack);
                    if (tmp != null) {
                        includedFilePaths.add(includedFile.toString());
                        includedFilePaths.addAll((Collection)tmp.second);
                        included = (PMessage)tmp.first;
                    } else {
                        this.warn(file, token, "No content in included file: %s", includedFile.getFileName().toString());
                        included = null;
                    }
                }
                catch (FileNotFoundException e) {
                    throw new ConfigException(token, "Included file \"%s\" not found.", includedFilePath);
                }
                token = (ConfigToken)lexer.expect("the token 'as'", ConfigToken::isIdentifier);
                if (!"as".equals(token.toString())) {
                    throw new ConfigException(token, "Expected token 'as' after included file \"%s\".", includedFilePath);
                }
                token = (ConfigToken)lexer.expect("Include alias", ConfigToken::isIdentifier);
                String alias = token.toString();
                if (ConfigUtil.RESERVED_WORDS.contains(alias)) {
                    throw new ConfigException(token, "Alias \"%s\" is a reserved word.", alias);
                }
                if (context.containsReference(alias)) {
                    throw new ConfigException(token, "Alias \"%s\" is already used.", alias);
                }
                context.setInclude(alias, included);
            } else if ("def".equals(token.toString())) {
                lastStage = ConfigUtil.Stage.DEFINES;
                this.parseDefinitions(file, context, lexer);
            } else if (token.isQualifiedIdentifier()) {
                PMessageDescriptor descriptor;
                lastStage = ConfigUtil.Stage.MESSAGE;
                try {
                    descriptor = this.registry.requireMessageType(TypeReference.parseType((String)token.toString()));
                }
                catch (IllegalArgumentException e) {
                    if (this.strict || stack.length == 1) {
                        throw new ConfigException(token, "Unknown declared type: %s", token.toString());
                    }
                    this.warn(file, token, "Unknown declared type: %s", token.toString());
                    return null;
                }
                result = this.parseConfigMessage(file, lexer, context, descriptor.builder(), parent);
            } else {
                throw new ConfigException(token, "Unexpected token '" + token.toString() + "'. Expected include, defines or message type", new Object[0]);
            }
            token = (ConfigToken)lexer.peek();
        }
        if (result == null) {
            throw new ConfigException("No message in config: " + file.getFileName().toString(), new Object[0]);
        }
        return Pair.create(result, includedFilePaths);
    }

    private void parseDefinitions(Path file, ConfigContext context, ConfigLexer lexer) throws IOException {
        ConfigToken token = (ConfigToken)lexer.expect("defines group start or identifier");
        if (token.isIdentifier()) {
            String name = context.initReference(token);
            lexer.expectSymbol("def value sep", new char[]{'='});
            context.setReference(name, this.parseDefinitionValue(file, context, lexer));
        } else if (token.isSymbol('{')) {
            token = (ConfigToken)lexer.expect("define or end");
            while (!token.isSymbol('}')) {
                if (!token.isIdentifier()) {
                    throw new ConfigException(token, "Token '%s' is not valid reference name.", token.toString());
                }
                String name = context.initReference(token);
                lexer.expectSymbol("def value sep", new char[]{'='});
                context.setReference(name, this.parseDefinitionValue(file, context, lexer));
                token = (ConfigToken)lexer.expect("next define or end");
            }
        } else {
            throw new ConfigException(token, "Unexpected token after def: '%s'", token.toString());
        }
    }

    private Object parseDefinitionValue(Path file, ConfigContext context, ConfigLexer lexer) throws IOException {
        ConfigToken token = (ConfigToken)lexer.expect("Start of def value");
        if (token.isReal()) {
            return Double.parseDouble(token.toString());
        }
        if (token.isInteger()) {
            return Long.parseLong(token.toString());
        }
        if (token.isString()) {
            return token.decodeString(this.strict);
        }
        if ("true".equalsIgnoreCase(token.toString())) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(token.toString())) {
            return Boolean.FALSE;
        }
        if ("b64".equals(token.toString())) {
            lexer.expectSymbol("binary data enclosing start", new char[]{'('});
            ConfigToken binary = lexer.readBinary(')');
            if (binary == null) {
                return Binary.empty();
            }
            return Binary.fromBase64((String)binary.toString().replaceAll("[\\s=]", ""));
        }
        if ("hex".equals(token.toString())) {
            lexer.expectSymbol("binary data enclosing start", new char[]{'('});
            ConfigToken binary = lexer.readBinary(')');
            if (binary == null) {
                return Binary.empty();
            }
            return Binary.fromHexString((String)binary.toString().replaceAll("[\\s]", ""));
        }
        if (token.isDoubleQualifiedIdentifier()) {
            String id = token.toString();
            int l = id.lastIndexOf(46);
            try {
                PEnumDescriptor ed = this.registry.requireEnumType(TypeReference.parseType((String)id.substring(0, l)));
                PEnumValue val = ed.findByName(id.substring(l + 1));
                if (val == null) {
                    if (this.strict) {
                        throw new ConfigException(token, "Unknown %s value: %s", id.substring(0, l), id.substring(l + 1));
                    }
                    this.warn(file, token, "Unknown %s value: %s", id.substring(0, l), id.substring(l + 1));
                }
                return val;
            }
            catch (IllegalArgumentException e) {
                if (this.strict) {
                    throw new ConfigException(token, "Unknown enum identifier: %s", id.substring(0, l));
                }
                this.warn(file, token, "Unknown enum identifier: %s", id.substring(0, l));
                ConfigUtil.consumeValue(lexer, token);
            }
            catch (ClassCastException e) {
                throw new ConfigException(token, "Identifier " + id + " does not reference an enum, from " + token.toString(), new Object[0]);
            }
        }
        if (token.isQualifiedIdentifier()) {
            PMessageDescriptor descriptor;
            try {
                descriptor = this.registry.requireMessageType(TypeReference.parseType((String)token.toString()));
            }
            catch (IllegalArgumentException e) {
                if (this.strict) {
                    throw new ConfigException(token, "Unknown declared type: %s", token.toString());
                }
                ConfigUtil.consumeValue(lexer, token);
                return null;
            }
            PMessageBuilder builder = descriptor.builder();
            if (((ConfigToken)lexer.expectSymbol("message start or inherits", new char[]{'{', ':'})).isSymbol(':')) {
                token = (ConfigToken)lexer.expect("inherits reference", ConfigToken::isReferenceIdentifier);
                PMessage inheritsFrom = (PMessage)ConfigParser.resolve(context, token, (PDescriptor)descriptor);
                if (inheritsFrom == null) {
                    throw new ConfigException(token, "Inheriting from null reference: %s", token.toString());
                }
                builder.merge(inheritsFrom);
                lexer.expectSymbol("message start", new char[]{'{'});
            }
            return this.parseMessage(file, lexer, context, builder);
        }
        throw new ConfigException(token, "Invalid define value " + token.toString(), new Object[0]);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <M extends PMessage<M>> M parseConfigMessage(Path file, ConfigLexer lexer, ConfigContext context, PMessageBuilder<M> builder, M parent) throws IOException {
        if (((ConfigToken)lexer.expectSymbol("extension marker", new char[]{':', '{'})).isSymbol(':')) {
            ConfigToken token = (ConfigToken)lexer.expect("extension object");
            if (parent != null) {
                throw new ConfigException(token, "Config has both defined parent and inherits from", new Object[0]);
            }
            if (!token.isReferenceIdentifier() || ConfigUtil.RESERVED_WORDS.contains(token.toString())) throw new ConfigException(token, "Unexpected token " + token.toString() + ", expected reference identifier", new Object[0]);
            try {
                builder.merge((PMessage)ConfigParser.resolveRequired(context, token, (PDescriptor)builder.descriptor()));
            }
            catch (ClassCastException e) {
                throw new ConfigException(token, "Config type mismatch, expected " + builder.descriptor().getQualifiedName(), new Object[0]);
            }
            lexer.expectSymbol("object begin", new char[]{'{'});
            return this.parseMessage(file, lexer, context, builder);
        }
        if (parent == null) return this.parseMessage(file, lexer, context, builder);
        if (!builder.descriptor().equals((Object)parent.descriptor())) {
            throw new ConfigException("Loaded config type %s does not match parent %s", parent.descriptor().getQualifiedName(), builder.descriptor().getQualifiedName());
        }
        builder.merge(parent);
        return this.parseMessage(file, lexer, context, builder);
    }

    private <M extends PMessage<M>> M parseMessage(@Nonnull Path file, @Nonnull ConfigLexer lexer, @Nonnull ConfigContext context, @Nonnull PMessageBuilder<M> builder) throws IOException {
        PMessageDescriptor descriptor = builder.descriptor();
        ConfigToken token = (ConfigToken)lexer.expect("object end or field");
        while (!token.isSymbol('}')) {
            if (!token.isIdentifier()) {
                throw new ConfigException(token, "Invalid field name: " + token.toString(), new Object[0]);
            }
            PField field = descriptor.findFieldByName(token.toString());
            if (field == null) {
                if (this.strict) {
                    throw lexer.failure(token, "No such field " + token.toString() + " in " + descriptor.getQualifiedName(), new Object[0]);
                }
                this.warn(file, token, "No such field " + token.toString() + " in " + descriptor.getQualifiedName(), new Object[0]);
                token = (ConfigToken)lexer.expect("field value sep, message start or reference start");
                if (token.isSymbol('=')) {
                    token = (ConfigToken)lexer.expect("value declaration");
                } else if (!token.isSymbol('{')) {
                    throw new ConfigException(token, "Expected field-value separator or inherited message", new Object[0]);
                }
                ConfigUtil.consumeValue(lexer, token);
                token = ConfigUtil.nextNotSeparator(lexer, "field or message end");
                continue;
            }
            if (field.getType() == PType.MESSAGE) {
                PMessageBuilder bld;
                char symbol = ((ConfigToken)lexer.expectSymbol("Message assigner or start", new char[]{'=', '{'})).charAt(0);
                if (symbol == '=') {
                    token = (ConfigToken)lexer.expect("reference or message start");
                    if ("undefined".equals(token.toString())) {
                        builder.clear(field.getId());
                        token = ConfigUtil.nextNotSeparator(lexer, "field or message end");
                        continue;
                    }
                    bld = ((PMessageDescriptor)field.getDescriptor()).builder();
                    if (token.isReferenceIdentifier() && !ConfigUtil.RESERVED_WORDS.contains(token.toString())) {
                        PMessage ref = (PMessage)ConfigParser.resolveRequired(context, token, field.getDescriptor());
                        bld.merge(ref);
                        token = (ConfigToken)lexer.expect("after message reference");
                        if (!token.isSymbol('{')) {
                            builder.set(field.getId(), (Object)bld.build());
                            continue;
                        }
                    } else if (!token.isSymbol('{')) {
                        throw new ConfigException(token, "Unexpected token " + token.toString() + ", expected message start", new Object[0]);
                    }
                } else {
                    bld = builder.mutator(field.getId());
                }
                builder.set(field.getId(), this.parseMessage(file, lexer, context, bld));
            } else if (field.getType() == PType.MAP) {
                token = (ConfigToken)lexer.expect("field sep or value start");
                Map baseValue = new LinkedHashMap();
                if (token.isSymbol('=')) {
                    token = (ConfigToken)lexer.expect("field id or start");
                    if ("undefined".equals(token.toString())) {
                        builder.clear(field.getId());
                        token = (ConfigToken)lexer.expect("message end or field");
                        continue;
                    }
                    if (token.isReferenceIdentifier() && !ConfigUtil.RESERVED_WORDS.contains(token.toString())) {
                        try {
                            baseValue = (Map)ConfigParser.resolve(context, token, field.getDescriptor());
                        }
                        catch (ConfigException e) {
                            throw new ConfigException(token, e.getMessage(), new Object[0]).initCause((Throwable)((Object)e));
                        }
                        token = (ConfigToken)lexer.expect("map start or next field");
                        if (!token.isSymbol('{')) {
                            builder.set(field.getId(), baseValue);
                            continue;
                        }
                        if (baseValue == null) {
                            baseValue = new LinkedHashMap();
                        }
                    }
                } else {
                    baseValue.putAll((Map)builder.build().get(field.getId()));
                }
                if (!token.isSymbol('{')) {
                    throw new ConfigException(token, "Expected map start, but got '%s'", token.toString());
                }
                Map map = this.parseMapValue(file, lexer, context, (PMap)field.getDescriptor(), baseValue);
                builder.set(field.getId(), (Object)map);
            } else {
                lexer.expectSymbol("field value sep", new char[]{'='});
                token = (ConfigToken)lexer.expect("field value");
                if ("undefined".equals(token.toString())) {
                    builder.clear(field.getId());
                } else {
                    Object value = this.parseFieldValue(file, token, lexer, context, field.getDescriptor(), this.strict);
                    builder.set(field.getId(), value);
                }
            }
            token = ConfigUtil.nextNotSeparator(lexer, "field or message end");
        }
        return (M)builder.build();
    }

    private Map parseMapValue(Path file, ConfigLexer lexer, ConfigContext context, PMap descriptor, Map builder) throws IOException {
        ConfigToken next = (ConfigToken)lexer.expect("map key or end");
        while (!next.isSymbol('}')) {
            Object key = this.parseFieldValue(file, next, lexer, context, descriptor.keyDescriptor(), true);
            lexer.expectSymbol("map key value sep", new char[]{':'});
            next = (ConfigToken)lexer.expect("map value");
            if ("undefined".equals(next.toString())) {
                builder.remove(key);
            } else {
                Object value = next.isReferenceIdentifier() && !ConfigUtil.RESERVED_WORDS.contains(next.toString()) && context.containsReference(next.toString()) ? context.getReference(next.toString(), next) : this.parseFieldValue(file, next, lexer, context, descriptor.itemDescriptor(), this.strict);
                if (value != null) {
                    builder.put(key, value);
                }
            }
            if (!(next = (ConfigToken)lexer.expect("map key, end or sep")).isSymbol(',')) continue;
            next = (ConfigToken)lexer.expect("map key or end");
        }
        return descriptor.builder(builder.size()).putAll(builder).build();
    }

    private Object parseFieldValue(Path file, ConfigToken next, ConfigLexer lexer, ConfigContext context, PDescriptor descriptor, boolean requireEnumValue) throws IOException {
        try {
            switch (descriptor.getType()) {
                case BOOL: {
                    if ("true".equals(next.toString())) {
                        return true;
                    }
                    if ("false".equals(next.toString())) {
                        return false;
                    }
                    if (next.isReferenceIdentifier() && !ConfigUtil.RESERVED_WORDS.contains(next.toString())) {
                        return ConfigParser.resolve(context, next, descriptor);
                    }
                    break;
                }
                case BYTE: {
                    if (next.isReferenceIdentifier() && !ConfigUtil.RESERVED_WORDS.contains(next.toString())) {
                        return ConfigParser.resolve(context, next, descriptor);
                    }
                    if (next.isInteger()) {
                        return (byte)next.parseInteger();
                    }
                    break;
                }
                case I16: {
                    if (next.isReferenceIdentifier() && !ConfigUtil.RESERVED_WORDS.contains(next.toString())) {
                        return ConfigParser.resolve(context, next, descriptor);
                    }
                    if (next.isInteger()) {
                        return (short)next.parseInteger();
                    }
                    break;
                }
                case I32: {
                    if (next.isReferenceIdentifier() && !ConfigUtil.RESERVED_WORDS.contains(next.toString())) {
                        return ConfigParser.resolve(context, next, descriptor);
                    }
                    if (next.isInteger()) {
                        return (int)next.parseInteger();
                    }
                    break;
                }
                case I64: {
                    if (next.isReferenceIdentifier() && !ConfigUtil.RESERVED_WORDS.contains(next.toString())) {
                        return ConfigParser.resolve(context, next, descriptor);
                    }
                    if (next.isInteger()) {
                        return next.parseInteger();
                    }
                    break;
                }
                case DOUBLE: {
                    if (next.isReferenceIdentifier() && !ConfigUtil.RESERVED_WORDS.contains(next.toString())) {
                        return ConfigParser.resolve(context, next, descriptor);
                    }
                    if (next.isInteger() || next.isReal()) {
                        return next.parseDouble();
                    }
                    break;
                }
                case STRING: {
                    if (next.isReferenceIdentifier() && !ConfigUtil.RESERVED_WORDS.contains(next.toString())) {
                        return ConfigParser.resolve(context, next, descriptor);
                    }
                    if (next.isString()) {
                        return next.decodeString(this.strict);
                    }
                    break;
                }
                case BINARY: {
                    if ("b64".equals(next.toString())) {
                        lexer.expectSymbol("binary data enclosing start", new char[]{'('});
                        ConfigToken binary = lexer.readBinary(')');
                        if (binary == null) {
                            return Binary.empty();
                        }
                        return Binary.fromBase64((String)binary.toString());
                    }
                    if ("hex".equals(next.toString())) {
                        lexer.expectSymbol("binary data enclosing start", new char[]{'('});
                        ConfigToken binary = lexer.readBinary(')');
                        if (binary == null) {
                            return Binary.empty();
                        }
                        return Binary.fromHexString((String)binary.toString());
                    }
                    if (next.isReferenceIdentifier() && !ConfigUtil.RESERVED_WORDS.contains(next.toString())) {
                        return ConfigParser.resolve(context, next, descriptor);
                    }
                    break;
                }
                case ENUM: {
                    PEnumValue value;
                    PEnumDescriptor ed = (PEnumDescriptor)descriptor;
                    String name = next.toString();
                    if (next.isInteger()) {
                        value = ed.findById((int)next.parseInteger());
                    } else if (next.isIdentifier()) {
                        value = ed.findByName(name);
                        if (value == null && context.containsReference(name)) {
                            value = (PEnumValue)ConfigParser.resolve(context, next, (PDescriptor)ed);
                        }
                    } else {
                        if (!next.isReferenceIdentifier()) break;
                        value = (PEnumValue)ConfigParser.resolve(context, next, descriptor);
                    }
                    if (value == null) {
                        PEnumValue option = null;
                        if (next.isIdentifier()) {
                            for (PEnumValue o : ed.getValues()) {
                                if (!o.asString().equalsIgnoreCase(name)) continue;
                                option = o;
                                break;
                            }
                        }
                        if (this.strict || requireEnumValue) {
                            if (option != null) {
                                throw lexer.failure(next, "No such enum value '%s' for %s, did you mean '%s'?", new Object[]{name, ed.getQualifiedName(), option.toString()});
                            }
                            throw lexer.failure(next, "No such enum value '%s' for %s.", new Object[]{name, ed.getQualifiedName()});
                        }
                        if (option != null) {
                            this.warn(file, next, "No such enum value '%s' for %s, did you mean '%s'?", name, ed.getQualifiedName(), option.toString());
                        }
                        this.warn(file, next, "No such enum value '%s' for %s.", name, ed.getQualifiedName());
                    }
                    return value;
                }
                case MESSAGE: {
                    if (next.isReferenceIdentifier() && !ConfigUtil.RESERVED_WORDS.contains(next.toString())) {
                        return ConfigParser.resolve(context, next, descriptor);
                    }
                    if (next.isSymbol('{')) {
                        return this.parseMessage(file, lexer, context, ((PMessageDescriptor)descriptor).builder());
                    }
                    break;
                }
                case MAP: {
                    if (next.isReferenceIdentifier() && !ConfigUtil.RESERVED_WORDS.contains(next.toString())) {
                        Map resolved;
                        try {
                            resolved = (Map)ConfigParser.resolve(context, next, descriptor);
                        }
                        catch (ClassCastException e) {
                            throw new ConfigException(next, "Reference %s is not a map field ", next.toString());
                        }
                        return resolved;
                    }
                    if (next.isSymbol('{')) {
                        return this.parseMapValue(file, lexer, context, (PMap)descriptor, new LinkedHashMap());
                    }
                    break;
                }
                case SET: {
                    if (next.isReferenceIdentifier() && !ConfigUtil.RESERVED_WORDS.contains(next.toString())) {
                        return ConfigParser.resolve(context, next, descriptor);
                    }
                    if (next.isSymbol('[')) {
                        PSet ct = (PSet)descriptor;
                        PSet.Builder value = ((PSet)descriptor).builder(4);
                        next = (ConfigToken)lexer.expect("set value or end");
                        while (!next.isSymbol(']')) {
                            Object item = this.parseFieldValue(file, next, lexer, context, ct.itemDescriptor(), this.strict);
                            if (item != null) {
                                value.add(item);
                            }
                            if (((ConfigToken)lexer.expectSymbol("set separator or end", new char[]{',', ']'})).isSymbol(']')) break;
                            next = (ConfigToken)lexer.expect("set value or end");
                        }
                        return value.build();
                    }
                    break;
                }
                case LIST: {
                    if (next.isReferenceIdentifier() && !ConfigUtil.RESERVED_WORDS.contains(next.toString())) {
                        return ConfigParser.resolve(context, next, descriptor);
                    }
                    if (next.isSymbol('[')) {
                        PList ct = (PList)descriptor;
                        PList.Builder builder = ct.builder(4);
                        next = (ConfigToken)lexer.expect("list value or end");
                        while (!next.isSymbol(']')) {
                            Object item = this.parseFieldValue(file, next, lexer, context, ct.itemDescriptor(), this.strict);
                            if (item != null) {
                                builder.add(item);
                            }
                            if (((ConfigToken)lexer.expectSymbol("list separator or end", new char[]{',', ']'})).isSymbol(']')) break;
                            next = (ConfigToken)lexer.expect("list value or end");
                        }
                        return builder.build();
                    }
                    break;
                }
                default: {
                    throw new ConfigException(next, descriptor.getType() + " not supported!", new Object[0]);
                }
            }
        }
        catch (ConfigException e) {
            throw new ConfigException(next, e.getMessage(), new Object[0]);
        }
        throw new ConfigException(next, "Unhandled value \"%s\" for type %s", next.toString(), descriptor.getType());
    }

    @Nonnull
    private static <V> V resolveRequired(ConfigContext context, ConfigToken token, PDescriptor descriptor) throws ConfigException {
        V result = ConfigParser.resolve(context, token, descriptor);
        if (result == null) {
            throw new ConfigException(token, "No such reference " + token.toString(), new Object[0]);
        }
        return result;
    }

    private static <V> V resolve(ConfigContext context, ConfigToken token, PDescriptor descriptor) throws ConfigException {
        if (!ConfigUtil.RESERVED_WORDS.contains(token.toString())) {
            Object value = ConfigParser.resolveAny(context, token);
            if (value == null) {
                return null;
            }
            return (V)ConfigUtil.asType(descriptor, value);
        }
        return null;
    }

    private static Object resolveAny(ConfigContext context, ConfigToken token) throws ConfigException {
        String key;
        String name = key = token.toString();
        String subKey = null;
        if (key.contains(".")) {
            int idx = key.indexOf(".");
            name = key.substring(0, idx);
            subKey = key.substring(idx + 1);
        }
        Object value = context.getReference(name, token);
        if (subKey != null) {
            if (!(value instanceof PMessage)) {
                throw new ConfigException(token, "Reference name " + key + " not declared", new Object[0]);
            }
            try {
                return ConfigUtil.getInMessage((PMessage)value, subKey, null);
            }
            catch (ConfigException e) {
                throw new ConfigException(token, e.getMessage(), new Object[0]).initCause((Throwable)((Object)e));
            }
        }
        return value;
    }

    private void warn(Path file, ConfigToken token, String format, Object ... args) {
        this.warningHandler.accept(new ConfigWarning(token, format, args).setFile(file.getFileName().toString()));
    }
}

