/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.parser.ConfigException;
import net.morimekta.providence.config.parser.ConfigToken;
import net.morimekta.providence.config.parser.ConfigUtil;

class ConfigContext {
    private final Set<String> includeAliases;
    private final Map<String, Object> references = new HashMap<String, Object>();
    private final Map<String, ConfigException> referenceExceptions = new HashMap<String, ConfigException>();

    ConfigContext() {
        this.includeAliases = new HashSet<String>();
    }

    boolean containsReference(String name) {
        return this.referenceExceptions.containsKey(name) || this.references.containsKey(name);
    }

    void setInclude(String alias, PMessage include) {
        this.references.put(alias, include);
        this.includeAliases.add(alias);
    }

    String initReference(ConfigToken token) throws ConfigException {
        String reference = token.toString();
        if (ConfigUtil.RESERVED_WORDS.contains(reference)) {
            throw new ConfigException(token, "Trying to assign reference id '%s', which is reserved.", reference);
        }
        ConfigException ex = this.referenceExceptions.get(reference);
        if (ex != null) {
            if (this.references.containsKey(reference)) {
                throw new ConfigException(token, "Trying to reassign reference '%s', original at line %d", reference, ex.getLineNo()).initCause((Throwable)((Object)ex));
            }
            throw new ConfigException(token, "Trying to reassign reference '%s' while calculating it's value, original at line %d", reference, ex.getLineNo()).initCause((Throwable)((Object)ex));
        }
        if (this.includeAliases.contains(reference)) {
            throw new ConfigException(token, "Trying to reassign include alias '%s' to reference.", reference);
        }
        this.referenceExceptions.put(reference, new ConfigException(token, "Original reference", new Object[0]));
        return reference;
    }

    Object setReference(String reference, Object value) {
        if (reference != null) {
            if (!this.referenceExceptions.containsKey(reference)) {
                throw new RuntimeException("Reference '" + reference + "' not initialised");
            }
            this.references.put(reference, value);
        }
        return value;
    }

    Object getReference(String reference, ConfigToken token) throws ConfigException {
        if (ConfigUtil.RESERVED_WORDS.contains(reference)) {
            return null;
        }
        if (this.references.containsKey(reference)) {
            return this.references.get(reference);
        }
        ConfigException ex = this.referenceExceptions.get(reference);
        if (ex != null) {
            throw new ConfigException(token, "Trying to reference '%s' while it's being defined, original at line %d", reference, ex.getLineNo());
        }
        throw new ConfigException(token, "No such reference '%s'", reference);
    }
}

