/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.ConfigListener;
import net.morimekta.providence.config.ConfigSupplier;
import net.morimekta.providence.config.impl.ReferenceConfigSupplier;
import net.morimekta.providence.config.parser.ConfigException;
import net.morimekta.providence.descriptor.PField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpdatingConfigSupplier<M extends PMessage<M>>
implements ConfigSupplier<M> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdatingConfigSupplier.class);
    private final AtomicReference<M> instance = new AtomicReference();
    private final ArrayList<Reference<ConfigListener<M>>> listeners = new ArrayList();
    private final Clock clock;
    private final AtomicLong lastUpdateTimestamp;

    protected UpdatingConfigSupplier(@Nonnull Clock clock) {
        this.clock = clock;
        this.lastUpdateTimestamp = new AtomicLong(0L);
    }

    @Override
    @Nonnull
    public final M get() {
        PMessage config = (PMessage)this.instance.get();
        if (config == null) {
            throw new IllegalStateException("No config instance");
        }
        return (M)config;
    }

    @Override
    public <RM extends PMessage<RM>> ConfigSupplier<RM> reference(PField ... fields) throws ConfigException {
        return new ReferenceConfigSupplier(this, this.clock, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(@Nonnull ConfigListener<M> listener) {
        UpdatingConfigSupplier updatingConfigSupplier = this;
        synchronized (updatingConfigSupplier) {
            this.listeners.removeIf(ref -> ref.get() == listener || ref.get() == null);
            this.listeners.add(new WeakReference<ConfigListener<M>>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(@Nonnull ConfigListener<M> listener) {
        UpdatingConfigSupplier updatingConfigSupplier = this;
        synchronized (updatingConfigSupplier) {
            this.listeners.removeIf(ref -> ref.get() == null || ref.get() == listener);
        }
    }

    @Override
    public long configTimestamp() {
        return this.lastUpdateTimestamp.get();
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void set(M config) {
        ArrayList<Reference<ConfigListener<M>>> iterateOver;
        UpdatingConfigSupplier updatingConfigSupplier = this;
        synchronized (updatingConfigSupplier) {
            PMessage old = (PMessage)this.instance.get();
            if (Objects.equals(old, config)) {
                return;
            }
            this.instance.set(config);
            this.lastUpdateTimestamp.set(this.clock.millis());
            this.listeners.removeIf(ref -> ref.get() == null);
            iterateOver = new ArrayList<Reference<ConfigListener<M>>>(this.listeners);
        }
        iterateOver.forEach((Consumer<Reference<ConfigListener<M>>>)((Consumer<Reference>)ref -> {
            ConfigListener listener = (ConfigListener)ref.get();
            if (listener != null) {
                try {
                    listener.onConfigChange(config);
                }
                catch (Exception e) {
                    LOGGER.warn("Unhandled exception on config change", (Throwable)e);
                }
            }
        }));
    }
}

