/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.testing;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.impl.UpdatingConfigSupplier;
import net.morimekta.providence.config.parser.ConfigException;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.providence.serializer.JsonSerializerException;
import net.morimekta.providence.serializer.PrettySerializer;
import net.morimekta.providence.serializer.pretty.PrettyException;

public class TestConfigSupplier<M extends PMessage<M>>
extends UpdatingConfigSupplier<M> {
    private final PMessageDescriptor<M> descriptor;

    public TestConfigSupplier(@Nonnull String initialResource, PMessageDescriptor<M> descriptor) throws ConfigException {
        this(TestConfigSupplier.loadInternal(initialResource, descriptor));
    }

    public TestConfigSupplier(@Nonnull M initialConfig) {
        this(Clock.systemUTC(), initialConfig);
    }

    public TestConfigSupplier(@Nonnull Clock clock, @Nonnull M initialConfig) {
        super(clock);
        this.descriptor = initialConfig.descriptor();
        this.set(initialConfig);
    }

    public void testUpdate(@Nonnull M newInstance) {
        this.set(newInstance);
    }

    public void testUpdate(@Nonnull String resourceName) throws ConfigException {
        this.testUpdate(TestConfigSupplier.loadInternal(resourceName, this.descriptor));
    }

    public String toString() {
        return this.getName() + "{" + this.descriptor.getQualifiedName() + "}";
    }

    @Override
    public String getName() {
        return "TestConfig";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <Message extends PMessage<Message>> Message loadInternal(String resourceName, PMessageDescriptor<Message> descriptor) throws ConfigException {
        JsonSerializer serializer;
        String suffix;
        int lastDot = resourceName.lastIndexOf(".");
        if (lastDot < 1) {
            throw new ConfigException("No file ending, or no resource file name: " + resourceName, new Object[0]);
        }
        int lastSlash = resourceName.lastIndexOf("/");
        String fileName = resourceName;
        if (lastSlash >= 0) {
            fileName = resourceName.substring(lastSlash + 1);
        }
        switch (suffix = resourceName.substring(lastDot).toLowerCase(Locale.US)) {
            case ".jsn": 
            case ".json": {
                serializer = new JsonSerializer();
                break;
            }
            case ".cfg": 
            case ".cnf": 
            case ".config": {
                serializer = new PrettySerializer().config();
                break;
            }
            default: {
                throw new ConfigException("Unrecognized resource config type: %s (%s)", suffix, resourceName);
            }
        }
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        InputStream in = classLoader.getResourceAsStream(resourceName);
        if (in == null && (in = TestConfigSupplier.class.getResourceAsStream(resourceName)) == null) {
            throw new ConfigException("No such config resource: %s", resourceName);
        }
        try (BufferedInputStream bin = new BufferedInputStream(in);){
            PMessage pMessage = serializer.deserialize((InputStream)bin, descriptor);
            return (Message)pMessage;
        }
        catch (ConfigException e) {
            throw e.setFile(fileName);
        }
        catch (PrettyException se) {
            if (se.getLine() == null) throw new ConfigException(se, se.getMessage(), new Object[0]).setFile(fileName);
            throw new ConfigException(se).setFile(fileName);
        }
        catch (JsonSerializerException se) {
            if (se.getLine() == null) throw new ConfigException(se, se.getMessage(), new Object[0]).setFile(fileName);
            throw new ConfigException(se).setFile(fileName);
        }
        catch (IOException se) {
            throw new ConfigException(se, se.getMessage(), new Object[0]).setFile(fileName);
        }
    }
}

