/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.impl;

import java.time.Clock;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PType;
import net.morimekta.providence.config.ConfigListener;
import net.morimekta.providence.config.ConfigSupplier;
import net.morimekta.providence.config.impl.UpdatingConfigSupplier;
import net.morimekta.providence.config.parser.ConfigException;
import net.morimekta.providence.config.util.UncheckedConfigException;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;

public class ReferenceConfigSupplier<RefMessage extends PMessage<RefMessage>, ParentMessage extends PMessage<ParentMessage>>
extends UpdatingConfigSupplier<RefMessage> {
    private final String referencePath;
    private final ConfigSupplier<ParentMessage> parent;

    public ReferenceConfigSupplier(ConfigSupplier<ParentMessage> parent, Clock clock, PField ... fieldRefs) throws ConfigException {
        super(clock);
        this.parent = parent;
        this.referencePath = Arrays.stream(fieldRefs).map(PField::getName).collect(Collectors.joining("."));
        ConfigListener<PMessage> listener = updated -> {
            try {
                this.set(ReferenceConfigSupplier.getReference(updated, fieldRefs));
            }
            catch (ConfigException e) {
                throw new UncheckedConfigException(e);
            }
        };
        ReferenceConfigSupplier.validate(((PMessage)parent.get()).descriptor(), fieldRefs);
        parent.addListener(listener);
        this.set(ReferenceConfigSupplier.getReference((PMessage)parent.get(), fieldRefs));
    }

    public String toString() {
        return "ReferenceConfig{" + this.referencePath + ", parent=" + this.parent.getName() + "}";
    }

    @Override
    public String getName() {
        return "ReferenceConfig{" + this.referencePath + "}";
    }

    static <RM extends PMessage<RM>> RM getReference(PMessage instance, PField ... fields) throws ConfigException {
        PMessage current = instance;
        for (PField field : fields) {
            if (!current.has(field.getId())) {
                if (!field.hasDefaultValue()) {
                    throw new ConfigException("Field %s in %s is missing and has no default, from %s", field.getName(), current.descriptor().getQualifiedName(), ReferenceConfigSupplier.referencePath(fields));
                }
                current = (PMessage)field.getDefaultValue();
                continue;
            }
            current = (PMessage)current.get(field.getId());
        }
        return (RM)current;
    }

    static PField[] validate(PMessageDescriptor descriptor, PField ... fields) throws ConfigException {
        PMessageDescriptor current = descriptor;
        for (PField field : fields) {
            if (!field.equals(current.findFieldByName(field.getName()))) {
                throw new ConfigException("Bad field %s in %s from %s", field.getName(), current.getQualifiedName(), ReferenceConfigSupplier.referencePath(fields));
            }
            if (field.getType() != PType.MESSAGE) {
                throw new ConfigException("Field %s in %s is not a message, from %s", field.getName(), current.getQualifiedName(), ReferenceConfigSupplier.referencePath(fields));
            }
            current = (PMessageDescriptor)field.getDescriptor();
        }
        return fields;
    }

    private static String referencePath(PField ... fields) {
        return Arrays.stream(fields).map(PField::getName).collect(Collectors.joining("."));
    }
}

