/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.parser;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.morimekta.providence.config.parser.ConfigTokenType;
import net.morimekta.util.lexer.Token;

public class ConfigToken
extends Token<ConfigTokenType> {
    public static final char kMessageStart = '{';
    public static final char kMessageEnd = '}';
    public static final char kKeyValueSep = ':';
    public static final char kFieldValueSep = '=';
    public static final char kParamsStart = '(';
    public static final char kParamsEnd = ')';
    public static final char kListStart = '[';
    public static final char kListEnd = ']';
    public static final char kEntrySep = ',';
    public static final char kLineSep = ';';
    public static final char kIdentifierSep = '.';
    public static final String B64 = "b64";
    public static final String HEX = "hex";
    private static final Pattern RE_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_QUALIFIED_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*[.][_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_DOUBLE_QUALIFIED_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*[.][_a-zA-Z][_a-zA-Z0-9]*[.][_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_REFERENCE_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*([.][_a-zA-Z][_a-zA-Z0-9]*)*");
    private static final Pattern RE_INTEGER = Pattern.compile("-?(0|[1-9][0-9]*|0[0-7]+|0x[0-9a-fA-F]+)");
    private static final Pattern RE_REAL = Pattern.compile("-?(0?\\.[0-9]+|[1-9][0-9]*\\.[0-9]*)([eE][+-]?[0-9][0-9]*)?");

    public ConfigToken(char[] fb, int off, int len, @Nonnull ConfigTokenType type, int lineNo, int linePos) {
        super(fb, off, len, (Object)type, lineNo, linePos);
    }

    public boolean isString() {
        return this.type == ConfigTokenType.STRING;
    }

    public boolean isIdentifier() {
        return RE_IDENTIFIER.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isDoubleQualifiedIdentifier() {
        return RE_DOUBLE_QUALIFIED_IDENTIFIER.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isQualifiedIdentifier() {
        return RE_QUALIFIED_IDENTIFIER.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isReferenceIdentifier() {
        return RE_REFERENCE_IDENTIFIER.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isInteger() {
        return RE_INTEGER.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isReal() {
        return RE_REAL.matcher((CharSequence)((Object)this)).matches();
    }
}

