/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.config.ProvidenceConfigException;
import net.morimekta.providence.config.impl.ProvidenceConfigContext;
import net.morimekta.providence.config.impl.ProvidenceConfigUtil;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.serializer.pretty.Token;
import net.morimekta.providence.serializer.pretty.Tokenizer;
import net.morimekta.providence.serializer.pretty.TokenizerException;
import net.morimekta.providence.util.TypeRegistry;
import net.morimekta.util.Binary;
import net.morimekta.util.Pair;
import net.morimekta.util.io.Utf8StreamReader;

public class ProvidenceConfigParser {
    private final TypeRegistry registry;
    private final boolean strict;

    public ProvidenceConfigParser(TypeRegistry registry, boolean strict) {
        this.registry = registry;
        this.strict = strict;
    }

    @Nonnull
    <M extends PMessage<M, F>, F extends PField> Pair<M, Set<String>> parseConfig(@Nonnull Path configFile, @Nullable M parent) throws ProvidenceConfigException {
        try {
            configFile = ProvidenceConfigUtil.canonicalFileLocation(configFile);
        }
        catch (IOException e) {
            throw new ProvidenceConfigException(e, "Unable to resolve config file " + configFile, new Object[0]).setFile(configFile.getFileName().toString());
        }
        Pair<M, Set<String>> result = this.checkAndParseInternal(configFile, parent, new String[0]);
        if (result == null) {
            throw new ProvidenceConfigException("No config: " + configFile.toString(), new Object[0]).setFile(configFile.getFileName().toString());
        }
        return result;
    }

    private <M extends PMessage<M, F>, F extends PField> Pair<M, Set<String>> checkAndParseInternal(@Nonnull Path configFile, @Nullable M parent, String ... includeStack) throws ProvidenceConfigException {
        try {
            String canonicalFile = ProvidenceConfigUtil.readCanonicalPath(configFile).toString();
            ArrayList<String> stackList = new ArrayList<String>();
            Collections.addAll(stackList, includeStack);
            if (Arrays.binarySearch(includeStack, canonicalFile) >= 0) {
                stackList.add(canonicalFile);
                throw new ProvidenceConfigException("Circular includes detected: " + String.join((CharSequence)" -> ", stackList.stream().map(p -> new File((String)p).getName()).collect(Collectors.toList())), new Object[0]);
            }
            stackList.add(canonicalFile);
            return this.parseConfigRecursively(configFile, parent, stackList.toArray(new String[0]));
        }
        catch (IOException e) {
            if (e instanceof ProvidenceConfigException) {
                ProvidenceConfigException pce = (ProvidenceConfigException)((Object)e);
                if (pce.getFile() == null) {
                    pce.setFile(configFile.getFileName().toString());
                }
                throw pce;
            }
            if (e instanceof TokenizerException) {
                TokenizerException te = (TokenizerException)((Object)e);
                if (te.getFile() == null) {
                    te.setFile(configFile.getFileName().toString());
                }
                throw new ProvidenceConfigException(te);
            }
            throw new ProvidenceConfigException(e, e.getMessage(), new Object[0]).setFile(configFile.getFileName().toString());
        }
    }

    private <M extends PMessage<M, F>, F extends PField> Pair<M, Set<String>> parseConfigRecursively(@Nonnull Path file, M parent, String[] stack) throws IOException {
        Tokenizer tokenizer;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file.toFile()));){
            tokenizer = new Tokenizer((Reader)new Utf8StreamReader((InputStream)in), 2048, true);
        }
        ProvidenceConfigContext context = new ProvidenceConfigContext();
        TreeSet<String> includedFilePaths = new TreeSet<String>();
        includedFilePaths.add(ProvidenceConfigUtil.canonicalFileLocation(file).toString());
        ProvidenceConfigUtil.Stage lastStage = ProvidenceConfigUtil.Stage.INCLUDES;
        Object result = null;
        Token token = tokenizer.peek();
        while (token != null) {
            tokenizer.next();
            if (lastStage == ProvidenceConfigUtil.Stage.MESSAGE) {
                throw new TokenizerException(token, "Unexpected token '" + token.asString() + "', expected end of file.", new Object[0]).setLine(tokenizer.getLine());
            }
            if ("include".equals(token.asString())) {
                PMessage included;
                if (lastStage != ProvidenceConfigUtil.Stage.INCLUDES) {
                    throw new TokenizerException(token, "Include added after defines or message. Only one def block allowed.", new Object[0]).setLine(tokenizer.getLine());
                }
                token = tokenizer.expectLiteral("file to be included");
                String includedFilePath = token.decodeLiteral(this.strict);
                try {
                    Path includedFile = ProvidenceConfigUtil.resolveFile(file, includedFilePath);
                    Pair<Object, Set<String>> tmp = this.checkAndParseInternal(includedFile, null, stack);
                    if (tmp != null) {
                        includedFilePaths.add(includedFile.toString());
                        includedFilePaths.addAll((Collection)tmp.second);
                        included = (PMessage)tmp.first;
                    } else {
                        included = null;
                    }
                }
                catch (FileNotFoundException e) {
                    throw new TokenizerException(token, "Included file \"%s\" not found.", new Object[]{includedFilePath}).setLine(tokenizer.getLine());
                }
                token = tokenizer.expectIdentifier("the token 'as'");
                if (!"as".equals(token.asString())) {
                    throw new TokenizerException(token, "Expected token 'as' after included file \"%s\".", new Object[]{includedFilePath}).setLine(tokenizer.getLine());
                }
                token = tokenizer.expectIdentifier("Include alias");
                String alias = token.asString();
                if (ProvidenceConfigUtil.RESERVED_WORDS.contains(alias)) {
                    throw new TokenizerException(token, "Alias \"%s\" is a reserved word.", new Object[]{alias}).setLine(tokenizer.getLine());
                }
                if (context.containsReference(alias)) {
                    throw new TokenizerException(token, "Alias \"%s\" is already used.", new Object[]{alias}).setLine(tokenizer.getLine());
                }
                context.setInclude(alias, included);
            } else if ("def".equals(token.asString())) {
                lastStage = ProvidenceConfigUtil.Stage.DEFINES;
                this.parseDefinitions(context, tokenizer);
            } else if (token.isQualifiedIdentifier()) {
                PMessageDescriptor descriptor;
                lastStage = ProvidenceConfigUtil.Stage.MESSAGE;
                try {
                    descriptor = (PMessageDescriptor)this.registry.getDeclaredType(token.asString());
                }
                catch (IllegalArgumentException e) {
                    if (this.strict || stack.length == 1) {
                        throw new TokenizerException(token, "Unknown declared type: %s", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                    }
                    return null;
                }
                result = this.parseConfigMessage(tokenizer, context, descriptor.builder(), parent, file);
            } else {
                throw new TokenizerException(token, "Unexpected token '" + token.asString() + "'. Expected include, defines or message type", new Object[0]).setLine(tokenizer.getLine());
            }
            token = tokenizer.peek();
        }
        if (result == null) {
            throw new TokenizerException("No message in config: " + file.getFileName().toString(), new Object[0]);
        }
        return Pair.create(result, includedFilePaths);
    }

    private void parseDefinitions(ProvidenceConfigContext context, Tokenizer tokenizer) throws IOException {
        Token token = tokenizer.expect("defines group start or identifier");
        if (token.isIdentifier()) {
            String name = context.initReference(token, tokenizer);
            tokenizer.expectSymbol("def value sep", new char[]{'='});
            context.setReference(name, this.parseDefinitionValue(context, tokenizer));
        } else if (token.isSymbol('{')) {
            token = tokenizer.expect("define or end");
            while (!token.isSymbol('}')) {
                if (!token.isIdentifier()) {
                    throw new TokenizerException(token, "Token '%s' is not valid reference name.", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                }
                String name = context.initReference(token, tokenizer);
                tokenizer.expectSymbol("def value sep", new char[]{'='});
                context.setReference(name, this.parseDefinitionValue(context, tokenizer));
                token = tokenizer.expect("next define or end");
            }
        } else {
            throw new TokenizerException(token, "Unexpected token after def: '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine());
        }
    }

    private Object parseDefinitionValue(ProvidenceConfigContext context, Tokenizer tokenizer) throws IOException {
        Token token = tokenizer.expect("Start of def value");
        if (token.isReal()) {
            return Double.parseDouble(token.asString());
        }
        if (token.isInteger()) {
            return Long.parseLong(token.asString());
        }
        if (token.isStringLiteral()) {
            return token.decodeLiteral(this.strict);
        }
        if ("true".equalsIgnoreCase(token.asString())) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(token.asString())) {
            return Boolean.FALSE;
        }
        if ("b64".equals(token.asString())) {
            tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
            return Binary.fromBase64((String)tokenizer.readBinary(')'));
        }
        if ("hex".equals(token.asString())) {
            tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
            return Binary.fromHexString((String)tokenizer.readBinary(')'));
        }
        if (token.isDoubleQualifiedIdentifier()) {
            String id = token.asString();
            int l = id.lastIndexOf(46);
            try {
                PEnumDescriptor ed = this.registry.getEnumType(id.substring(0, l));
                PEnumValue val = ed.findByName(id.substring(l + 1));
                if (val == null && this.strict) {
                    throw new TokenizerException(token, "Unknown %s value: %s", new Object[]{id.substring(0, l), id.substring(l + 1)}).setLine(tokenizer.getLine());
                }
                return val;
            }
            catch (IllegalArgumentException e) {
                if (this.strict) {
                    throw new TokenizerException(token, "Unknown enum identifier: %s", new Object[]{id.substring(0, l)}).setLine(tokenizer.getLine());
                }
                ProvidenceConfigUtil.consumeValue(context, tokenizer, token);
            }
            catch (ClassCastException e) {
                throw new TokenizerException(token, "Identifier " + id + " does not reference an enum, from " + token.asString(), new Object[0]).setLine(tokenizer.getLine());
            }
        }
        if (token.isQualifiedIdentifier()) {
            PMessageDescriptor descriptor;
            try {
                descriptor = this.registry.getMessageType(token.asString());
            }
            catch (IllegalArgumentException e) {
                if (this.strict) {
                    throw new TokenizerException(token, "Unknown declared type: %s", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                }
                ProvidenceConfigUtil.consumeValue(context, tokenizer, token);
                return null;
            }
            PMessageBuilder builder = descriptor.builder();
            if (tokenizer.expectSymbol("message start or inherits", new char[]{'{', ':'}) == ':') {
                token = tokenizer.expect("inherits reference");
                PMessage inheritsFrom = (PMessage)ProvidenceConfigParser.resolve(context, token, tokenizer, (PDescriptor)descriptor);
                if (inheritsFrom == null) {
                    throw new TokenizerException(token, "Inheriting from null reference: %s", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                }
                builder.merge(inheritsFrom);
                tokenizer.expectSymbol("message start", new char[]{'{'});
            }
            return this.parseMessage(tokenizer, context, builder);
        }
        throw new TokenizerException(token, "Invalid define value " + token.asString(), new Object[0]).setLine(tokenizer.getLine());
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <M extends PMessage<M, F>, F extends PField> M parseConfigMessage(Tokenizer tokenizer, ProvidenceConfigContext context, PMessageBuilder<M, F> builder, M parent, Path file) throws IOException {
        if (tokenizer.expectSymbol("extension marker", new char[]{':', '{'}) == ':') {
            Token token = tokenizer.expect("extension object");
            if (parent != null) {
                throw new TokenizerException(token, "Config in '" + file.getFileName().toString() + "' has both defined parent and inherits from", new Object[0]).setLine(tokenizer.getLine()).setFile(file.getFileName().toString());
            }
            if (!token.isReferenceIdentifier()) throw new TokenizerException(token, "Unexpected token " + token.asString() + ", expected reference identifier", new Object[0]).setLine(tokenizer.getLine());
            try {
                builder.merge((PMessage)ProvidenceConfigParser.resolveRequired(context, token, tokenizer, (PDescriptor)builder.descriptor()));
            }
            catch (ClassCastException e) {
                throw new TokenizerException(token, "Config type mismatch, expected  ", new Object[0]).setLine(tokenizer.getLine());
            }
            catch (ProvidenceConfigException e) {
                throw new TokenizerException(token, e.getMessage(), new Object[0]).setLine(tokenizer.getLine());
            }
            tokenizer.expectSymbol("object begin", new char[]{'{'});
            return this.parseMessage(tokenizer, context, builder);
        }
        if (parent == null) return this.parseMessage(tokenizer, context, builder);
        if (!builder.descriptor().equals((Object)parent.descriptor())) {
            throw new ProvidenceConfigException("Loaded config type %s does not match parent %s", parent.descriptor().getQualifiedName(), builder.descriptor().getQualifiedName());
        }
        builder.merge(parent);
        return this.parseMessage(tokenizer, context, builder);
    }

    private <M extends PMessage<M, F>, F extends PField> M parseMessage(@Nonnull Tokenizer tokenizer, @Nonnull ProvidenceConfigContext context, @Nonnull PMessageBuilder<M, F> builder) throws IOException {
        PMessageDescriptor descriptor = builder.descriptor();
        Token token = tokenizer.expect("object end or field");
        while (!token.isSymbol('}')) {
            Token ref;
            String reference;
            if (!token.isIdentifier()) {
                throw new TokenizerException(token, "Invalid field name: " + token.asString(), new Object[0]).setLine(tokenizer.getLine());
            }
            PField field = descriptor.findFieldByName(token.asString());
            if (field == null) {
                if (this.strict) {
                    throw new TokenizerException("No such field " + token.asString() + " in " + descriptor.getQualifiedName(), new Object[0]).setLine(tokenizer.getLine());
                }
                token = tokenizer.expect("field value sep, message start or reference start");
                if (token.isSymbol('&')) {
                    context.setReference(context.initReference(tokenizer.expectIdentifier("reference name"), tokenizer), null);
                    token = tokenizer.expect("field value sep or message start");
                }
                if (token.isSymbol('=')) {
                    token = tokenizer.expect("value declaration");
                } else if (!token.isSymbol('{')) {
                    throw new TokenizerException(token, "Expected field-value separator or inherited message", new Object[0]).setLine(tokenizer.getLine());
                }
                ProvidenceConfigUtil.consumeValue(context, tokenizer, token);
                token = ProvidenceConfigUtil.nextNotLineSep(tokenizer, "field or message end");
                continue;
            }
            if (field.getType() == PType.MESSAGE) {
                PMessageBuilder bld;
                reference = null;
                char symbol = tokenizer.expectSymbol("Message assigner or start", new char[]{'=', '{', '&'});
                if (symbol == '&') {
                    ref = tokenizer.expectIdentifier("reference name");
                    if (this.strict) {
                        throw tokenizer.failure(ref, "Reusable objects are not allowed in strict mode.", new Object[0]);
                    }
                    reference = context.initReference(ref, tokenizer);
                    symbol = tokenizer.expectSymbol("Message assigner or start after " + reference, new char[]{'=', '{'});
                }
                if (symbol == '=') {
                    token = tokenizer.expect("reference or message start");
                    if ("undefined".equals(token.asString())) {
                        builder.clear(field.getId());
                        context.setReference(reference, null);
                        token = ProvidenceConfigUtil.nextNotLineSep(tokenizer, "field or message end");
                        continue;
                    }
                    bld = ((PMessageDescriptor)field.getDescriptor()).builder();
                    if (token.isReferenceIdentifier()) {
                        try {
                            PMessage ref2 = (PMessage)ProvidenceConfigParser.resolve(context, token, tokenizer, field.getDescriptor());
                            if (ref2 != null) {
                                bld.merge(ref2);
                            } else {
                                if (tokenizer.peek().isSymbol('{')) {
                                    throw new TokenizerException(token, "Inherit from unknown reference %s", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                                }
                                if (this.strict) {
                                    throw new TokenizerException(token, "Unknown reference %s", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                                }
                            }
                        }
                        catch (ProvidenceConfigException e) {
                            throw new TokenizerException(token, "Unknown inherited reference '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                        }
                        token = tokenizer.expect("after message reference");
                        if (!token.isSymbol('{')) {
                            builder.set(field.getId(), context.setReference(reference, bld.build()));
                            continue;
                        }
                    } else if (!token.isSymbol('{')) {
                        throw new TokenizerException(token, "Unexpected token " + token.asString() + ", expected message start", new Object[0]).setLine(tokenizer.getLine());
                    }
                } else {
                    bld = builder.mutator(field.getId());
                }
                builder.set(field.getId(), context.setReference(reference, this.parseMessage(tokenizer, context, bld)));
            } else if (field.getType() == PType.MAP) {
                token = tokenizer.expect("field sep or value start");
                Map baseValue = new LinkedHashMap();
                String reference2 = null;
                if (token.isSymbol('&')) {
                    ref = tokenizer.expectIdentifier("reference name");
                    if (this.strict) {
                        throw tokenizer.failure(ref, "Reusable objects are not allowed in strict mode.", new Object[0]);
                    }
                    reference2 = context.initReference(ref, tokenizer);
                    token = tokenizer.expect("field sep or value start");
                }
                if (token.isSymbol('=')) {
                    token = tokenizer.expect("field id or start");
                    if ("undefined".equals(token.asString())) {
                        builder.clear(field.getId());
                        context.setReference(reference2, null);
                        token = tokenizer.expect("message end or field");
                        continue;
                    }
                    if (token.isReferenceIdentifier()) {
                        try {
                            baseValue = (Map)ProvidenceConfigParser.resolve(context, token, tokenizer, field.getDescriptor());
                        }
                        catch (ProvidenceConfigException e) {
                            throw new TokenizerException(token, e.getMessage(), new Object[0]).setLine(tokenizer.getLine());
                        }
                        token = tokenizer.expect("map start or next field");
                        if (!token.isSymbol('{')) {
                            builder.set(field.getId(), context.setReference(reference2, baseValue));
                            continue;
                        }
                        if (baseValue == null) {
                            baseValue = new LinkedHashMap();
                        }
                    }
                } else {
                    baseValue.putAll((Map)((PMessage)builder.build()).get(field.getId()));
                }
                if (!token.isSymbol('{')) {
                    throw new TokenizerException(token, "Expected map start, but got '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                }
                Map map = this.parseMapValue(tokenizer, context, (PMap)field.getDescriptor(), baseValue);
                builder.set(field.getId(), context.setReference(reference2, map));
            } else {
                reference = null;
                if (tokenizer.expectSymbol("field value sep", new char[]{'=', '&'}) == '&') {
                    Token ref3 = tokenizer.expectIdentifier("reference name");
                    if (this.strict) {
                        throw tokenizer.failure(ref3, "Reusable objects are not allowed in strict mode.", new Object[0]);
                    }
                    reference = context.initReference(ref3, tokenizer);
                    tokenizer.expectSymbol("field value sep", new char[]{'='});
                }
                if ("undefined".equals((token = tokenizer.expect("field value")).asString())) {
                    builder.clear(field.getId());
                    context.setReference(reference, null);
                } else {
                    Object value = this.parseFieldValue(token, tokenizer, context, field.getDescriptor(), this.strict);
                    builder.set(field.getId(), context.setReference(reference, value));
                }
            }
            token = ProvidenceConfigUtil.nextNotLineSep(tokenizer, "field or message end");
        }
        return (M)((PMessage)builder.build());
    }

    private Map parseMapValue(Tokenizer tokenizer, ProvidenceConfigContext context, PMap descriptor, Map builder) throws IOException {
        Token next = tokenizer.expect("map key or end");
        while (!next.isSymbol('}')) {
            Object key = this.parseFieldValue(next, tokenizer, context, descriptor.keyDescriptor(), true);
            tokenizer.expectSymbol("map key value sep", new char[]{':'});
            next = tokenizer.expect("map value");
            if ("undefined".equals(next.asString())) {
                builder.remove(key);
            } else {
                Object value = context.containsReference(next.asString()) ? context.getReference(next.asString(), next, tokenizer) : this.parseFieldValue(next, tokenizer, context, descriptor.itemDescriptor(), this.strict);
                if (value != null) {
                    builder.put(key, value);
                }
            }
            if (!(next = tokenizer.expect("map key, end or sep")).isSymbol(',')) continue;
            next = tokenizer.expect("map key or end");
        }
        return descriptor.builder().putAll(builder).build();
    }

    private Object parseFieldValue(Token next, Tokenizer tokenizer, ProvidenceConfigContext context, PDescriptor descriptor, boolean requireEnumValue) throws IOException {
        try {
            switch (descriptor.getType()) {
                case BOOL: {
                    if ("true".equals(next.asString())) {
                        return true;
                    }
                    if ("false".equals(next.asString())) {
                        return false;
                    }
                    if (next.isReferenceIdentifier()) {
                        return ProvidenceConfigParser.resolve(context, next, tokenizer, descriptor);
                    }
                    break;
                }
                case BYTE: {
                    if (next.isReferenceIdentifier()) {
                        return ProvidenceConfigParser.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isInteger()) {
                        return (byte)next.parseInteger();
                    }
                    break;
                }
                case I16: {
                    if (next.isReferenceIdentifier()) {
                        return ProvidenceConfigParser.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isInteger()) {
                        return (short)next.parseInteger();
                    }
                    break;
                }
                case I32: {
                    if (next.isReferenceIdentifier()) {
                        return ProvidenceConfigParser.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isInteger()) {
                        return (int)next.parseInteger();
                    }
                    break;
                }
                case I64: {
                    if (next.isReferenceIdentifier()) {
                        return ProvidenceConfigParser.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isInteger()) {
                        return next.parseInteger();
                    }
                    break;
                }
                case DOUBLE: {
                    if (next.isReferenceIdentifier()) {
                        return ProvidenceConfigParser.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isInteger() || next.isReal()) {
                        return next.parseDouble();
                    }
                    break;
                }
                case STRING: {
                    if (next.isReferenceIdentifier()) {
                        return ProvidenceConfigParser.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isStringLiteral()) {
                        return next.decodeLiteral(this.strict);
                    }
                    break;
                }
                case BINARY: {
                    if ("b64".equals(next.asString())) {
                        tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                        return Binary.fromBase64((String)tokenizer.readBinary(')'));
                    }
                    if ("hex".equals(next.asString())) {
                        tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                        return Binary.fromHexString((String)tokenizer.readBinary(')'));
                    }
                    if (next.isReferenceIdentifier()) {
                        return ProvidenceConfigParser.resolve(context, next, tokenizer, descriptor);
                    }
                    break;
                }
                case ENUM: {
                    PEnumValue value;
                    PEnumDescriptor ed = (PEnumDescriptor)descriptor;
                    String name = next.asString();
                    if (next.isInteger()) {
                        value = ed.findById((int)next.parseInteger());
                    } else if (next.isIdentifier()) {
                        value = ed.findByName(name);
                        if (value == null && context.containsReference(name)) {
                            value = (PEnumValue)ProvidenceConfigParser.resolve(context, next, tokenizer, (PDescriptor)ed);
                        }
                    } else {
                        if (!next.isReferenceIdentifier()) break;
                        value = (PEnumValue)ProvidenceConfigParser.resolve(context, next, tokenizer, descriptor);
                    }
                    if (value == null && (this.strict || requireEnumValue)) {
                        PEnumValue option = null;
                        if (next.isIdentifier()) {
                            for (PEnumValue o : ed.getValues()) {
                                if (!o.getName().equalsIgnoreCase(name)) continue;
                                option = o;
                                break;
                            }
                        }
                        if (option != null) {
                            throw new TokenizerException(next, "No such enum value '%s' for %s, did you mean '%s'?", new Object[]{name, ed.getQualifiedName(), option.getName()}).setLine(tokenizer.getLine());
                        }
                        throw new TokenizerException(next, "No such enum value '%s' for %s.", new Object[]{name, ed.getQualifiedName()}).setLine(tokenizer.getLine());
                    }
                    return value;
                }
                case MESSAGE: {
                    if (next.isReferenceIdentifier()) {
                        return ProvidenceConfigParser.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isSymbol('{')) {
                        return this.parseMessage(tokenizer, context, ((PMessageDescriptor)descriptor).builder());
                    }
                    break;
                }
                case MAP: {
                    if (next.isReferenceIdentifier()) {
                        Map resolved;
                        try {
                            resolved = (Map)ProvidenceConfigParser.resolve(context, next, tokenizer, descriptor);
                        }
                        catch (ClassCastException e) {
                            throw new TokenizerException(next, "Reference %s is not a map field ", new Object[]{next.asString()}).setLine(tokenizer.getLine());
                        }
                        return resolved;
                    }
                    if (next.isSymbol('{')) {
                        return this.parseMapValue(tokenizer, context, (PMap)descriptor, new LinkedHashMap());
                    }
                    break;
                }
                case SET: {
                    if (next.isReferenceIdentifier()) {
                        return ProvidenceConfigParser.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isSymbol('[')) {
                        PSet ct = (PSet)descriptor;
                        LinkedHashSet<Object> value = new LinkedHashSet<Object>();
                        next = tokenizer.expect("set value or end");
                        while (!next.isSymbol(']')) {
                            Object item = this.parseFieldValue(next, tokenizer, context, ct.itemDescriptor(), this.strict);
                            if (item != null) {
                                value.add(item);
                            }
                            if (tokenizer.expectSymbol("set separator or end", new char[]{',', ']'}) == ']') break;
                            next = tokenizer.expect("set value or end");
                        }
                        return ct.builder().addAll(value).build();
                    }
                    break;
                }
                case LIST: {
                    if (next.isReferenceIdentifier()) {
                        return ProvidenceConfigParser.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isSymbol('[')) {
                        PList ct = (PList)descriptor;
                        PList.Builder builder = ct.builder();
                        next = tokenizer.expect("list value or end");
                        while (!next.isSymbol(']')) {
                            Object item = this.parseFieldValue(next, tokenizer, context, ct.itemDescriptor(), this.strict);
                            if (item != null) {
                                builder.add(item);
                            }
                            if (tokenizer.expectSymbol("list separator or end", new char[]{',', ']'}) == ']') break;
                            next = tokenizer.expect("list value or end");
                        }
                        return builder.build();
                    }
                    break;
                }
                default: {
                    throw new TokenizerException(next, descriptor.getType() + " not supported!", new Object[0]).setLine(tokenizer.getLine());
                }
            }
        }
        catch (ProvidenceConfigException e) {
            throw new TokenizerException(next, e.getMessage(), new Object[0]).setLine(tokenizer.getLine());
        }
        throw new TokenizerException(next, "Unhandled value \"%s\" for type %s", new Object[]{next.asString(), descriptor.getType()}).setLine(tokenizer.getLine());
    }

    @Nonnull
    private static <V> V resolveRequired(ProvidenceConfigContext context, Token token, Tokenizer tokenizer, PDescriptor descriptor) throws TokenizerException {
        V result = ProvidenceConfigParser.resolve(context, token, tokenizer, descriptor);
        if (result == null) {
            throw new TokenizerException("Nu", new Object[0]);
        }
        return result;
    }

    private static <V> V resolve(ProvidenceConfigContext context, Token token, Tokenizer tokenizer, PDescriptor descriptor) throws TokenizerException {
        Object value = ProvidenceConfigParser.resolveAny(context, token, tokenizer);
        if (value == null) {
            return null;
        }
        return (V)ProvidenceConfigUtil.asType(descriptor, value);
    }

    private static Object resolveAny(ProvidenceConfigContext context, Token token, Tokenizer tokenizer) throws TokenizerException {
        String key;
        String name = key = token.asString();
        String subKey = null;
        if (key.contains(".")) {
            int idx = key.indexOf(".");
            name = key.substring(0, idx);
            subKey = key.substring(idx + 1);
        }
        Object value = context.getReference(name, token, tokenizer);
        if (subKey != null) {
            if (!(value instanceof PMessage)) {
                throw new TokenizerException(token, "Reference name " + key + " not declared", new Object[0]);
            }
            try {
                return ProvidenceConfigUtil.getInMessage((PMessage)value, subKey, null);
            }
            catch (ProvidenceConfigException e) {
                throw new TokenizerException(token, e.getMessage(), new Object[0]).setLine(tokenizer.getLine()).initCause((Throwable)((Object)e));
            }
        }
        return value;
    }
}

