/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.FixedConfigSupplier;
import net.morimekta.providence.config.ProvidenceConfigException;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.providence.serializer.JsonSerializerException;
import net.morimekta.providence.serializer.PrettySerializer;
import net.morimekta.providence.serializer.pretty.TokenizerException;

public class ResourceConfigSupplier<Message extends PMessage<Message, Field>, Field extends PField>
extends FixedConfigSupplier<Message, Field> {
    private final String resourceName;

    public ResourceConfigSupplier(String resourceName, PMessageDescriptor<Message, Field> descriptor) throws ProvidenceConfigException {
        this(resourceName, descriptor, Clock.systemUTC());
    }

    public ResourceConfigSupplier(String resourceName, PMessageDescriptor<Message, Field> descriptor, Clock clock) throws ProvidenceConfigException {
        super(ResourceConfigSupplier.loadInternal(resourceName, descriptor), clock.millis());
        this.resourceName = resourceName;
    }

    @Override
    public String getName() {
        return "ResourceConfig{" + this.resourceName + "}";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <Message extends PMessage<Message, Field>, Field extends PField> Message loadInternal(String resourceName, PMessageDescriptor<Message, Field> descriptor) throws ProvidenceConfigException {
        JsonSerializer serializer;
        String suffix;
        int lastDot = resourceName.lastIndexOf(".");
        if (lastDot < 1) {
            throw new ProvidenceConfigException("No file ending, or no resource file name: " + resourceName, new Object[0]);
        }
        int lastSlash = resourceName.lastIndexOf("/");
        String fileName = resourceName;
        if (lastSlash >= 0) {
            fileName = resourceName.substring(lastSlash + 1);
        }
        switch (suffix = resourceName.substring(lastDot).toLowerCase()) {
            case ".jsn": 
            case ".json": {
                serializer = new JsonSerializer();
                break;
            }
            case ".cfg": 
            case ".cnf": 
            case ".config": 
            case ".pvd": 
            case ".providence": {
                serializer = new PrettySerializer().config();
                break;
            }
            default: {
                throw new ProvidenceConfigException(String.format("Unrecognized resource config type: %s (%s)", suffix, resourceName), new Object[0]);
            }
        }
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        InputStream in = classLoader.getResourceAsStream(resourceName);
        if (in == null && (in = ResourceConfigSupplier.class.getResourceAsStream(resourceName)) == null) {
            throw new ProvidenceConfigException("No such config resource: " + resourceName, new Object[0]);
        }
        try {
            try (BufferedInputStream bin = new BufferedInputStream(in);){
                PMessage pMessage = serializer.deserialize((InputStream)bin, descriptor);
                return (Message)pMessage;
            }
            catch (TokenizerException te) {
                throw new ProvidenceConfigException(te);
            }
            catch (JsonSerializerException se) {
                throw new ProvidenceConfigException(se);
            }
            catch (IOException e) {
                throw new ProvidenceConfigException(e, "Unknown serializer exception: " + e.getMessage(), new Object[0]);
            }
        }
        catch (ProvidenceConfigException pce) {
            pce.setFile(fileName);
            throw pce;
        }
    }
}

