/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.impl;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PType;
import net.morimekta.providence.config.ProvidenceConfigException;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.util.Binary;
import net.morimekta.util.Numeric;
import net.morimekta.util.Stringable;
import net.morimekta.util.Strings;

class ProvidenceConfigUtil {
    ProvidenceConfigUtil() {
    }

    static Object getInMessage(PMessage message, String key) throws ProvidenceConfigException {
        return ProvidenceConfigUtil.getInMessage(message, key, null);
    }

    static Object getInMessage(PMessage message, String key, Object defValue) throws ProvidenceConfigException {
        String sub = key;
        PMessageDescriptor descriptor = message.descriptor();
        while (sub.contains(".")) {
            int idx = sub.indexOf(".");
            String name = sub.substring(0, idx);
            sub = sub.substring(idx + 1);
            PField field = descriptor.findFieldByName(name);
            if (field == null) {
                throw new ProvidenceConfigException("Message " + descriptor.getQualifiedName() + " has no field named " + name, new Object[0]);
            }
            PDescriptor fieldDesc = field.getDescriptor();
            if (fieldDesc.getType() != PType.MESSAGE) {
                throw new ProvidenceConfigException("Field '" + name + "' is not of message type in " + descriptor.getQualifiedName(), new Object[0]);
            }
            descriptor = (PMessageDescriptor)fieldDesc;
            if (message == null) continue;
            message = (PMessage)message.get(field.getId());
        }
        PField field = descriptor.findFieldByName(sub);
        if (field == null) {
            throw new ProvidenceConfigException("Message " + descriptor.getQualifiedName() + " has no field named " + sub, new Object[0]);
        }
        if (message == null || !message.has(field.getId())) {
            return ProvidenceConfigUtil.asType(field.getDescriptor(), defValue);
        }
        return message.get(field.getId());
    }

    static Object asType(PDescriptor descriptor, Object o) throws ProvidenceConfigException {
        if (o == null) {
            return null;
        }
        switch (descriptor.getType()) {
            case BOOL: {
                return ProvidenceConfigUtil.asBoolean(o);
            }
            case BYTE: {
                return (byte)ProvidenceConfigUtil.asInteger(o, -128, 127);
            }
            case I16: {
                return (short)ProvidenceConfigUtil.asInteger(o, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case I32: {
                return ProvidenceConfigUtil.asInteger(o, Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            case I64: {
                return ProvidenceConfigUtil.asLong(o);
            }
            case DOUBLE: {
                return ProvidenceConfigUtil.asDouble(o);
            }
            case ENUM: {
                if (o instanceof PEnumValue) {
                    PEnumValue verified = ((PEnumDescriptor)descriptor).findById(((PEnumValue)o).asInteger());
                    if (o.equals(verified)) {
                        return verified;
                    }
                } else {
                    if (o instanceof Number) {
                        return ((PEnumDescriptor)descriptor).findById(((Number)o).intValue());
                    }
                    if (o instanceof Numeric) {
                        return ((PEnumDescriptor)descriptor).findById(((Numeric)o).asInteger());
                    }
                    if (o instanceof CharSequence) {
                        return ((PEnumDescriptor)descriptor).findByName(o.toString());
                    }
                }
                throw new ProvidenceConfigException("Unable to cast " + o.getClass().getSimpleName() + " to enum " + descriptor.getQualifiedName(), new Object[0]);
            }
            case MESSAGE: {
                if (o instanceof PMessage) {
                    PMessage message = (PMessage)o;
                    if (descriptor.equals(message.descriptor())) {
                        return o;
                    }
                    throw new ProvidenceConfigException("Message type mismatch: " + message.descriptor().getQualifiedName() + " is not compatible with " + descriptor.getQualifiedName(), new Object[0]);
                }
                throw new ProvidenceConfigException(o.getClass().getSimpleName() + " is not compatible with message " + descriptor.getQualifiedName(), new Object[0]);
            }
            case STRING: {
                return ProvidenceConfigUtil.asString(o);
            }
            case BINARY: {
                if (o instanceof Binary) {
                    return o;
                }
                if (o instanceof CharSequence) {
                    return Binary.fromBase64((String)o.toString());
                }
                throw new ProvidenceConfigException(o.getClass().getSimpleName() + " is not compatible with binary", new Object[0]);
            }
            case LIST: {
                PList list = (PList)descriptor;
                return list.builder().addAll(ProvidenceConfigUtil.asCollection(o, list.itemDescriptor())).build();
            }
            case SET: {
                PSet set = (PSet)descriptor;
                return set.builder().addAll(ProvidenceConfigUtil.asCollection(o, set.itemDescriptor())).build();
            }
            case MAP: {
                PMap map = (PMap)descriptor;
                return map.builder().putAll(ProvidenceConfigUtil.asMap(o, map.keyDescriptor(), map.itemDescriptor())).build();
            }
        }
        throw new IllegalStateException("Unhandled field type: " + descriptor.getType());
    }

    static boolean asBoolean(Object value) throws ProvidenceConfigException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Double || value instanceof Float) {
            throw new ProvidenceConfigException("Unable to convert real value to boolean", new Object[0]);
        }
        if (value instanceof Number) {
            long l = ((Number)value).longValue();
            if (l == 0L) {
                return false;
            }
            if (l == 1L) {
                return true;
            }
            throw new ProvidenceConfigException("Unable to convert number " + l + " to boolean", new Object[0]);
        }
        if (value instanceof CharSequence) {
            switch (value.toString().toLowerCase()) {
                case "0": 
                case "n": 
                case "f": 
                case "no": 
                case "false": {
                    return false;
                }
                case "1": 
                case "y": 
                case "t": 
                case "yes": 
                case "true": {
                    return true;
                }
            }
            throw new ProvidenceConfigException(String.format("Unable to parse the string \"%s\" to boolean", Strings.escape((CharSequence)value.toString())), new Object[0]);
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a boolean", new Object[0]);
    }

    static int asInteger(Object value, int min, int max) throws ProvidenceConfigException {
        if (value instanceof Long) {
            return ProvidenceConfigUtil.validateInRange("Long", (Long)value, min, max);
        }
        if (value instanceof Float || value instanceof Double) {
            long l = ((Number)value).longValue();
            if ((double)l != ((Number)value).doubleValue()) {
                throw new ProvidenceConfigException("Truncating integer decimals from " + value.toString(), new Object[0]);
            }
            return ProvidenceConfigUtil.validateInRange(value.getClass().getSimpleName(), l, min, max);
        }
        if (value instanceof Number) {
            return ProvidenceConfigUtil.validateInRange(value.getClass().getSimpleName(), ((Number)value).intValue(), min, max);
        }
        if (value instanceof Numeric) {
            return ProvidenceConfigUtil.validateInRange("Numeric", ((Numeric)value).asInteger(), min, max);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof CharSequence) {
            try {
                String s = value.toString();
                if (s.startsWith("0x")) {
                    return ProvidenceConfigUtil.validateInRange("String", Integer.parseInt(s.substring(2), 16), min, max);
                }
                if (s.startsWith("0")) {
                    return ProvidenceConfigUtil.validateInRange("String", Integer.parseInt(s, 8), min, max);
                }
                return ProvidenceConfigUtil.validateInRange("String", Integer.parseInt(value.toString()), min, max);
            }
            catch (NumberFormatException nfe) {
                throw new ProvidenceConfigException("Unable to parse string \"" + Strings.escape((CharSequence)value.toString()) + "\" to an int", nfe);
            }
        }
        if (value instanceof Date) {
            return ProvidenceConfigUtil.validateInRange("Date", ((Date)value).getTime() / 1000L, min, max);
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to an int", new Object[0]);
    }

    private static int validateInRange(String type, long l, int min, int max) throws ProvidenceConfigException {
        if (l < (long)min) {
            throw new ProvidenceConfigException(type + " value outsize of bounds: " + l + " < " + min, new Object[0]);
        }
        if (l > (long)max) {
            throw new ProvidenceConfigException(type + " value outsize of bounds: " + l + " > " + max, new Object[0]);
        }
        return (int)l;
    }

    static long asLong(Object value) throws ProvidenceConfigException {
        if (value instanceof Float || value instanceof Double) {
            long l = ((Number)value).longValue();
            if ((double)l != ((Number)value).doubleValue()) {
                throw new ProvidenceConfigException("Truncating long decimals from " + value.toString(), new Object[0]);
            }
            return l;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Numeric) {
            return ((Numeric)value).asInteger();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof CharSequence) {
            try {
                String s = value.toString();
                if (s.startsWith("0x")) {
                    return Long.parseLong(s.substring(2), 16);
                }
                if (s.startsWith("0")) {
                    return Long.parseLong(s, 8);
                }
                return Long.parseLong(s);
            }
            catch (NumberFormatException nfe) {
                throw new ProvidenceConfigException("Unable to parse string \"" + Strings.escape((CharSequence)value.toString()) + "\" to a long", nfe);
            }
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a long", new Object[0]);
    }

    static double asDouble(Object value) throws ProvidenceConfigException {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Numeric) {
            return ((Numeric)value).asInteger();
        }
        if (value instanceof CharSequence) {
            try {
                return Double.parseDouble(value.toString());
            }
            catch (NumberFormatException nfe) {
                throw new ProvidenceConfigException("Unable to parse string \"" + Strings.escape((CharSequence)value.toString()) + "\" to a double", nfe);
            }
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a double", new Object[0]);
    }

    static String asString(Object value) throws ProvidenceConfigException {
        if (value instanceof Collection || value instanceof Map) {
            throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a string", new Object[0]);
        }
        if (value instanceof Stringable) {
            return ((Stringable)value).asString();
        }
        if (value instanceof Date) {
            Instant instant = ((Date)value).toInstant();
            return DateTimeFormatter.ISO_INSTANT.format(instant);
        }
        return Objects.toString(value);
    }

    static <T> Collection<T> asCollection(Object value, PDescriptor itemType) throws ProvidenceConfigException {
        if (value instanceof Collection) {
            ArrayList<Object> out = new ArrayList<Object>();
            for (Object item : (Collection)value) {
                out.add(ProvidenceConfigUtil.asType(itemType, item));
            }
            return out;
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a collection", new Object[0]);
    }

    static <K, V> Map<K, V> asMap(Object value, PDescriptor keyType, PDescriptor itemType) throws ProvidenceConfigException {
        if (value instanceof Map) {
            AbstractMap out = value instanceof TreeMap ? new TreeMap() : new LinkedHashMap();
            for (Map.Entry item : ((Map)value).entrySet()) {
                out.put(ProvidenceConfigUtil.asType(keyType, item.getKey()), ProvidenceConfigUtil.asType(itemType, item.getValue()));
            }
            return out;
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a collection", new Object[0]);
    }
}

