/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PType;
import net.morimekta.providence.config.ProvidenceConfigException;
import net.morimekta.providence.config.impl.ProvidenceConfigContext;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.serializer.pretty.Token;
import net.morimekta.providence.serializer.pretty.Tokenizer;
import net.morimekta.providence.serializer.pretty.TokenizerException;
import net.morimekta.util.Binary;
import net.morimekta.util.FileUtil;
import net.morimekta.util.Numeric;
import net.morimekta.util.Stringable;
import net.morimekta.util.collect.UnmodifiableMap;
import net.morimekta.util.collect.UnmodifiableSet;
import net.morimekta.util.collect.UnmodifiableSortedMap;

public class ProvidenceConfigUtil {
    static final String IDENTIFIER_SEP = ".";
    static final char DEFINE_REFERENCE = '&';
    static final String FALSE = "false";
    static final String TRUE = "true";
    static final String DEF = "def";
    public static final String UNDEFINED = "undefined";
    static final String INCLUDE = "include";
    static final String AS = "as";
    static final Set<String> RESERVED_WORDS = UnmodifiableSet.setOf((Object)"true", (Object)"false", (Object)"undefined", (Object)"def", (Object)"as", (Object)"include");

    static Object getInMessage(PMessage message, String key) throws ProvidenceConfigException {
        return ProvidenceConfigUtil.getInMessage(message, key, null);
    }

    static Object getInMessage(PMessage message, String key, Object defValue) throws ProvidenceConfigException {
        String sub = key;
        PMessageDescriptor descriptor = message.descriptor();
        while (sub.contains(IDENTIFIER_SEP)) {
            int idx = sub.indexOf(IDENTIFIER_SEP);
            String name = sub.substring(0, idx);
            sub = sub.substring(idx + 1);
            PField field = descriptor.findFieldByName(name);
            if (field == null) {
                throw new ProvidenceConfigException("Message " + descriptor.getQualifiedName() + " has no field named " + name, new Object[0]);
            }
            PDescriptor fieldDesc = field.getDescriptor();
            if (fieldDesc.getType() != PType.MESSAGE) {
                throw new ProvidenceConfigException("Field '" + name + "' is not of message type in " + descriptor.getQualifiedName(), new Object[0]);
            }
            descriptor = (PMessageDescriptor)fieldDesc;
            if (message == null) continue;
            message = (PMessage)message.get(field.getId());
        }
        PField field = descriptor.findFieldByName(sub);
        if (field == null) {
            throw new ProvidenceConfigException("Message " + descriptor.getQualifiedName() + " has no field named " + sub, new Object[0]);
        }
        if (message == null || !message.has(field.getId())) {
            return ProvidenceConfigUtil.asType(field.getDescriptor(), defValue);
        }
        return message.get(field.getId());
    }

    static Object asType(PDescriptor descriptor, Object o) throws ProvidenceConfigException {
        if (o == null) {
            return null;
        }
        switch (descriptor.getType()) {
            case BOOL: {
                return ProvidenceConfigUtil.asBoolean(o);
            }
            case BYTE: {
                return (byte)ProvidenceConfigUtil.asInteger(o, -128, 127);
            }
            case I16: {
                return (short)ProvidenceConfigUtil.asInteger(o, Short.MIN_VALUE, Short.MAX_VALUE);
            }
            case I32: {
                return ProvidenceConfigUtil.asInteger(o, Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            case I64: {
                return ProvidenceConfigUtil.asLong(o);
            }
            case DOUBLE: {
                return ProvidenceConfigUtil.asDouble(o);
            }
            case ENUM: {
                if (o instanceof PEnumValue) {
                    PEnumValue verified = ((PEnumDescriptor)descriptor).findById(((PEnumValue)o).asInteger());
                    if (o.equals(verified)) {
                        return verified;
                    }
                } else {
                    if (o instanceof Number) {
                        return ((PEnumDescriptor)descriptor).findById(((Number)o).intValue());
                    }
                    if (o instanceof Numeric) {
                        return ((PEnumDescriptor)descriptor).findById(((Numeric)o).asInteger());
                    }
                    if (o instanceof CharSequence) {
                        return ((PEnumDescriptor)descriptor).findByName(o.toString());
                    }
                }
                throw new ProvidenceConfigException("Unable to cast " + o.getClass().getSimpleName() + " to enum " + descriptor.getQualifiedName(), new Object[0]);
            }
            case MESSAGE: {
                if (o instanceof PMessage) {
                    PMessage message = (PMessage)o;
                    if (descriptor.equals(message.descriptor())) {
                        return o;
                    }
                    throw new ProvidenceConfigException("Message type mismatch: " + message.descriptor().getQualifiedName() + " is not compatible with " + descriptor.getQualifiedName(), new Object[0]);
                }
                throw new ProvidenceConfigException(o.getClass().getSimpleName() + " is not compatible with message " + descriptor.getQualifiedName(), new Object[0]);
            }
            case STRING: {
                return ProvidenceConfigUtil.asString(o);
            }
            case BINARY: {
                if (o instanceof Binary) {
                    return o;
                }
                throw new ProvidenceConfigException(o.getClass().getSimpleName() + " is not compatible with binary", new Object[0]);
            }
            case LIST: {
                PList list = (PList)descriptor;
                return list.builder(4).addAll(ProvidenceConfigUtil.asCollection(o, list.itemDescriptor())).build();
            }
            case SET: {
                PSet set = (PSet)descriptor;
                return set.builder(4).addAll(ProvidenceConfigUtil.asCollection(o, set.itemDescriptor())).build();
            }
            case MAP: {
                PMap map = (PMap)descriptor;
                return map.builder(4).putAll(ProvidenceConfigUtil.asMap(o, map.keyDescriptor(), map.itemDescriptor())).build();
            }
        }
        throw new IllegalStateException("Unhandled field type: " + descriptor.getType());
    }

    static boolean asBoolean(Object value) throws ProvidenceConfigException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Double || value instanceof Float) {
            throw new ProvidenceConfigException("Unable to convert real value to boolean", new Object[0]);
        }
        if (value instanceof Number) {
            long l = ((Number)value).longValue();
            if (l == 0L) {
                return false;
            }
            if (l == 1L) {
                return true;
            }
            throw new ProvidenceConfigException("Unable to convert number " + l + " to boolean", new Object[0]);
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a boolean", new Object[0]);
    }

    static int asInteger(Object value, int min, int max) throws ProvidenceConfigException {
        if (value instanceof Long) {
            return ProvidenceConfigUtil.validateInRange("Long", (Long)value, min, max);
        }
        if (value instanceof Float || value instanceof Double) {
            long l = ((Number)value).longValue();
            if ((double)l != ((Number)value).doubleValue()) {
                throw new ProvidenceConfigException("Truncating integer decimals from " + value.toString(), new Object[0]);
            }
            return ProvidenceConfigUtil.validateInRange(value.getClass().getSimpleName(), l, min, max);
        }
        if (value instanceof Number) {
            return ProvidenceConfigUtil.validateInRange(value.getClass().getSimpleName(), ((Number)value).intValue(), min, max);
        }
        if (value instanceof Numeric) {
            return ProvidenceConfigUtil.validateInRange("Numeric", ((Numeric)value).asInteger(), min, max);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to an int", new Object[0]);
    }

    private static int validateInRange(String type, long l, int min, int max) throws ProvidenceConfigException {
        if (l < (long)min) {
            throw new ProvidenceConfigException(type + " value outsize of bounds: " + l + " < " + min, new Object[0]);
        }
        if (l > (long)max) {
            throw new ProvidenceConfigException(type + " value outsize of bounds: " + l + " > " + max, new Object[0]);
        }
        return (int)l;
    }

    static long asLong(Object value) throws ProvidenceConfigException {
        if (value instanceof Float || value instanceof Double) {
            long l = ((Number)value).longValue();
            if ((double)l != ((Number)value).doubleValue()) {
                throw new ProvidenceConfigException("Truncating long decimals from " + value.toString(), new Object[0]);
            }
            return l;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Numeric) {
            return ((Numeric)value).asInteger();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a long", new Object[0]);
    }

    static double asDouble(Object value) throws ProvidenceConfigException {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Numeric) {
            return ((Numeric)value).asInteger();
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a double", new Object[0]);
    }

    static String asString(Object value) throws ProvidenceConfigException {
        if (value instanceof Collection || value instanceof Map) {
            throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a string", new Object[0]);
        }
        if (value instanceof Stringable) {
            return ((Stringable)value).asString();
        }
        if (value instanceof Date) {
            Instant instant = ((Date)value).toInstant();
            return DateTimeFormatter.ISO_INSTANT.format(instant);
        }
        return Objects.toString(value);
    }

    static <T> Collection<T> asCollection(Object value, PDescriptor itemType) throws ProvidenceConfigException {
        if (value instanceof Collection) {
            ArrayList<Object> out = new ArrayList<Object>();
            for (Object item : (Collection)value) {
                out.add(ProvidenceConfigUtil.asType(itemType, item));
            }
            return out;
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a collection", new Object[0]);
    }

    static <K, V> Map<K, V> asMap(Object value, PDescriptor keyType, PDescriptor itemType) throws ProvidenceConfigException {
        if (!(value instanceof Map)) {
            throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a collection", new Object[0]);
        }
        if (value instanceof SortedMap) {
            UnmodifiableSortedMap.Builder builder = UnmodifiableSortedMap.builderOrderedBy(((SortedMap)value).comparator());
            for (Map.Entry item : ((Map)value).entrySet()) {
                builder.put(ProvidenceConfigUtil.asType(keyType, item.getKey()), ProvidenceConfigUtil.asType(itemType, item.getValue()));
            }
            return builder.build();
        }
        UnmodifiableMap.Builder builder = UnmodifiableMap.builder();
        for (Map.Entry item : ((Map)value).entrySet()) {
            builder.put(ProvidenceConfigUtil.asType(keyType, item.getKey()), ProvidenceConfigUtil.asType(itemType, item.getValue()));
        }
        return builder.build();
    }

    static void consumeValue(@Nonnull ProvidenceConfigContext context, @Nonnull Tokenizer tokenizer, @Nonnull Token token) throws IOException {
        block21: {
            block22: {
                boolean isMessage = false;
                if (UNDEFINED.equals(token.toString())) {
                    return;
                }
                if (token.toString().equals("b64")) {
                    tokenizer.expectSymbol("b64 body start", new char[]{'('});
                    tokenizer.readBinary(')');
                } else if (token.toString().equals("hex")) {
                    tokenizer.expectSymbol("hex body start", new char[]{'('});
                    tokenizer.readBinary(')');
                } else if (token.isReferenceIdentifier()) {
                    if (!tokenizer.peek("message start").isSymbol('{')) {
                        return;
                    }
                    isMessage = true;
                    token = tokenizer.expect("start of message");
                }
                if (!token.isSymbol('{')) break block22;
                token = tokenizer.expect("map or message first entry");
                if (token.isSymbol('}')) {
                    return;
                }
                Token firstSep = tokenizer.peek("First separator");
                if (!(isMessage || firstSep.isSymbol('=') || firstSep.isSymbol('{') || firstSep.isSymbol('&'))) {
                    while (!token.isSymbol('}')) {
                        if (!token.isIdentifier() && token.isReferenceIdentifier()) {
                            throw new TokenizerException(token, "Invalid map key: " + token, new Object[0]).setLine(tokenizer.getLine());
                        }
                        ProvidenceConfigUtil.consumeValue(context, tokenizer, token);
                        tokenizer.expectSymbol("key value sep.", new char[]{':'});
                        ProvidenceConfigUtil.consumeValue(context, tokenizer, tokenizer.expect("map value"));
                        token = ProvidenceConfigUtil.nextNotLineSep(tokenizer, "map key, sep or end");
                    }
                } else {
                    while (!token.isSymbol('}')) {
                        if (!token.isIdentifier()) {
                            throw new TokenizerException(token, "Invalid field name: " + token, new Object[0]).setLine(tokenizer.getLine());
                        }
                        token = tokenizer.expect("field value sep");
                        if (token.isSymbol('&')) {
                            token = tokenizer.expectIdentifier("reference name");
                            context.setReference(context.initReference(token, tokenizer), null);
                            token = tokenizer.expect("field value sep");
                        }
                        if (token.isSymbol('{')) {
                            ProvidenceConfigUtil.consumeValue(context, tokenizer, token);
                        } else if (token.isSymbol('=')) {
                            ProvidenceConfigUtil.consumeValue(context, tokenizer, tokenizer.expect("field value"));
                        } else {
                            throw new TokenizerException(token, "Unknown field value sep: " + token, new Object[0]).setLine(tokenizer.getLine());
                        }
                        token = ProvidenceConfigUtil.nextNotLineSep(tokenizer, "message field or end");
                    }
                }
                break block21;
            }
            if (!token.isSymbol('[')) break block21;
            token = tokenizer.expect("list value or end");
            while (!token.isSymbol(']')) {
                ProvidenceConfigUtil.consumeValue(context, tokenizer, token);
                if (tokenizer.expectSymbol("list separator or end", new char[]{',', ']'}) != ']') {
                    token = tokenizer.expect("list value or end");
                    continue;
                }
                break;
            }
        }
    }

    static Token nextNotLineSep(Tokenizer tokenizer, String message) throws IOException {
        if (tokenizer.peek().isSymbol(',') || tokenizer.peek().isSymbol(';')) {
            tokenizer.expect(message);
        }
        return tokenizer.expect(message);
    }

    public static Path canonicalFileLocation(@Nonnull Path file) throws ProvidenceConfigException {
        if (!file.isAbsolute()) {
            file = file.toAbsolutePath();
        }
        if (file.getParent() == null) {
            throw new ProvidenceConfigException("Trying to read root directory", new Object[0]);
        }
        try {
            Path dir = FileUtil.readCanonicalPath((Path)file.getParent());
            return dir.resolve(file.getFileName().toString());
        }
        catch (IOException e) {
            throw new ProvidenceConfigException(e, e.getMessage(), new Object[0]);
        }
    }

    static Path resolveFile(Path reference, String path) throws IOException {
        Path file;
        if (reference == null) {
            Path file2 = ProvidenceConfigUtil.canonicalFileLocation(Paths.get(path, new String[0]));
            if (Files.exists(file2, new LinkOption[0])) {
                if (Files.isRegularFile(file2, new LinkOption[0])) {
                    return file2;
                }
                throw new FileNotFoundException(path + " is a directory, expected file");
            }
            throw new FileNotFoundException("File " + path + " not found");
        }
        if (path.startsWith("/")) {
            throw new FileNotFoundException("Absolute path includes not allowed: " + path);
        }
        if (!Files.isDirectory(reference = FileUtil.readCanonicalPath((Path)reference), new LinkOption[0])) {
            reference = reference.getParent();
        }
        if (Files.exists(file = ProvidenceConfigUtil.canonicalFileLocation(reference.resolve(path)), new LinkOption[0])) {
            if (Files.isRegularFile(file, new LinkOption[0])) {
                return file;
            }
            throw new FileNotFoundException(path + " is a directory, expected file");
        }
        throw new FileNotFoundException("Included file " + path + " not found");
    }

    private ProvidenceConfigUtil() {
    }

    static enum Stage {
        INCLUDES,
        DEFINES,
        MESSAGE;

    }
}

