/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.impl.ProvidenceConfigUtil;
import net.morimekta.providence.serializer.pretty.Token;
import net.morimekta.providence.serializer.pretty.Tokenizer;
import net.morimekta.providence.serializer.pretty.TokenizerException;

class ProvidenceConfigContext {
    private final Set<String> includeAliases;
    private final Map<String, Object> references = new HashMap<String, Object>();
    private final Map<String, TokenizerException> referenceExceptions = new HashMap<String, TokenizerException>();

    ProvidenceConfigContext() {
        this.includeAliases = new HashSet<String>();
    }

    boolean containsReference(String name) {
        return this.referenceExceptions.containsKey(name) || this.references.containsKey(name);
    }

    void setInclude(String alias, PMessage include) {
        this.references.put(alias, include);
        this.includeAliases.add(alias);
    }

    String initReference(Token token, Tokenizer tokenizer) throws TokenizerException {
        String reference = token.asString();
        if (ProvidenceConfigUtil.RESERVED_WORDS.contains(reference)) {
            throw new TokenizerException(token, "Trying to assign reference id '%s', which is reserved.", new Object[]{reference}).setLine(tokenizer.getLine());
        }
        TokenizerException ex = this.referenceExceptions.get(reference);
        if (ex != null) {
            if (this.references.containsKey(reference)) {
                throw new TokenizerException(token, "Trying to reassign reference '%s', original at line %d", new Object[]{reference, ex.getLineNo()}).setLine(tokenizer.getLine()).initCause((Throwable)ex);
            }
            throw new TokenizerException(token, "Trying to reassign reference '%s' while calculating it's value, original at line %d", new Object[]{reference, ex.getLineNo()}).setLine(tokenizer.getLine()).initCause((Throwable)ex);
        }
        if (this.includeAliases.contains(reference)) {
            throw new TokenizerException(token, "Trying to reassign include alias '%s' to reference.", new Object[]{reference}).setLine(tokenizer.getLine());
        }
        this.referenceExceptions.put(reference, new TokenizerException(token, "Original reference", new Object[0]).setLine(tokenizer.getLine()));
        return reference;
    }

    Object setReference(String reference, Object value) {
        if (reference != null) {
            if (!this.referenceExceptions.containsKey(reference)) {
                throw new RuntimeException("Reference '" + reference + "' not initialised");
            }
            this.references.put(reference, value);
        }
        return value;
    }

    Object getReference(String reference, Token token, Tokenizer tokenizer) throws TokenizerException {
        if (ProvidenceConfigUtil.RESERVED_WORDS.contains(reference)) {
            return null;
        }
        if (this.references.containsKey(reference)) {
            return this.references.get(reference);
        }
        TokenizerException ex = this.referenceExceptions.get(reference);
        if (ex != null) {
            throw new TokenizerException(token, "Trying to reference '%s' while it's being defined, original at line %d", new Object[]{reference, ex.getLineNo()}).setLine(tokenizer.getLine());
        }
        throw new TokenizerException(token, "No such reference '%s'", new Object[]{reference}).setLine(tokenizer.getLine());
    }
}

