/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.time.Clock;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.config.ConfigListener;
import net.morimekta.providence.config.ConfigSupplier;
import net.morimekta.providence.config.ProvidenceConfigException;
import net.morimekta.providence.config.UncheckedProvidenceConfigException;
import net.morimekta.providence.config.impl.UpdatingConfigSupplier;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.collect.UnmodifiableMap;

public class OverrideConfigSupplier<Message extends PMessage<Message, Field>, Field extends PField>
extends UpdatingConfigSupplier<Message, Field> {
    private final ConfigListener<Message, Field> listener;
    private final ConfigSupplier<Message, Field> parent;
    private final Map<String, String> overrides;

    public OverrideConfigSupplier(@Nonnull ConfigSupplier<Message, Field> parent, @Nonnull Properties overrides) throws ProvidenceConfigException {
        this(parent, OverrideConfigSupplier.propertiesMap(overrides), false);
    }

    public OverrideConfigSupplier(@Nonnull ConfigSupplier<Message, Field> parent, @Nonnull Map<String, String> overrides) throws ProvidenceConfigException {
        this(parent, overrides, false);
    }

    public OverrideConfigSupplier(@Nonnull ConfigSupplier<Message, Field> parent, @Nonnull Map<String, String> overrides, boolean strict) throws ProvidenceConfigException {
        this(Clock.systemUTC(), parent, overrides, strict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OverrideConfigSupplier(@Nonnull Clock clock, @Nonnull ConfigSupplier<Message, Field> parent, @Nonnull Map<String, String> overrides, boolean strict) throws ProvidenceConfigException {
        super(clock);
        this.overrides = UnmodifiableMap.copyOf(overrides);
        Map<String, String> map = this.overrides;
        synchronized (map) {
            this.parent = parent;
            this.listener = updated -> {
                try {
                    Map<String, String> map = this.overrides;
                    synchronized (map) {
                        this.set(OverrideConfigSupplier.buildOverrideConfig(updated, this.overrides, strict));
                    }
                }
                catch (ProvidenceConfigException e) {
                    throw new UncheckedProvidenceConfigException(e);
                }
            };
            parent.addListener(this.listener);
            this.set(OverrideConfigSupplier.buildOverrideConfig((PMessage)parent.get(), overrides, strict));
        }
    }

    public String toString() {
        return String.format(Locale.US, "OverrideConfig{[%s], parent=%s}", Strings.join((String)", ", this.overrides.keySet()), this.parent.getName());
    }

    @Override
    public String getName() {
        return "OverrideConfig";
    }

    private static <Message extends PMessage<Message, Field>, Field extends PField> Message buildOverrideConfig(Message parent, Map<String, String> overrides, boolean strict) throws ProvidenceConfigException {
        PMessageBuilder builder = parent.mutate();
        for (Map.Entry<String, String> override : overrides.entrySet()) {
            CharSequence[] path = override.getKey().split("[.]");
            String fieldName = OverrideConfigSupplier.lastFieldName((String[])path);
            PMessageBuilder containedBuilder = OverrideConfigSupplier.builderForField(strict, builder, (String[])path);
            if (containedBuilder == null) continue;
            PField field = containedBuilder.descriptor().findFieldByName(fieldName);
            if (field == null) {
                if (!strict) continue;
                throw new ProvidenceConfigException("No such field %s in %s [%s]", fieldName, containedBuilder.descriptor().getQualifiedName(), String.join((CharSequence)".", path));
            }
            if ("undefined".equals(override.getValue())) {
                containedBuilder.clear(field.getId());
                continue;
            }
            containedBuilder.set(field.getId(), OverrideConfigSupplier.readFieldValue(override.getKey(), override.getValue(), field.getDescriptor()));
        }
        return (Message)((PMessage)builder.build());
    }

    private static String lastFieldName(String ... path) {
        return path[path.length - 1];
    }

    private static PMessageBuilder builderForField(boolean strict, PMessageBuilder builder, String ... path) throws ProvidenceConfigException {
        for (int i = 0; i < path.length - 1; ++i) {
            String fieldName;
            PMessageDescriptor descriptor = builder.descriptor();
            PField field = descriptor.findFieldByName(fieldName = path[i]);
            if (field == null) {
                if (strict) {
                    throw new ProvidenceConfigException("No such field %s in %s [%s]", fieldName, descriptor.getQualifiedName(), String.join((CharSequence)".", path));
                }
                return null;
            }
            if (field.getType() != PType.MESSAGE) {
                throw new ProvidenceConfigException("'%s' is not a message field in %s [%s]", fieldName, descriptor.getQualifiedName(), String.join((CharSequence)".", path));
            }
            builder = builder.mutator(field.getId());
        }
        return builder;
    }

    private static Object readFieldValue(String key, String value, PDescriptor descriptor) throws ProvidenceConfigException {
        switch (descriptor.getType()) {
            case BOOL: {
                switch (value.toLowerCase()) {
                    case "1": 
                    case "t": 
                    case "true": 
                    case "y": 
                    case "yes": {
                        return Boolean.TRUE;
                    }
                    case "0": 
                    case "f": 
                    case "false": 
                    case "n": 
                    case "no": {
                        return Boolean.FALSE;
                    }
                }
                throw new ProvidenceConfigException("Invalid bool value " + value + " [" + key + "]", new Object[0]);
            }
            case BYTE: {
                try {
                    if (value.equals("0")) {
                        return (byte)0;
                    }
                    if (value.startsWith("0x")) {
                        return (byte)Integer.parseUnsignedInt(value.substring(2), 16);
                    }
                    if (value.startsWith("0")) {
                        return Byte.parseByte(value.substring(1), 8);
                    }
                    return Byte.parseByte(value);
                }
                catch (NumberFormatException e) {
                    throw new ProvidenceConfigException(e, "Invalid byte value " + value + " [" + key + "]", new Object[0]);
                }
            }
            case I16: {
                try {
                    if (value.equals("0")) {
                        return (short)0;
                    }
                    if (value.startsWith("0x")) {
                        return (short)Integer.parseUnsignedInt(value.substring(2), 16);
                    }
                    if (value.startsWith("0")) {
                        return Short.parseShort(value.substring(1), 8);
                    }
                    return Short.parseShort(value);
                }
                catch (NumberFormatException e) {
                    throw new ProvidenceConfigException(e, "Invalid i16 value " + value + " [" + key + "]", new Object[0]);
                }
            }
            case I32: {
                try {
                    if (value.equals("0")) {
                        return 0;
                    }
                    if (value.startsWith("0x")) {
                        return Integer.parseUnsignedInt(value.substring(2), 16);
                    }
                    if (value.startsWith("0")) {
                        return Integer.parseInt(value.substring(1), 8);
                    }
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new ProvidenceConfigException(e, "Invalid i32 value " + value + " [" + key + "]", new Object[0]);
                }
            }
            case I64: {
                try {
                    if (value.equals("0")) {
                        return 0L;
                    }
                    if (value.startsWith("0x")) {
                        return Long.parseUnsignedLong(value.substring(2), 16);
                    }
                    if (value.startsWith("0")) {
                        return Long.parseLong(value.substring(1), 8);
                    }
                    return Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw new ProvidenceConfigException(e, "Invalid i64 value " + value + " [" + key + "]", new Object[0]);
                }
            }
            case DOUBLE: {
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    throw new ProvidenceConfigException(e, "Invalid double value " + value + " [" + key + "]", new Object[0]);
                }
            }
            case STRING: {
                return value;
            }
            case BINARY: {
                try {
                    if (value.startsWith("hex(") && value.endsWith(")")) {
                        return Binary.fromHexString((String)value.substring(4, value.length() - 1));
                    }
                    if (value.startsWith("b64(") && value.endsWith(")")) {
                        return Binary.fromBase64((String)value.substring(4, value.length() - 1));
                    }
                    throw new ProvidenceConfigException("Missing binary format " + value + " [" + key + "]", new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new ProvidenceConfigException(e, "Invalid " + value.substring(0, 3) + " binary value " + value + " [" + key + "]", new Object[0]);
                }
            }
            case ENUM: {
                PEnumDescriptor ed = (PEnumDescriptor)descriptor;
                try {
                    if (Strings.isInteger((CharSequence)value)) {
                        return ed.valueForId(Integer.parseInt(value));
                    }
                    return ed.valueForName(value);
                }
                catch (IllegalArgumentException e) {
                    throw new ProvidenceConfigException("No " + ed.getQualifiedName() + " value for '" + value + "' [" + key + "]", new Object[0]);
                }
            }
        }
        throw new ProvidenceConfigException("Overrides not allowed on " + descriptor.getType() + " fields [" + key + "]", new Object[0]);
    }

    private static Map<String, String> propertiesMap(Properties properties) {
        TreeMap<String, String> overrides = new TreeMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            overrides.put(key, properties.getProperty(key));
        }
        return overrides;
    }
}

