/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.impl;

import com.google.common.collect.ImmutableSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.config.ProvidenceConfigException;
import net.morimekta.providence.config.impl.ProvidenceConfigContext;
import net.morimekta.providence.config.impl.ProvidenceConfigUtil;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.serializer.pretty.Token;
import net.morimekta.providence.serializer.pretty.Tokenizer;
import net.morimekta.providence.serializer.pretty.TokenizerException;
import net.morimekta.providence.util.TypeRegistry;
import net.morimekta.util.Binary;
import net.morimekta.util.Pair;
import net.morimekta.util.io.Utf8StreamReader;

public class ProvidenceConfigParser {
    private final TypeRegistry registry;
    private final boolean strict;
    private static final String IDENTIFIER_SEP = ".";
    private static final char DEFINE_REFERENCE = '&';
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String DEF = "def";
    public static final String UNDEFINED = "undefined";
    private static final String INCLUDE = "include";
    private static final String AS = "as";
    static final Set<String> RESERVED_WORDS = ImmutableSet.of((Object)"true", (Object)"false", (Object)"undefined", (Object)"def", (Object)"as", (Object)"include", (Object[])new String[0]);

    public ProvidenceConfigParser(TypeRegistry registry, boolean strict) {
        this.registry = registry;
        this.strict = strict;
    }

    @Nonnull
    <M extends PMessage<M, F>, F extends PField> Pair<M, Set<String>> parseConfig(@Nonnull File configFile, @Nullable M parent) throws ProvidenceConfigException {
        Pair<M, Set<String>> result = this.checkAndParseInternal(configFile = this.absoluteCanonical(configFile), parent, new String[0]);
        if (result == null) {
            throw new IllegalArgumentException("No config: " + configFile.toString());
        }
        return result;
    }

    private File absoluteCanonical(File f) throws ProvidenceConfigException {
        try {
            return f.getAbsoluteFile().getCanonicalFile();
        }
        catch (IOException e) {
            throw new ProvidenceConfigException(e, "Unable to resolve config file " + f, new Object[0]);
        }
    }

    private <M extends PMessage<M, F>, F extends PField> Pair<M, Set<String>> checkAndParseInternal(@Nonnull File configFile, @Nullable M parent, String ... includeStack) throws ProvidenceConfigException {
        try {
            configFile = configFile.getAbsoluteFile().getCanonicalFile();
            String filePath = configFile.toString();
            ArrayList<String> stackList = new ArrayList<String>();
            Collections.addAll(stackList, includeStack);
            if (Arrays.binarySearch(includeStack, filePath) >= 0) {
                stackList.add(filePath);
                throw new ProvidenceConfigException("Circular includes detected: " + String.join((CharSequence)" -> ", stackList.stream().map(p -> new File((String)p).getName()).collect(Collectors.toList())), new Object[0]);
            }
            stackList.add(filePath);
            return this.parseConfigRecursively(configFile, parent, stackList.toArray(new String[stackList.size()]));
        }
        catch (IOException e) {
            if (e instanceof ProvidenceConfigException) {
                ProvidenceConfigException pce = (ProvidenceConfigException)((Object)e);
                if (pce.getFile() == null) {
                    pce.setFile(configFile.getName());
                }
                throw pce;
            }
            if (e instanceof TokenizerException) {
                TokenizerException te = (TokenizerException)e;
                if (te.getFile() == null) {
                    te.setFile(configFile.getName());
                }
                throw new ProvidenceConfigException(te);
            }
            ProvidenceConfigException ex = new ProvidenceConfigException(e, e.getMessage(), new Object[0]);
            ex.setFile(configFile.getName());
            throw ex;
        }
    }

    private <M extends PMessage<M, F>, F extends PField> Pair<M, Set<String>> parseConfigRecursively(@Nonnull File file, M parent, String[] stack) throws IOException {
        Tokenizer tokenizer;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            tokenizer = new Tokenizer((Reader)new Utf8StreamReader((InputStream)in), 2048, true);
        }
        ProvidenceConfigContext context = new ProvidenceConfigContext();
        TreeSet<String> includedFilePaths = new TreeSet<String>();
        includedFilePaths.add(file.toString());
        Stage lastStage = Stage.INCLUDES;
        Object result = null;
        Token token = tokenizer.peek();
        while (token != null) {
            tokenizer.next();
            if (lastStage == Stage.MESSAGE) {
                throw new TokenizerException(token, "Unexpected token '" + token.asString() + "', expected end of file.", new Object[0]).setLine(tokenizer.getLine());
            }
            if (INCLUDE.equals(token.asString())) {
                PMessage included;
                if (lastStage != Stage.INCLUDES) {
                    throw new TokenizerException(token, "Include added after defines or message. Only one def block allowed.", new Object[0]).setLine(tokenizer.getLine());
                }
                token = tokenizer.expectLiteral("file to be included");
                String includedFilePath = token.decodeLiteral(this.strict);
                try {
                    File includedFile = ProvidenceConfigParser.resolveFile(file, includedFilePath);
                    Pair<Object, Set<String>> tmp = this.checkAndParseInternal(includedFile, null, stack);
                    if (tmp != null) {
                        includedFilePaths.add(includedFile.toString());
                        includedFilePaths.addAll((Collection)tmp.second);
                        included = (PMessage)tmp.first;
                    } else {
                        included = null;
                    }
                }
                catch (FileNotFoundException e) {
                    throw new TokenizerException(token, "Included file \"%s\" not found.", new Object[]{includedFilePath}).setLine(tokenizer.getLine());
                }
                token = tokenizer.expectIdentifier("the token 'as'");
                if (!AS.equals(token.asString())) {
                    throw new TokenizerException(token, "Expected token 'as' after included file \"%s\".", new Object[]{includedFilePath}).setLine(tokenizer.getLine());
                }
                token = tokenizer.expectIdentifier("Include alias");
                String alias = token.asString();
                if (RESERVED_WORDS.contains(alias)) {
                    throw new TokenizerException(token, "Alias \"%s\" is a reserved word.", new Object[]{alias}).setLine(tokenizer.getLine());
                }
                if (context.containsReference(alias)) {
                    throw new TokenizerException(token, "Alias \"%s\" is already used.", new Object[]{alias}).setLine(tokenizer.getLine());
                }
                context.setInclude(alias, included);
            } else if (DEF.equals(token.asString())) {
                lastStage = Stage.DEFINES;
                this.parseDefinitions(context, tokenizer);
            } else if (token.isQualifiedIdentifier()) {
                PMessageDescriptor descriptor;
                lastStage = Stage.MESSAGE;
                try {
                    descriptor = (PMessageDescriptor)this.registry.getDeclaredType(token.asString());
                }
                catch (IllegalArgumentException e) {
                    if (this.strict || stack.length == 1) {
                        throw new TokenizerException(token, "Unknown declared type: %s", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                    }
                    return null;
                }
                result = this.parseConfigMessage(tokenizer, context, descriptor.builder(), parent, file);
            } else {
                throw new TokenizerException(token, "Unexpected token '" + token.asString() + "'. Expected include, defines or message type", new Object[0]).setLine(tokenizer.getLine());
            }
            token = tokenizer.peek();
        }
        if (result == null) {
            throw new TokenizerException("No message in config: " + file.getName(), new Object[0]);
        }
        return Pair.create(result, includedFilePaths);
    }

    private void parseDefinitions(ProvidenceConfigContext context, Tokenizer tokenizer) throws IOException {
        Token token = tokenizer.expect("defines group start or identifier");
        if (token.isIdentifier()) {
            String name = context.initReference(token, tokenizer);
            tokenizer.expectSymbol("def value sep", new char[]{'='});
            context.setReference(name, this.parseDefinitionValue(context, tokenizer));
        } else if (token.isSymbol('{')) {
            token = tokenizer.expect("define or end");
            while (!token.isSymbol('}')) {
                if (!token.isIdentifier()) {
                    throw new TokenizerException(token, "Token '%s' is not valid reference name.", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                }
                String name = context.initReference(token, tokenizer);
                tokenizer.expectSymbol("def value sep", new char[]{'='});
                context.setReference(name, this.parseDefinitionValue(context, tokenizer));
                token = tokenizer.expect("next define or end");
            }
        } else {
            throw new TokenizerException(token, "Unexpected token after def: '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine());
        }
    }

    private Object parseDefinitionValue(ProvidenceConfigContext context, Tokenizer tokenizer) throws IOException {
        Token token = tokenizer.expect("Start of def value");
        if (token.isReal()) {
            return Double.parseDouble(token.asString());
        }
        if (token.isInteger()) {
            return Long.parseLong(token.asString());
        }
        if (token.isStringLiteral()) {
            return token.decodeLiteral(this.strict);
        }
        if (TRUE.equalsIgnoreCase(token.asString())) {
            return Boolean.TRUE;
        }
        if (FALSE.equalsIgnoreCase(token.asString())) {
            return Boolean.FALSE;
        }
        if ("b64".equals(token.asString())) {
            tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
            return Binary.fromBase64((String)tokenizer.readBinary(')'));
        }
        if ("hex".equals(token.asString())) {
            tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
            return Binary.fromHexString((String)tokenizer.readBinary(')'));
        }
        if (token.isDoubleQualifiedIdentifier()) {
            String id = token.asString();
            int l = id.lastIndexOf(46);
            try {
                PEnumDescriptor ed = (PEnumDescriptor)this.registry.getDeclaredType(id.substring(0, l));
                PEnumValue val = ed.findByName(id.substring(l + 1));
                if (val == null && this.strict) {
                    throw new TokenizerException(token, "Unknown %s value: %s", new Object[]{id.substring(0, l), id.substring(l + 1)}).setLine(tokenizer.getLine());
                }
                return val;
            }
            catch (IllegalArgumentException e) {
                if (this.strict) {
                    throw new TokenizerException(token, "Unknown enum identifier: %s", new Object[]{id.substring(0, l)}).setLine(tokenizer.getLine());
                }
                this.consumeValue(context, tokenizer, token);
            }
            catch (ClassCastException e) {
                throw new TokenizerException(token, "Identifier " + id + " does not reference an enum, from " + token.asString(), new Object[0]).setLine(tokenizer.getLine());
            }
        }
        if (token.isQualifiedIdentifier()) {
            PMessageDescriptor descriptor;
            try {
                descriptor = (PMessageDescriptor)this.registry.getDeclaredType(token.asString());
            }
            catch (IllegalArgumentException e) {
                if (this.strict) {
                    throw new TokenizerException(token, "Unknown declared type: %s", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                }
                this.consumeValue(context, tokenizer, token);
                return null;
            }
            PMessageBuilder builder = descriptor.builder();
            if (tokenizer.expectSymbol("message start or inherits", new char[]{'{', ':'}) == ':') {
                token = tokenizer.expect("inherits reference");
                PMessage inheritsFrom = (PMessage)this.resolve(context, token, tokenizer, (PDescriptor)descriptor);
                if (inheritsFrom == null) {
                    throw new TokenizerException(token, "Inheriting from null reference: %s", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                }
                builder.merge(inheritsFrom);
                tokenizer.expectSymbol("message start", new char[]{'{'});
            }
            return this.parseMessage(tokenizer, context, builder);
        }
        throw new TokenizerException(token, "Invalid define value " + token.asString(), new Object[0]).setLine(tokenizer.getLine());
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <M extends PMessage<M, F>, F extends PField> M parseConfigMessage(Tokenizer tokenizer, ProvidenceConfigContext context, PMessageBuilder<M, F> builder, M parent, File file) throws IOException {
        if (tokenizer.expectSymbol("extension marker", new char[]{':', '{'}) == ':') {
            Token token = tokenizer.expect("extension object");
            if (parent != null) {
                throw new TokenizerException(token, "Config in '" + file.getName() + "' has both defined parent and inherits from", new Object[0]).setLine(tokenizer.getLine()).setFile(file.getName());
            }
            if (!token.isReferenceIdentifier()) throw new TokenizerException(token, "Unexpected token " + token.asString() + ", expected reference identifier", new Object[0]).setLine(tokenizer.getLine());
            try {
                builder.merge((PMessage)this.resolveRequired(context, token, tokenizer, (PDescriptor)builder.descriptor()));
            }
            catch (ClassCastException e) {
                throw new TokenizerException(token, "Config type mismatch, expected  ", new Object[0]).setLine(tokenizer.getLine());
            }
            catch (ProvidenceConfigException e) {
                throw new TokenizerException(token, e.getMessage(), new Object[0]).setLine(tokenizer.getLine());
            }
            tokenizer.expectSymbol("object begin", new char[]{'{'});
            return this.parseMessage(tokenizer, context, builder);
        }
        if (parent == null) return this.parseMessage(tokenizer, context, builder);
        builder.merge(parent);
        return this.parseMessage(tokenizer, context, builder);
    }

    private void consumeValue(ProvidenceConfigContext context, Tokenizer tokenizer, Token token) throws IOException {
        if (UNDEFINED.equals(token.asString())) {
            return;
        }
        if (token.isReferenceIdentifier()) {
            if (!tokenizer.peek("message start").isSymbol('{')) {
                return;
            }
            token = tokenizer.next();
        }
        if (token.isSymbol('{')) {
            token = tokenizer.expect("map or message first entry");
            if (!token.isSymbol('}') && !token.isIdentifier()) {
                while (!token.isSymbol('}')) {
                    if (token.isIdentifier() || token.isReferenceIdentifier()) {
                        throw new TokenizerException(token, "Invalid map key: " + token.asString(), new Object[0]).setLine(tokenizer.getLine());
                    }
                    this.consumeValue(context, tokenizer, token);
                    tokenizer.expectSymbol("key value sep.", new char[]{':'});
                    this.consumeValue(context, tokenizer, tokenizer.expect("map value"));
                    token = tokenizer.expect("map key, end or sep");
                    if (!token.isSymbol(',')) continue;
                    token = tokenizer.expect("map key or end");
                }
            } else {
                while (!token.isSymbol('}')) {
                    if (!token.isIdentifier()) {
                        throw new TokenizerException(token, "Invalid field name: " + token.asString(), new Object[0]).setLine(tokenizer.getLine());
                    }
                    if (tokenizer.peek().isSymbol('&')) {
                        tokenizer.next();
                        context.setReference(context.initReference(tokenizer.expectIdentifier("reference name"), tokenizer), null);
                    }
                    if (tokenizer.peek().isSymbol('{')) {
                        this.consumeValue(context, tokenizer, tokenizer.next());
                    } else {
                        tokenizer.expectSymbol("field value sep.", new char[]{'='});
                        this.consumeValue(context, tokenizer, tokenizer.next());
                    }
                    token = this.nextNotLineSep(tokenizer, "message field or end");
                }
            }
        } else if (token.isSymbol('[')) {
            token = tokenizer.next();
            while (!token.isSymbol(']')) {
                this.consumeValue(context, tokenizer, token);
                if (tokenizer.expectSymbol("list separator or end", new char[]{',', ']'}) != ']') {
                    token = tokenizer.expect("list value or end");
                    continue;
                }
                break;
            }
        } else if (token.asString().equals("hex")) {
            tokenizer.expectSymbol("hex body start", new char[]{'('});
            tokenizer.readBinary(')');
        } else if (!(token.isReal() || token.isInteger() || token.isStringLiteral() || token.isIdentifier())) {
            throw new TokenizerException(token, "Unknown value token '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine());
        }
    }

    private <M extends PMessage<M, F>, F extends PField> M parseMessage(Tokenizer tokenizer, ProvidenceConfigContext context, PMessageBuilder<M, F> builder) throws IOException {
        PMessageDescriptor descriptor = builder.descriptor();
        Token token = tokenizer.expect("object end or field");
        while (!token.isSymbol('}')) {
            String reference;
            if (!token.isIdentifier()) {
                throw new TokenizerException(token, "Invalid field name: " + token.asString(), new Object[0]).setLine(tokenizer.getLine());
            }
            PField field = descriptor.findFieldByName(token.asString());
            if (field == null) {
                if (this.strict) {
                    throw new TokenizerException("No such field " + token.asString() + " in " + descriptor.getQualifiedName(), new Object[0]).setLine(tokenizer.getLine());
                }
                token = tokenizer.expect("field value sep, message start or reference start");
                if (token.isSymbol('&')) {
                    context.setReference(context.initReference(tokenizer.expectIdentifier("reference name"), tokenizer), null);
                    token = tokenizer.expect("field value sep or message start");
                }
                if (token.isSymbol('=')) {
                    token = tokenizer.expect("value declaration");
                } else if (!token.isSymbol('{')) {
                    throw new TokenizerException(token, "Expected field-value separator or inherited message", new Object[0]).setLine(tokenizer.getLine());
                }
                this.consumeValue(context, tokenizer, token);
                token = this.nextNotLineSep(tokenizer, "field or message end");
                continue;
            }
            if (field.getType() == PType.MESSAGE) {
                PMessageBuilder bld;
                reference = null;
                char symbol = tokenizer.expectSymbol("Message assigner or start", new char[]{'=', '{', '&'});
                if (symbol == '&') {
                    reference = context.initReference(tokenizer.expectIdentifier("reference name"), tokenizer);
                    symbol = tokenizer.expectSymbol("Message assigner or start after " + reference, new char[]{'=', '{'});
                }
                if (symbol == '=') {
                    token = tokenizer.expect("reference or message start");
                    if (UNDEFINED.equals(token.asString())) {
                        builder.clear(field.getId());
                        context.setReference(reference, null);
                        token = this.nextNotLineSep(tokenizer, "field or message end");
                        continue;
                    }
                    bld = ((PMessageDescriptor)field.getDescriptor()).builder();
                    if (token.isReferenceIdentifier()) {
                        try {
                            PMessage ref = (PMessage)this.resolve(context, token, tokenizer, field.getDescriptor());
                            if (ref != null) {
                                bld.merge(ref);
                            } else {
                                if (tokenizer.peek().isSymbol('{')) {
                                    throw new TokenizerException(token, "Inherit from unknown reference %s", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                                }
                                if (this.strict) {
                                    throw new TokenizerException(token, "Unknown reference %s", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                                }
                            }
                        }
                        catch (ProvidenceConfigException e) {
                            throw new TokenizerException(token, "Unknown inherited reference '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                        }
                        token = tokenizer.expect("after message reference");
                        if (!token.isSymbol('{')) {
                            builder.set(field.getId(), context.setReference(reference, bld.build()));
                            continue;
                        }
                    } else if (!token.isSymbol('{')) {
                        throw new TokenizerException(token, "Unexpected token " + token.asString() + ", expected message start", new Object[0]).setLine(tokenizer.getLine());
                    }
                } else {
                    bld = builder.mutator(field.getId());
                }
                builder.set(field.getId(), context.setReference(reference, this.parseMessage(tokenizer, context, bld)));
            } else if (field.getType() == PType.MAP) {
                token = tokenizer.expect("field sep or value start");
                Map baseValue = new LinkedHashMap();
                String reference2 = null;
                if (token.isSymbol('&')) {
                    reference2 = context.initReference(tokenizer.expectIdentifier("reference name"), tokenizer);
                    token = tokenizer.expect("field sep or value start");
                }
                if (token.isSymbol('=')) {
                    token = tokenizer.expect("field id or start");
                    if (UNDEFINED.equals(token.asString())) {
                        builder.clear(field.getId());
                        context.setReference(reference2, null);
                        token = tokenizer.expect("message end or field");
                        continue;
                    }
                    if (token.isReferenceIdentifier()) {
                        try {
                            baseValue = (Map)this.resolve(context, token, tokenizer, field.getDescriptor());
                        }
                        catch (ProvidenceConfigException e) {
                            throw new TokenizerException(token, e.getMessage(), new Object[0]).setLine(tokenizer.getLine());
                        }
                        token = tokenizer.expect("map start or next field");
                        if (!token.isSymbol('{')) {
                            builder.set(field.getId(), context.setReference(reference2, baseValue));
                            continue;
                        }
                        if (baseValue == null) {
                            baseValue = new LinkedHashMap();
                        }
                    }
                } else {
                    baseValue.putAll((Map)((PMessage)builder.build()).get(field.getId()));
                }
                if (!token.isSymbol('{')) {
                    throw new TokenizerException(token, "Expected map start, but got '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine());
                }
                Map map = this.parseMapValue(tokenizer, context, (PMap)field.getDescriptor(), baseValue);
                builder.set(field.getId(), context.setReference(reference2, map));
            } else {
                reference = null;
                if (tokenizer.expectSymbol("field value sep", new char[]{'=', '&'}) == '&') {
                    reference = context.initReference(tokenizer.expectIdentifier("reference name"), tokenizer);
                    tokenizer.expectSymbol("field value sep", new char[]{'='});
                }
                if (UNDEFINED.equals((token = tokenizer.expect("field value")).asString())) {
                    builder.clear(field.getId());
                    context.setReference(reference, null);
                } else {
                    Object value = this.parseFieldValue(token, tokenizer, context, field.getDescriptor());
                    builder.set(field.getId(), context.setReference(reference, value));
                }
            }
            token = this.nextNotLineSep(tokenizer, "field or message end");
        }
        return (M)((PMessage)builder.build());
    }

    private Map parseMapValue(Tokenizer tokenizer, ProvidenceConfigContext context, PMap descriptor, Map builder) throws IOException {
        Token next = tokenizer.expect("map key or end");
        while (!next.isSymbol('}')) {
            Object key = this.parseFieldValue(next, tokenizer, context, descriptor.keyDescriptor());
            tokenizer.expectSymbol("map key value sep", new char[]{':'});
            next = tokenizer.expect("map value");
            if (UNDEFINED.equals(next.asString())) {
                builder.remove(key);
            } else {
                Object value = this.parseFieldValue(next, tokenizer, context, descriptor.itemDescriptor());
                builder.put(key, value);
            }
            if (!(next = tokenizer.expect("map key, end or sep")).isSymbol(',')) continue;
            next = tokenizer.expect("map key or end");
        }
        return descriptor.builder().putAll(builder).build();
    }

    private Object parseFieldValue(Token next, Tokenizer tokenizer, ProvidenceConfigContext context, PDescriptor descriptor) throws IOException {
        try {
            switch (descriptor.getType()) {
                case BOOL: {
                    if (TRUE.equals(next.asString())) {
                        return true;
                    }
                    if (FALSE.equals(next.asString())) {
                        return false;
                    }
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    break;
                }
                case BYTE: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isInteger()) {
                        return (byte)next.parseInteger();
                    }
                    break;
                }
                case I16: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isInteger()) {
                        return (short)next.parseInteger();
                    }
                    break;
                }
                case I32: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isInteger()) {
                        return (int)next.parseInteger();
                    }
                    break;
                }
                case I64: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isInteger()) {
                        return next.parseInteger();
                    }
                    break;
                }
                case DOUBLE: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isInteger() || next.isReal()) {
                        return next.parseDouble();
                    }
                    break;
                }
                case STRING: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isStringLiteral()) {
                        return next.decodeLiteral(this.strict);
                    }
                    break;
                }
                case BINARY: {
                    if ("b64".equals(next.asString())) {
                        tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                        return Binary.fromBase64((String)tokenizer.readBinary(')'));
                    }
                    if ("hex".equals(next.asString())) {
                        tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                        return Binary.fromHexString((String)tokenizer.readBinary(')'));
                    }
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    break;
                }
                case ENUM: {
                    PEnumValue value;
                    PEnumDescriptor ed = (PEnumDescriptor)descriptor;
                    if (next.isInteger()) {
                        value = ed.findById((int)next.parseInteger());
                    } else if (next.isIdentifier()) {
                        value = ed.findByName(next.asString());
                        if (value == null && context.containsReference(next.asString())) {
                            value = (PEnumValue)this.resolve(context, next, tokenizer, (PDescriptor)ed);
                        }
                    } else {
                        if (!next.isReferenceIdentifier()) break;
                        value = (PEnumValue)this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (value == null && this.strict) {
                        throw new TokenizerException(next, "No such enum value %s for %s.", new Object[]{next.asString(), ed.getQualifiedName()}).setLine(tokenizer.getLine());
                    }
                    return value;
                }
                case MESSAGE: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isSymbol('{')) {
                        return this.parseMessage(tokenizer, context, ((PMessageDescriptor)descriptor).builder());
                    }
                    break;
                }
                case MAP: {
                    if (next.isReferenceIdentifier()) {
                        Map resolved;
                        try {
                            resolved = (Map)this.resolve(context, next, tokenizer, descriptor);
                        }
                        catch (ClassCastException e) {
                            throw new TokenizerException(next, "Reference %s is not a map field ", new Object[]{next.asString()}).setLine(tokenizer.getLine());
                        }
                        return resolved;
                    }
                    if (next.isSymbol('{')) {
                        return this.parseMapValue(tokenizer, context, (PMap)descriptor, new LinkedHashMap());
                    }
                    break;
                }
                case SET: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isSymbol('[')) {
                        PSet ct = (PSet)descriptor;
                        LinkedHashSet<Object> value = new LinkedHashSet<Object>();
                        next = tokenizer.expect("set value or end");
                        while (!next.isSymbol(']')) {
                            value.add(this.parseFieldValue(next, tokenizer, context, ct.itemDescriptor()));
                            if (tokenizer.expectSymbol("set separator or end", new char[]{',', ']'}) == ']') break;
                            next = tokenizer.expect("set value or end");
                        }
                        return ct.builder().addAll(value).build();
                    }
                    break;
                }
                case LIST: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isSymbol('[')) {
                        PList ct = (PList)descriptor;
                        PList.Builder builder = ct.builder();
                        next = tokenizer.expect("list value or end");
                        while (!next.isSymbol(']')) {
                            builder.add(this.parseFieldValue(next, tokenizer, context, ct.itemDescriptor()));
                            if (tokenizer.expectSymbol("list separator or end", new char[]{',', ']'}) == ']') break;
                            next = tokenizer.expect("list value or end");
                        }
                        return builder.build();
                    }
                    break;
                }
                default: {
                    throw new TokenizerException(next, descriptor.getType() + " not supported!", new Object[0]).setLine(tokenizer.getLine());
                }
            }
        }
        catch (ProvidenceConfigException e) {
            throw new TokenizerException(next, e.getMessage(), new Object[0]).setLine(tokenizer.getLine());
        }
        throw new TokenizerException(next, "Unhandled value \"%s\" for type %s", new Object[]{next.asString(), descriptor.getType()}).setLine(tokenizer.getLine());
    }

    private Token nextNotLineSep(Tokenizer tokenizer, String message) throws IOException {
        if (tokenizer.peek().isSymbol(',') || tokenizer.peek().isSymbol(';')) {
            tokenizer.expect(message);
        }
        return tokenizer.expect(message);
    }

    @Nonnull
    private <V> V resolveRequired(ProvidenceConfigContext context, Token token, Tokenizer tokenizer, PDescriptor descriptor) throws TokenizerException {
        V result = this.resolve(context, token, tokenizer, descriptor);
        if (result == null) {
            throw new TokenizerException("Nu", new Object[0]);
        }
        return result;
    }

    private <V> V resolve(ProvidenceConfigContext context, Token token, Tokenizer tokenizer, PDescriptor descriptor) throws TokenizerException {
        Object value = this.resolveAny(context, token, tokenizer);
        if (value == null) {
            return null;
        }
        switch (descriptor.getType()) {
            case BOOL: {
                return (V)Boolean.valueOf(ProvidenceConfigUtil.asBoolean(value));
            }
            case BYTE: {
                return (V)Byte.valueOf((byte)ProvidenceConfigUtil.asInteger(value));
            }
            case I16: {
                return (V)Short.valueOf((short)ProvidenceConfigUtil.asInteger(value));
            }
            case I32: {
                return (V)Integer.valueOf(ProvidenceConfigUtil.asInteger(value));
            }
            case I64: {
                return (V)Long.valueOf(ProvidenceConfigUtil.asLong(value));
            }
            case DOUBLE: {
                return (V)Double.valueOf(ProvidenceConfigUtil.asDouble(value));
            }
            case ENUM: {
                if (value instanceof PEnumValue) {
                    PEnumValue verified = ((PEnumDescriptor)descriptor).findById(((PEnumValue)value).asInteger());
                    if (value.equals(verified)) {
                        return (V)value;
                    }
                } else {
                    if (value instanceof Number) {
                        return (V)((PEnumDescriptor)descriptor).findById(((Number)value).intValue());
                    }
                    if (value instanceof CharSequence) {
                        return (V)((PEnumDescriptor)descriptor).findByName(value.toString());
                    }
                }
                throw new ProvidenceConfigException(value.getClass().getSimpleName() + " is not compatible with " + descriptor.getQualifiedName(), new Object[0]);
            }
            case STRING: {
                return (V)ProvidenceConfigUtil.asString(value);
            }
            case BINARY: {
                if (value instanceof Binary) {
                    return (V)value;
                }
                if (value instanceof CharSequence) {
                    return (V)Binary.fromBase64((String)value.toString());
                }
                throw new ProvidenceConfigException(value.getClass().getSimpleName() + " is not compatible with binary", new Object[0]);
            }
            case MAP: {
                if (value instanceof Map) {
                    return (V)value;
                }
                throw new ProvidenceConfigException(value.getClass().getSimpleName() + " is not compatible with map", new Object[0]);
            }
            case SET: 
            case LIST: {
                if (value instanceof Collection) {
                    return (V)value;
                }
                throw new ProvidenceConfigException(value.getClass().getSimpleName() + " is not compatible with " + descriptor.getType(), new Object[0]);
            }
            case MESSAGE: {
                if (value instanceof PMessage && descriptor.equals(((PMessage)value).descriptor())) {
                    return (V)value;
                }
                throw new ProvidenceConfigException(value.getClass().getSimpleName() + " is not compatible with " + descriptor.getQualifiedName(), new Object[0]);
            }
        }
        throw new IllegalArgumentException("Type " + descriptor.getType() + " is not handled by config.");
    }

    private Object resolveAny(ProvidenceConfigContext context, Token token, Tokenizer tokenizer) throws TokenizerException {
        String key;
        String name = key = token.asString();
        String subKey = null;
        if (key.contains(IDENTIFIER_SEP)) {
            int idx = key.indexOf(IDENTIFIER_SEP);
            name = key.substring(0, idx);
            subKey = key.substring(idx + 1);
        }
        Object value = context.getReference(name, token, tokenizer);
        if (subKey != null) {
            if (!(value instanceof PMessage)) {
                throw new TokenizerException(token, "Reference name " + key + " not declared", new Object[0]);
            }
            try {
                return ProvidenceConfigUtil.getInMessage((PMessage)value, subKey, null);
            }
            catch (ProvidenceConfigException e) {
                throw new TokenizerException(token, e.getMessage(), new Object[0]).setLine(tokenizer.getLine()).initCause((Throwable)((Object)e));
            }
        }
        return value;
    }

    protected static File resolveFile(File ref, String path) throws IOException {
        File tmp;
        if (ref == null) {
            File tmp2 = new File(path).getCanonicalFile().getAbsoluteFile();
            if (tmp2.exists()) {
                if (tmp2.isFile()) {
                    return tmp2;
                }
                throw new FileNotFoundException(path + " is a directory, expected file");
            }
            throw new FileNotFoundException("File " + path + " not found");
        }
        if (path.startsWith("/")) {
            throw new FileNotFoundException("Absolute path includes not allowed: " + path);
        }
        if (!ref.isDirectory()) {
            ref = ref.getParentFile();
        }
        if ((tmp = new File(ref, path).getCanonicalFile().getAbsoluteFile()).exists()) {
            if (tmp.isFile()) {
                return tmp;
            }
            throw new FileNotFoundException(path + " is a directory, expected file");
        }
        throw new FileNotFoundException("Included file " + path + " not found");
    }

    private static enum Stage {
        INCLUDES,
        DEFINES,
        MESSAGE;

    }
}

