/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.time.Clock;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.ConfigListener;
import net.morimekta.providence.config.ConfigSupplier;
import net.morimekta.providence.descriptor.PField;

public class FixedConfigSupplier<M extends PMessage<M, F>, F extends PField>
implements ConfigSupplier<M, F> {
    private final M instance;
    private final long timestamp;

    public FixedConfigSupplier(@Nonnull M initialConfig) {
        this(initialConfig, Clock.systemUTC().millis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedConfigSupplier(@Nonnull ConfigSupplier<M, F> supplier) {
        ConfigSupplier<M, F> configSupplier = Objects.requireNonNull(supplier);
        synchronized (configSupplier) {
            this.instance = (PMessage)supplier.get();
            this.timestamp = supplier.configTimestamp();
        }
    }

    public FixedConfigSupplier(@Nonnull M initialConfig, long timestamp) {
        this.instance = initialConfig;
        this.timestamp = timestamp;
    }

    @Override
    @Nonnull
    public final M get() {
        return this.instance;
    }

    @Override
    public final void addListener(@Nonnull ConfigListener<M, F> listener) {
    }

    @Override
    public final void removeListener(@Nonnull ConfigListener<M, F> listener) {
    }

    @Override
    public long configTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return "InMemoryConfig";
    }
}

