/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.impl;

import java.lang.ref.WeakReference;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.ConfigListener;
import net.morimekta.providence.config.ConfigSupplier;
import net.morimekta.providence.descriptor.PField;

public abstract class UpdatingConfigSupplier<M extends PMessage<M, F>, F extends PField>
implements ConfigSupplier<M, F> {
    private final AtomicReference<M> instance = new AtomicReference();
    private final ArrayList<WeakReference<ConfigListener<M, F>>> listeners = new ArrayList();
    private final Clock clock;
    private final AtomicLong lastUpdateTimestamp;

    protected UpdatingConfigSupplier() {
        this(Clock.systemUTC());
    }

    protected UpdatingConfigSupplier(Clock clock) {
        this.clock = clock;
        this.lastUpdateTimestamp = new AtomicLong(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public final M get() {
        UpdatingConfigSupplier updatingConfigSupplier = this;
        synchronized (updatingConfigSupplier) {
            PMessage config = (PMessage)this.instance.get();
            if (config == null) {
                throw new IllegalStateException("No config instance");
            }
            return (M)config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ConfigListener<M, F> listener) {
        UpdatingConfigSupplier updatingConfigSupplier = this;
        synchronized (updatingConfigSupplier) {
            this.listeners.removeIf(ref -> ref.get() == listener || ref.get() == null);
            this.listeners.add(new WeakReference<ConfigListener<M, F>>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ConfigListener<M, F> listener) {
        UpdatingConfigSupplier updatingConfigSupplier = this;
        synchronized (updatingConfigSupplier) {
            this.listeners.removeIf(ref -> ref.get() == null || ref.get() == listener);
        }
    }

    @Override
    public long configTimestamp() {
        return this.lastUpdateTimestamp.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void set(M config) {
        ArrayList<WeakReference<ConfigListener<M, F>>> iterateOver;
        UpdatingConfigSupplier updatingConfigSupplier = this;
        synchronized (updatingConfigSupplier) {
            if (this.instance.get() != null && ((PMessage)this.instance.get()).equals(config)) {
                return;
            }
            this.instance.set(config);
            this.lastUpdateTimestamp.set(this.clock.millis());
            this.listeners.removeIf(Objects::isNull);
            iterateOver = new ArrayList<WeakReference<ConfigListener<M, F>>>(this.listeners);
        }
        iterateOver.forEach((Consumer<WeakReference<ConfigListener<M, F>>>)((Consumer<WeakReference>)ref -> {
            ConfigListener listener = (ConfigListener)ref.get();
            if (listener != null) {
                try {
                    listener.onConfigChange(config);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
    }
}

