/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.impl;

import java.io.File;
import java.time.Clock;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.ConfigListener;
import net.morimekta.providence.config.ConfigSupplier;
import net.morimekta.providence.config.ProvidenceConfigException;
import net.morimekta.providence.config.impl.ProvidenceConfigParser;
import net.morimekta.providence.config.impl.UpdatingConfigSupplier;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.util.FileWatcher;
import net.morimekta.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvidenceConfigSupplier<Message extends PMessage<Message, Field>, Field extends PField>
extends UpdatingConfigSupplier<Message, Field> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProvidenceConfigSupplier.class);
    private final File configFile;
    private final ProvidenceConfigParser configParser;
    private final Set<String> includedFiles;
    private final FileWatcher fileWatcher;
    private final ConfigListener<Message, Field> configListener;
    private final FileWatcher.Watcher fileListener;
    private final ConfigSupplier<Message, Field> parentSupplier;

    public ProvidenceConfigSupplier(@Nonnull File configFile, @Nullable ConfigSupplier<Message, Field> parentSupplier, @Nullable FileWatcher fileWatcher, @Nonnull ProvidenceConfigParser configParser) throws ProvidenceConfigException {
        this(configFile, parentSupplier, fileWatcher, configParser, Clock.systemUTC());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvidenceConfigSupplier(@Nonnull File configFile, @Nullable ConfigSupplier<Message, Field> parentSupplier, @Nullable FileWatcher fileWatcher, @Nonnull ProvidenceConfigParser configParser, @Nonnull Clock clock) throws ProvidenceConfigException {
        super(clock);
        this.configFile = configFile;
        this.configParser = configParser;
        this.parentSupplier = parentSupplier;
        this.includedFiles = new HashSet<String>();
        this.fileWatcher = fileWatcher;
        ProvidenceConfigSupplier providenceConfigSupplier = this;
        synchronized (providenceConfigSupplier) {
            if (fileWatcher != null) {
                fileWatcher.startWatching(configFile);
                this.fileListener = file -> {
                    if (this.includedFiles.contains(file.toString())) {
                        this.reload();
                    }
                };
                fileWatcher.weakAddWatcher(this.fileListener);
            } else {
                this.fileListener = null;
            }
            if (parentSupplier != null) {
                this.configListener = config -> this.reload();
                this.parentSupplier.addListener(this.configListener);
                this.set(this.loadConfig((PMessage)parentSupplier.get()));
            } else {
                this.configListener = null;
                this.set(this.loadConfig(null));
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProvidenceConfig{" + this.configFile.getName());
        if (this.parentSupplier != null) {
            builder.append(", parent=");
            builder.append(this.parentSupplier.getName());
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public String getName() {
        return "ProvidenceConfig{" + this.configFile.getName() + "}";
    }

    private void reload() {
        try {
            LOGGER.trace("Config reload triggered for " + this.configFile);
            if (this.parentSupplier != null) {
                this.set(this.loadConfig((PMessage)this.parentSupplier.get()));
            } else {
                this.set(this.loadConfig(null));
            }
        }
        catch (ProvidenceConfigException e) {
            LOGGER.error("Exception when reloading " + this.configFile, (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Message loadConfig(@Nullable Message parent) throws ProvidenceConfigException {
        Pair<Message, Set<String>> tmp = this.configParser.parseConfig(this.configFile, parent);
        if (this.fileWatcher != null) {
            this.fileWatcher.startWatching(this.configFile);
            ProvidenceConfigSupplier providenceConfigSupplier = this;
            synchronized (providenceConfigSupplier) {
                if (!((Set)tmp.second).equals(this.includedFiles)) {
                    this.includedFiles.clear();
                    this.includedFiles.addAll((Collection)tmp.second);
                    for (String included : this.includedFiles) {
                        this.fileWatcher.startWatching(new File(included));
                    }
                }
            }
        }
        return (Message)((PMessage)tmp.first);
    }
}

