/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.time.Clock;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PType;
import net.morimekta.providence.config.ConfigListener;
import net.morimekta.providence.config.ConfigSupplier;
import net.morimekta.providence.config.ProvidenceConfigException;
import net.morimekta.providence.config.UncheckedProvidenceConfigException;
import net.morimekta.providence.config.impl.UpdatingConfigSupplier;
import net.morimekta.providence.descriptor.PField;

public class ReferenceConfigSupplier<RefMessage extends PMessage<RefMessage, RefField>, RefField extends PField, ParentMessage extends PMessage<ParentMessage, ParentField>, ParentField extends PField>
extends UpdatingConfigSupplier<RefMessage, RefField> {
    private final String referencePath;
    private final ConfigListener<ParentMessage, ParentField> listener = c -> {
        try {
            this.set(this.getReference(c));
        }
        catch (ProvidenceConfigException e) {
            throw new UncheckedProvidenceConfigException(e);
        }
    };
    private final ConfigSupplier<ParentMessage, ParentField> parent;

    public ReferenceConfigSupplier(@Nonnull String referencePath, @Nonnull ConfigSupplier<ParentMessage, ParentField> parent) throws ProvidenceConfigException {
        this(referencePath, parent, Clock.systemUTC());
    }

    public ReferenceConfigSupplier(String referencePath, ConfigSupplier<ParentMessage, ParentField> parent, Clock clock) throws ProvidenceConfigException {
        super(clock);
        parent.addListener(this.listener);
        this.parent = parent;
        this.referencePath = referencePath;
        this.set(this.getReference((PMessage)parent.get()));
    }

    public String toString() {
        return "ReferenceConfig{" + this.referencePath + ", parent=" + this.parent.getName() + "}";
    }

    @Override
    public String getName() {
        return "ReferenceConfig{" + this.referencePath + "}";
    }

    private <RefMessage extends PMessage<RefMessage, RefField>, RefField extends PField, ParentMessage extends PMessage<ParentMessage, ParentField>, ParentField extends PField> RefMessage getReference(ParentMessage parent) throws ProvidenceConfigException {
        String[] fieldNames;
        Object current = parent;
        for (String name : fieldNames = this.referencePath.split("[.]")) {
            PField field = current.descriptor().findFieldByName(name);
            if (field == null) {
                throw new ProvidenceConfigException("No such field " + name + " in " + current.descriptor().getQualifiedName() + " from " + this.referencePath, new Object[0]);
            }
            if (field.getType() != PType.MESSAGE) {
                throw new ProvidenceConfigException("Field " + name + " in " + current.descriptor().getQualifiedName() + " is not a message, from " + this.referencePath, new Object[0]);
            }
            current = (PMessage)current.get(field);
        }
        return (RefMessage)current;
    }
}

