/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config.impl;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PType;
import net.morimekta.providence.config.ProvidenceConfigException;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.util.Binary;
import net.morimekta.util.Numeric;
import net.morimekta.util.Stringable;
import net.morimekta.util.Strings;

public class ProvidenceConfigUtil {
    static Object getInMessage(PMessage message, String key) throws ProvidenceConfigException {
        return ProvidenceConfigUtil.getInMessage(message, key, null);
    }

    static Object getInMessage(PMessage message, String key, Object defValue) throws ProvidenceConfigException {
        String sub = key;
        PMessageDescriptor descriptor = message.descriptor();
        while (sub.contains(".")) {
            int idx = sub.indexOf(".");
            String name = sub.substring(0, idx);
            sub = sub.substring(idx + 1);
            PField field = descriptor.findFieldByName(name);
            if (field == null) {
                throw new ProvidenceConfigException("Message " + descriptor.getQualifiedName() + " has no field named " + name, new Object[0]);
            }
            PDescriptor fieldDesc = field.getDescriptor();
            if (fieldDesc.getType() != PType.MESSAGE) {
                throw new ProvidenceConfigException("Field '" + name + "' is not of message type in " + descriptor.getQualifiedName(), new Object[0]);
            }
            descriptor = (PMessageDescriptor)fieldDesc;
            if (message == null) continue;
            message = (PMessage)message.get(field.getId());
        }
        PField field = descriptor.findFieldByName(sub);
        if (field == null) {
            throw new ProvidenceConfigException("Message " + descriptor.getQualifiedName() + " has no field named " + sub, new Object[0]);
        }
        if (message == null || !message.has(field.getId())) {
            return ProvidenceConfigUtil.asFieldType(field, defValue);
        }
        return message.get(field.getId());
    }

    private static Object asFieldType(PField field, Object o) throws ProvidenceConfigException {
        if (o == null) {
            return field.getDefaultValue();
        }
        switch (field.getType()) {
            case BOOL: {
                return ProvidenceConfigUtil.asBoolean(o);
            }
            case BYTE: {
                return (byte)ProvidenceConfigUtil.asInteger(o);
            }
            case I16: {
                return (short)ProvidenceConfigUtil.asInteger(o);
            }
            case I32: {
                return ProvidenceConfigUtil.asInteger(o);
            }
            case I64: {
                return ProvidenceConfigUtil.asLong(o);
            }
            case DOUBLE: {
                return ProvidenceConfigUtil.asDouble(o);
            }
            case ENUM: {
                if (o instanceof Number) {
                    return ((PEnumDescriptor)field.getDescriptor()).findById(((Number)o).intValue());
                }
                if (o instanceof Numeric) {
                    return ((PEnumDescriptor)field.getDescriptor()).findById(((Numeric)o).asInteger());
                }
                if (o instanceof CharSequence) {
                    return ((PEnumDescriptor)field.getDescriptor()).findByName(o.toString());
                }
                throw new ProvidenceConfigException("Unable to cast " + o.getClass().getSimpleName() + " to enum type.", new Object[0]);
            }
            case MESSAGE: {
                if (o instanceof PMessage) {
                    return o;
                }
                throw new ProvidenceConfigException("Unable to cast " + o.getClass().getSimpleName() + " to message.", new Object[0]);
            }
            case STRING: {
                return ProvidenceConfigUtil.asString(o);
            }
            case BINARY: {
                if (o instanceof Binary) {
                    return o;
                }
                if (o instanceof CharSequence) {
                    return Binary.fromBase64((String)o.toString());
                }
                throw new ProvidenceConfigException("Unable to cast " + o.getClass().getSimpleName() + " to binary.", new Object[0]);
            }
            case LIST: {
                return ((PList)field.getDescriptor()).builder().addAll(ProvidenceConfigUtil.asCollection(o)).build();
            }
            case SET: {
                return ((PSet)field.getDescriptor()).builder().addAll(ProvidenceConfigUtil.asCollection(o)).build();
            }
            case MAP: {
                if (o instanceof Map) {
                    return ((PMap)field.getDescriptor()).builder().putAll((Map)o).build();
                }
                throw new ProvidenceConfigException("Unable to cast " + o.getClass().getSimpleName() + " to map.", new Object[0]);
            }
        }
        throw new IllegalStateException("Unhandled field type: " + field.getType());
    }

    static boolean asBoolean(Object value) throws ProvidenceConfigException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Double || value instanceof Float) {
            throw new ProvidenceConfigException("Unable to convert double value to boolean", new Object[0]);
        }
        if (value instanceof Number) {
            long l = ((Number)value).longValue();
            if (l == 0L) {
                return false;
            }
            if (l == 1L) {
                return true;
            }
            throw new ProvidenceConfigException("Unable to convert number " + l + " to boolean", new Object[0]);
        }
        if (value instanceof CharSequence) {
            switch (value.toString().toLowerCase()) {
                case "0": 
                case "n": 
                case "f": 
                case "no": 
                case "false": {
                    return false;
                }
                case "1": 
                case "y": 
                case "t": 
                case "yes": 
                case "true": {
                    return true;
                }
            }
            throw new ProvidenceConfigException(String.format("Unable to parse the string \"%s\" to boolean", Strings.escape((CharSequence)value.toString())), new Object[0]);
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a boolean", new Object[0]);
    }

    static int asInteger(Object value) throws ProvidenceConfigException {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Numeric) {
            return ((Numeric)value).asInteger();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof CharSequence) {
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException nfe) {
                throw new ProvidenceConfigException("Unable to parse string \"" + Strings.escape((CharSequence)value.toString()) + "\" to an int", nfe);
            }
        }
        if (value instanceof Date) {
            return (int)(((Date)value).getTime() / 1000L);
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to an int", new Object[0]);
    }

    static long asLong(Object value) throws ProvidenceConfigException {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Numeric) {
            return ((Numeric)value).asInteger();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof CharSequence) {
            try {
                return Long.parseLong(value.toString());
            }
            catch (NumberFormatException nfe) {
                throw new ProvidenceConfigException("Unable to parse string \"" + Strings.escape((CharSequence)value.toString()) + "\" to a long", nfe);
            }
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a long", new Object[0]);
    }

    static double asDouble(Object value) throws ProvidenceConfigException {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Numeric) {
            return ((Numeric)value).asInteger();
        }
        if (value instanceof CharSequence) {
            try {
                return Double.parseDouble(value.toString());
            }
            catch (NumberFormatException nfe) {
                throw new ProvidenceConfigException("Unable to parse string \"" + Strings.escape((CharSequence)value.toString()) + "\" to a double", nfe);
            }
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a double", new Object[0]);
    }

    static String asString(Object value) throws ProvidenceConfigException {
        if (value instanceof Collection || value instanceof Map) {
            throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a string", new Object[0]);
        }
        if (value instanceof Stringable) {
            return ((Stringable)value).asString();
        }
        if (value instanceof Date) {
            Instant instant = ((Date)value).toInstant();
            return DateTimeFormatter.ISO_INSTANT.format(instant);
        }
        return Objects.toString(value);
    }

    static <T> Collection<T> asCollection(Object value) throws ProvidenceConfigException {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        throw new ProvidenceConfigException("Unable to convert " + value.getClass().getSimpleName() + " to a collection", new Object[0]);
    }
}

