/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.io.IOException;
import java.io.InputStream;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.ConfigListener;
import net.morimekta.providence.config.ConfigSupplier;
import net.morimekta.providence.config.ProvidenceConfigException;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.providence.serializer.PrettySerializer;
import net.morimekta.providence.serializer.SerializerException;

public class ResourceConfigSupplier<Message extends PMessage<Message, Field>, Field extends PField>
extends ConfigSupplier<Message, Field> {
    public ResourceConfigSupplier(String resourceName, PMessageDescriptor<Message, Field> descriptor) throws ProvidenceConfigException {
        super(ResourceConfigSupplier.loadInternal(resourceName, descriptor));
    }

    @Override
    public void addListener(ConfigListener<Message, Field> listener) {
    }

    @Override
    public void removeListener(ConfigListener<Message, Field> listener) {
    }

    private static <Message extends PMessage<Message, Field>, Field extends PField> Message loadInternal(String resourceName, PMessageDescriptor<Message, Field> descriptor) throws ProvidenceConfigException {
        JsonSerializer serializer;
        String suffix;
        int lastDot = resourceName.lastIndexOf(".");
        if (lastDot < 1) {
            throw new ProvidenceConfigException("No file ending, or no resource file name: " + resourceName, new Object[0]);
        }
        switch (suffix = resourceName.substring(lastDot).toLowerCase()) {
            case ".json": {
                serializer = new JsonSerializer();
                break;
            }
            case ".cfg": 
            case ".cnf": 
            case ".config": 
            case ".pvd": 
            case ".providence": {
                serializer = new PrettySerializer().config();
                break;
            }
            default: {
                throw new ProvidenceConfigException(String.format("Unrecognized resource config type: %s (%s)", suffix, resourceName), new Object[0]);
            }
        }
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        InputStream in = classLoader.getResourceAsStream(resourceName);
        if (in == null && (in = ResourceConfigSupplier.class.getResourceAsStream(resourceName)) == null) {
            throw new ProvidenceConfigException("No such config resource: " + resourceName, new Object[0]);
        }
        try {
            return (Message)serializer.deserialize(in, descriptor);
        }
        catch (SerializerException se) {
            throw new ProvidenceConfigException(se);
        }
        catch (IOException e) {
            throw new ProvidenceConfigException(e, "Unknown serializer exception: " + e.getMessage(), new Object[0]);
        }
    }
}

