/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.ConfigResolver;
import net.morimekta.providence.config.ConfigSupplier;
import net.morimekta.providence.config.ProvidenceConfigException;
import net.morimekta.providence.config.impl.ProvidenceConfigParser;
import net.morimekta.providence.config.impl.ProvidenceConfigSupplier;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.util.TypeRegistry;
import net.morimekta.util.FileWatcher;

public class ProvidenceConfig
implements ConfigResolver {
    private final Map<String, ConfigSupplier> loaded = new ConcurrentHashMap<String, ConfigSupplier>();
    private final ProvidenceConfigParser parser;
    private final FileWatcher watcher;

    public ProvidenceConfig(TypeRegistry registry) {
        this(registry, new FileWatcher(), false);
    }

    public ProvidenceConfig(@Nonnull TypeRegistry registry, @Nullable FileWatcher watcher, boolean strict) {
        this.watcher = watcher;
        this.parser = new ProvidenceConfigParser(registry, strict);
    }

    @Nonnull
    public <M extends PMessage<M, F>, F extends PField> ConfigSupplier<M, F> resolveConfig(@Nonnull File configFile, @Nullable ConfigSupplier<M, F> parentConfig) throws ProvidenceConfigException {
        String path = null;
        if (parentConfig == null) {
            try {
                path = configFile.getAbsoluteFile().getCanonicalPath();
                if (this.loaded.containsKey(path)) {
                    return this.loaded.get(path);
                }
            }
            catch (IOException e) {
                throw new ProvidenceConfigException(e, e.getMessage(), new Object[0]);
            }
        }
        ProvidenceConfigSupplier<M, F> supplier = new ProvidenceConfigSupplier<M, F>(configFile, parentConfig, this.watcher, this.parser);
        if (parentConfig == null) {
            this.loaded.put(path, supplier);
        }
        return supplier;
    }

    @Nonnull
    public <M extends PMessage<M, F>, F extends PField> M getConfig(@Nonnull File configFile) throws ProvidenceConfigException {
        ConfigSupplier supplier = this.resolveConfig(configFile);
        return (M)supplier.get();
    }

    @Nonnull
    public <M extends PMessage<M, F>, F extends PField> M getConfig(@Nonnull File configFile, @Nonnull M parent) throws ProvidenceConfigException {
        ConfigSupplier supplier = this.resolveConfig(configFile, (ConfigSupplier<M, F>)new ConfigSupplier(parent));
        return supplier.get();
    }
}

