/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.config.ConfigListener;
import net.morimekta.providence.config.ConfigSupplier;
import net.morimekta.providence.config.ProvidenceConfigException;
import net.morimekta.providence.config.UncheckedProvidenceConfigException;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.serializer.pretty.Token;
import net.morimekta.providence.serializer.pretty.Tokenizer;
import net.morimekta.providence.serializer.pretty.TokenizerException;
import net.morimekta.util.Binary;

public class OverrideConfigSupplier<Message extends PMessage<Message, Field>, Field extends PField>
extends ConfigSupplier<Message, Field> {
    private final ConfigListener<Message, Field> listener;

    public OverrideConfigSupplier(@Nonnull ConfigSupplier<Message, Field> parent, @Nonnull Properties overrides) throws ProvidenceConfigException {
        this(parent, OverrideConfigSupplier.propertiesMap(overrides), false);
    }

    public OverrideConfigSupplier(@Nonnull ConfigSupplier<Message, Field> parent, @Nonnull Map<String, String> overrides) throws ProvidenceConfigException {
        this(parent, overrides, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OverrideConfigSupplier(@Nonnull ConfigSupplier<Message, Field> parent, @Nonnull Map<String, String> overrides, boolean strict) throws ProvidenceConfigException {
        OverrideConfigSupplier overrideConfigSupplier = this;
        synchronized (overrideConfigSupplier) {
            this.listener = updated -> {
                try {
                    this.set(OverrideConfigSupplier.buildOverrideConfig(updated, overrides, strict));
                }
                catch (ProvidenceConfigException e) {
                    throw new UncheckedProvidenceConfigException(e);
                }
            };
            parent.addListener(this.listener);
            this.set(OverrideConfigSupplier.buildOverrideConfig(parent.get(), overrides, strict));
        }
    }

    private static <Message extends PMessage<Message, Field>, Field extends PField> Message buildOverrideConfig(Message parent, Map<String, String> overrides, boolean strict) throws ProvidenceConfigException {
        PMessageBuilder builder = parent.mutate();
        for (Map.Entry<String, String> override : overrides.entrySet()) {
            CharSequence[] path = override.getKey().split("[.]");
            String fieldName = OverrideConfigSupplier.lastFieldName((String[])path);
            PMessageBuilder containedBuilder = OverrideConfigSupplier.builderForField(strict, builder, (String[])path);
            if (containedBuilder == null) continue;
            PField field = containedBuilder.descriptor().findFieldByName(fieldName);
            if (field == null) {
                if (!strict) continue;
                throw new ProvidenceConfigException("No such field %s in %s [%s]", fieldName, containedBuilder.descriptor().getQualifiedName(), String.join((CharSequence)".", path));
            }
            try {
                Tokenizer tokenizer = new Tokenizer((InputStream)new ByteArrayInputStream(override.getValue().getBytes(StandardCharsets.UTF_8)), true);
                if ("undefined".equals(override.getValue())) {
                    containedBuilder.clear(field.getId());
                    continue;
                }
                if (field.getType() == PType.STRING) {
                    Token next;
                    if (tokenizer.hasNext() && (next = tokenizer.next()).isStringLiteral()) {
                        containedBuilder.set(field.getId(), (Object)next.decodeLiteral(strict));
                        if (!tokenizer.hasNext()) continue;
                        throw new ProvidenceConfigException("Garbage after string value [%s]: '%s'", override.getKey(), override.getValue());
                    }
                    containedBuilder.set(field.getId(), (Object)override.getValue());
                    continue;
                }
                containedBuilder.set(field.getId(), OverrideConfigSupplier.readFieldValue(tokenizer, tokenizer.expect("value"), field.getDescriptor(), strict));
                if (!tokenizer.hasNext()) continue;
                throw new ProvidenceConfigException("Garbage after %s value [%s]: '%s'", field.getType(), override.getKey(), override.getValue());
            }
            catch (ProvidenceConfigException e) {
                throw e;
            }
            catch (IOException e) {
                throw new ProvidenceConfigException(e.getMessage() + " [" + override.getKey() + "]", e);
            }
        }
        return (Message)((PMessage)builder.build());
    }

    private static String lastFieldName(String ... path) {
        return path[path.length - 1];
    }

    private static PMessageBuilder builderForField(boolean strict, PMessageBuilder builder, String ... path) throws ProvidenceConfigException {
        for (int i = 0; i < path.length - 1; ++i) {
            String fieldName;
            PMessageDescriptor descriptor = builder.descriptor();
            PField field = descriptor.findFieldByName(fieldName = path[i]);
            if (field == null) {
                if (strict) {
                    throw new ProvidenceConfigException("No such field %s in %s [%s]", fieldName, descriptor.getQualifiedName(), String.join((CharSequence)".", path));
                }
                return null;
            }
            if (field.getType() != PType.MESSAGE) {
                throw new ProvidenceConfigException("'%s' is not a message field in %s [%s]", fieldName, descriptor.getQualifiedName(), String.join((CharSequence)".", path));
            }
            builder = builder.mutator(field.getId());
        }
        return builder;
    }

    private static Object readFieldValue(Tokenizer tokenizer, Token token, PDescriptor descriptor, boolean strict) throws IOException {
        switch (descriptor.getType()) {
            case BOOL: {
                switch (token.asString().toLowerCase()) {
                    case "1": 
                    case "t": 
                    case "true": 
                    case "y": 
                    case "yes": {
                        return Boolean.TRUE;
                    }
                    case "0": 
                    case "f": 
                    case "false": 
                    case "n": 
                    case "no": {
                        return Boolean.FALSE;
                    }
                }
                throw new TokenizerException(token, "Invalid boolean value " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case BYTE: {
                if (token.isInteger()) {
                    long val = token.parseInteger();
                    if (val > 127L || val < -128L) {
                        throw new TokenizerException(token, "Byte value out of bounds: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    return (byte)val;
                }
                throw new TokenizerException(token, "Invalid byte value: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case I16: {
                if (token.isInteger()) {
                    long val = token.parseInteger();
                    if (val > 32767L || val < -32768L) {
                        throw new TokenizerException(token, "Short value out of bounds: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    return (short)val;
                }
                throw new TokenizerException(token, "Invalid i16 value: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case I32: {
                if (token.isInteger()) {
                    long val = token.parseInteger();
                    if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
                        throw new TokenizerException(token, "Integer value out of bounds: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    return (int)val;
                }
                throw new TokenizerException(token, "Invalid i32 value: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case I64: {
                if (token.isInteger()) {
                    return token.parseInteger();
                }
                throw new TokenizerException(token, "Invalid i64 value: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case DOUBLE: {
                try {
                    return token.parseDouble();
                }
                catch (NumberFormatException nfe) {
                    throw new TokenizerException(token, "Invalid double value: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
            }
            case STRING: {
                if (!token.isStringLiteral()) {
                    throw new TokenizerException(token, "Expected string literal, got '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                return token.decodeLiteral(strict);
            }
            case BINARY: {
                switch (token.asString()) {
                    case "b64": {
                        try {
                            tokenizer.expectSymbol("binary content start", new char[]{'('});
                            String content = tokenizer.readBinary(')');
                            return Binary.fromBase64((String)content);
                        }
                        catch (IllegalArgumentException e) {
                            throw new TokenizerException((Throwable)e, e.getMessage(), new Object[0]);
                        }
                    }
                    case "hex": {
                        try {
                            tokenizer.expectSymbol("binary content start", new char[]{'('});
                            String content = tokenizer.readBinary(')');
                            return Binary.fromHexString((String)content);
                        }
                        catch (NumberFormatException e) {
                            throw new TokenizerException((Throwable)e, "Invalid hex value: " + e.getMessage(), new Object[0]);
                        }
                    }
                }
                throw new TokenizerException(token, "Unrecognized binary format " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case ENUM: {
                PEnumBuilder b = ((PEnumDescriptor)descriptor).builder();
                b.setByName(token.asString());
                if (strict && !b.valid()) {
                    throw new TokenizerException(token, "No such " + descriptor.getQualifiedName() + " value " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
                return b.build();
            }
            case MESSAGE: {
                throw new TokenizerException(token, "Message overrides not allowed", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case MAP: {
                if (!token.isSymbol('{')) {
                    throw new TokenizerException(token, "Expected map start, got '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                PMap pMap = (PMap)descriptor;
                PDescriptor kDesc = pMap.keyDescriptor();
                PDescriptor iDesc = pMap.itemDescriptor();
                PMap.Builder builder = pMap.builder();
                token = tokenizer.expect("list end or value");
                while (!token.isSymbol('}')) {
                    Object key = OverrideConfigSupplier.readFieldValue(tokenizer, token, kDesc, strict);
                    tokenizer.expectSymbol("map kv sep", new char[]{':'});
                    Object value = OverrideConfigSupplier.readFieldValue(tokenizer, tokenizer.expect("map value"), iDesc, strict);
                    builder.put(key, value);
                    token = tokenizer.expect("map sep, end or value");
                    if (!token.isSymbol(',')) continue;
                    token = tokenizer.expect("map end or value");
                }
                return builder.build();
            }
            case LIST: {
                if (!token.isSymbol('[')) {
                    throw new TokenizerException(token, "Expected list start, got '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                PList pList = (PList)descriptor;
                PDescriptor iDesc = pList.itemDescriptor();
                PList.Builder builder = pList.builder();
                token = tokenizer.expect("list end or value");
                while (!token.isSymbol(']')) {
                    builder.add(OverrideConfigSupplier.readFieldValue(tokenizer, token, iDesc, strict));
                    token = tokenizer.expect("list sep, end or value");
                    if (!token.isSymbol(',')) continue;
                    token = tokenizer.expect("list end or value");
                }
                return builder.build();
            }
            case SET: {
                if (!token.isSymbol('[')) {
                    throw new TokenizerException(token, "Expected set start, got '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                PSet pList = (PSet)descriptor;
                PDescriptor iDesc = pList.itemDescriptor();
                PSet.Builder builder = pList.builder();
                token = tokenizer.expect("set end or value");
                while (!token.isSymbol(']')) {
                    builder.add(OverrideConfigSupplier.readFieldValue(tokenizer, token, iDesc, strict));
                    token = tokenizer.expect("set sep, end or value");
                    if (!token.isSymbol(',')) continue;
                    token = tokenizer.expect("set end or value");
                }
                return builder.build();
            }
        }
        throw new IllegalStateException("Unhandled field type: " + descriptor.getType());
    }

    private static Map<String, String> propertiesMap(Properties properties) {
        TreeMap<String, String> overrides = new TreeMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            overrides.put(key, properties.getProperty(key));
        }
        return overrides;
    }
}

