/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.ConfigListener;
import net.morimekta.providence.descriptor.PField;

public class ConfigSupplier<M extends PMessage<M, F>, F extends PField>
implements Supplier<M> {
    private final AtomicReference<M> instance = new AtomicReference();
    private final LinkedList<WeakReference<ConfigListener<M, F>>> listeners = new LinkedList();

    public ConfigSupplier() {
    }

    public ConfigSupplier(@Nonnull M initialConfig) {
        this();
        this.instance.set(initialConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public final M get() {
        ConfigSupplier configSupplier = this;
        synchronized (configSupplier) {
            PMessage config = (PMessage)this.instance.get();
            if (config == null) {
                throw new IllegalStateException("No config instance");
            }
            return (M)config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConfigListener<M, F> listener) {
        ConfigSupplier configSupplier = this;
        synchronized (configSupplier) {
            this.listeners.removeIf(ref -> ref.get() == listener || ref.get() == null);
            this.listeners.add(new WeakReference<ConfigListener<M, F>>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConfigListener<M, F> listener) {
        ConfigSupplier configSupplier = this;
        synchronized (configSupplier) {
            this.listeners.removeIf(ref -> ref.get() == null || ref.get() == listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void set(M config) {
        LinkedList<WeakReference<ConfigListener<M, F>>> iterateOver;
        ConfigSupplier configSupplier = this;
        synchronized (configSupplier) {
            this.instance.set(config);
            this.listeners.removeIf(Objects::isNull);
            iterateOver = new LinkedList<WeakReference<ConfigListener<M, F>>>(this.listeners);
        }
        iterateOver.forEach(ref -> {
            ConfigListener listener = (ConfigListener)ref.get();
            if (listener != null) {
                try {
                    listener.onConfigChange(config);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

