/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Supplier;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.ProvidenceConfig;
import net.morimekta.providence.config.ReloadableSupplier;
import net.morimekta.providence.descriptor.PField;

public class ProvidenceConfigSupplier<Message extends PMessage<Message, Field>, Field extends PField>
implements ReloadableSupplier<Message> {
    private final Supplier<Message> instance;
    private final File configFile;
    private final ProvidenceConfig configLoader;

    public ProvidenceConfigSupplier(File configFile, ProvidenceConfig configLoader) throws IOException {
        this.configFile = configFile;
        this.configLoader = configLoader;
        this.instance = configLoader.getSupplier(configFile);
    }

    @Override
    public Message get() {
        return (Message)((PMessage)this.instance.get());
    }

    @Override
    public void reload() {
        try {
            this.configLoader.reload(this.configFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }
}

