/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicReference;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.ReloadableSupplier;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.mio.MessageReader;

public class MessageSupplier<Message extends PMessage<Message, Field>, Field extends PField>
implements ReloadableSupplier<Message> {
    private final AtomicReference<Message> instance;
    private final PMessageDescriptor<Message, Field> descriptor;
    private final MessageReader reader;

    public MessageSupplier(PMessageDescriptor<Message, Field> descriptor, MessageReader reader) throws IOException {
        this.descriptor = descriptor;
        this.reader = reader;
        this.instance = new AtomicReference<Message>(this.loadInternal());
    }

    @Override
    public Message get() {
        return (Message)((PMessage)this.instance.get());
    }

    @Override
    public void reload() {
        try {
            this.instance.set(this.loadInternal());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    private Message loadInternal() throws IOException {
        try {
            PMessage pMessage = this.reader.read(this.descriptor);
            return (Message)pMessage;
        }
        finally {
            this.reader.close();
        }
    }
}

