/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicReference;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.MessageConfig;
import net.morimekta.providence.config.ReloadableSupplier;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.mio.MessageReader;

public class MessageConfigSupplier<Message extends PMessage<Message, Field>, Field extends PField>
implements ReloadableSupplier<MessageConfig<Message, Field>> {
    private final String prefix;
    private final AtomicReference<MessageConfig<Message, Field>> instance;
    private final PMessageDescriptor<Message, Field> descriptor;
    private final MessageReader reader;

    public MessageConfigSupplier(String prefix, PMessageDescriptor<Message, Field> descriptor, MessageReader reader) throws IOException {
        this.prefix = prefix;
        this.descriptor = descriptor;
        this.reader = reader;
        this.instance = new AtomicReference<MessageConfig<Message, Field>>(this.loadInternal());
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public MessageConfig<Message, Field> get() {
        return this.instance.get();
    }

    @Override
    public void reload() {
        try {
            this.instance.set(this.loadInternal());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    private MessageConfig<Message, Field> loadInternal() throws IOException {
        try {
            MessageConfig messageConfig = new MessageConfig(this.prefix, this.reader.read(this.descriptor));
            return messageConfig;
        }
        finally {
            this.reader.close();
        }
    }
}

