/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.morimekta.config.ConfigException;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.config.ReloadableSupplier;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.serializer.pretty.Token;
import net.morimekta.providence.serializer.pretty.Tokenizer;
import net.morimekta.providence.serializer.pretty.TokenizerException;
import net.morimekta.util.Binary;

public class OverrideMessageSupplier<Message extends PMessage<Message, Field>, Field extends PField>
implements ReloadableSupplier<Message> {
    private final AtomicReference<Message> instance;
    private final Supplier<Message> parent;
    private final Map<String, String> overrides;
    private final boolean strict;

    public OverrideMessageSupplier(Supplier<Message> parent, Properties overrides) {
        this(parent, OverrideMessageSupplier.propertiesMap(overrides), false);
    }

    public OverrideMessageSupplier(Supplier<Message> parent, Map<String, String> overrides) {
        this(parent, overrides, false);
    }

    public OverrideMessageSupplier(Supplier<Message> parent, Map<String, String> overrides, boolean strict) {
        this.parent = parent;
        this.overrides = overrides;
        this.strict = strict;
        this.instance = new AtomicReference<Message>(this.loadInternal());
    }

    @Override
    public Message get() {
        return (Message)((PMessage)this.instance.get());
    }

    @Override
    public void reload() {
        this.instance.set(this.loadInternal());
    }

    private Message loadInternal() {
        PMessageBuilder builder = ((PMessage)this.parent.get()).mutate();
        for (Map.Entry<String, String> override : this.overrides.entrySet()) {
            CharSequence[] path = override.getKey().split("[.]");
            String fieldName = this.lastFieldName((String[])path);
            PMessageBuilder containedBuilder = this.builderForField(builder, (String[])path);
            if (containedBuilder == null) continue;
            PField field = containedBuilder.descriptor().findFieldByName(fieldName);
            if (field == null) {
                if (!this.strict) continue;
                throw new ConfigException("No such field %s in %s [%s]", new Object[]{fieldName, containedBuilder.descriptor().getQualifiedName(), String.join((CharSequence)".", path)});
            }
            try {
                Tokenizer tokenizer = new Tokenizer((InputStream)new ByteArrayInputStream(override.getValue().getBytes(StandardCharsets.UTF_8)), true);
                if ("undefined".equals(override.getValue())) {
                    containedBuilder.clear(field.getId());
                    continue;
                }
                if (field.getType() == PType.STRING) {
                    Token next;
                    if (tokenizer.hasNext() && (next = tokenizer.next()).isStringLiteral()) {
                        containedBuilder.set(field.getId(), (Object)next.decodeLiteral(this.strict));
                        if (!tokenizer.hasNext()) continue;
                        throw new ConfigException("Garbage after string value [%s]: '%s'", new Object[]{override.getKey(), override.getValue()});
                    }
                    containedBuilder.set(field.getId(), (Object)override.getValue());
                    continue;
                }
                containedBuilder.set(field.getId(), this.readFieldValue(tokenizer, tokenizer.expect("value"), field.getDescriptor()));
                if (!tokenizer.hasNext()) continue;
                throw new ConfigException("Garbage after %s value [%s]: '%s'", new Object[]{field.getType(), override.getKey(), override.getValue()});
            }
            catch (IOException e) {
                throw new ConfigException(e.getMessage() + " [" + override.getKey() + "]", new Object[]{e});
            }
        }
        return (Message)((PMessage)builder.build());
    }

    private String lastFieldName(String ... path) {
        return path[path.length - 1];
    }

    private PMessageBuilder builderForField(PMessageBuilder builder, String ... path) {
        for (int i = 0; i < path.length - 1; ++i) {
            String fieldName;
            PMessageDescriptor descriptor = builder.descriptor();
            PField field = descriptor.findFieldByName(fieldName = path[i]);
            if (field == null) {
                if (this.strict) {
                    throw new ConfigException("No such field %s in %s [%s]", new Object[]{fieldName, descriptor.getQualifiedName(), String.join((CharSequence)".", path)});
                }
                return null;
            }
            if (field.getType() != PType.MESSAGE) {
                throw new ConfigException("'%s' is not a message field in %s [%s]", new Object[]{fieldName, descriptor.getQualifiedName(), String.join((CharSequence)".", path)});
            }
            builder = builder.mutator(field.getId());
        }
        return builder;
    }

    private Object readFieldValue(Tokenizer tokenizer, Token token, PDescriptor descriptor) throws IOException {
        switch (descriptor.getType()) {
            case BOOL: {
                switch (token.asString().toLowerCase()) {
                    case "1": 
                    case "t": 
                    case "true": 
                    case "y": 
                    case "yes": {
                        return Boolean.TRUE;
                    }
                    case "0": 
                    case "f": 
                    case "false": 
                    case "n": 
                    case "no": {
                        return Boolean.FALSE;
                    }
                }
                throw new TokenizerException(token, "Invalid boolean value " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case BYTE: {
                if (token.isInteger()) {
                    long val = token.parseInteger();
                    if (val > 127L || val < -128L) {
                        throw new TokenizerException(token, "Byte value out of bounds: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    return (byte)val;
                }
                throw new TokenizerException(token, "Invalid byte value: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case I16: {
                if (token.isInteger()) {
                    long val = token.parseInteger();
                    if (val > 32767L || val < -32768L) {
                        throw new TokenizerException(token, "Short value out of bounds: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    return (short)val;
                }
                throw new TokenizerException(token, "Invalid i16 value: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case I32: {
                if (token.isInteger()) {
                    long val = token.parseInteger();
                    if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
                        throw new TokenizerException(token, "Integer value out of bounds: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    return (int)val;
                }
                throw new TokenizerException(token, "Invalid i32 value: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case I64: {
                if (token.isInteger()) {
                    return token.parseInteger();
                }
                throw new TokenizerException(token, "Invalid i64 value: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case DOUBLE: {
                try {
                    return token.parseDouble();
                }
                catch (NumberFormatException nfe) {
                    throw new TokenizerException(token, "Invalid double value: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
            }
            case STRING: {
                if (!token.isStringLiteral()) {
                    throw new TokenizerException(token, "Expected string literal, got '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                return token.decodeLiteral(this.strict);
            }
            case BINARY: {
                switch (token.asString()) {
                    case "b64": {
                        try {
                            tokenizer.expectSymbol("binary content start", new char[]{'('});
                            String content = tokenizer.readBinary(')');
                            return Binary.fromBase64((String)content);
                        }
                        catch (IllegalArgumentException e) {
                            throw new TokenizerException((Throwable)e, e.getMessage(), new Object[0]);
                        }
                    }
                    case "hex": {
                        try {
                            tokenizer.expectSymbol("binary content start", new char[]{'('});
                            String content = tokenizer.readBinary(')');
                            return Binary.fromHexString((String)content);
                        }
                        catch (NumberFormatException e) {
                            throw new TokenizerException((Throwable)e, "Invalid hex value: " + e.getMessage(), new Object[0]);
                        }
                    }
                }
                throw new TokenizerException(token, "Unrecognized binary format " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case ENUM: {
                PEnumBuilder b = ((PEnumDescriptor)descriptor).builder();
                b.setByName(token.asString());
                if (this.strict && !b.valid()) {
                    throw new TokenizerException(token, "No such " + descriptor.getQualifiedName() + " value " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
                return b.build();
            }
            case MESSAGE: {
                throw new TokenizerException(token, "Message overrides not allowed", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            case MAP: {
                if (!token.isSymbol('{')) {
                    throw new TokenizerException(token, "Expected map start, got '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                PMap pMap = (PMap)descriptor;
                PDescriptor kDesc = pMap.keyDescriptor();
                PDescriptor iDesc = pMap.itemDescriptor();
                PMap.Builder builder = pMap.builder();
                token = tokenizer.expect("list end or value");
                while (!token.isSymbol('}')) {
                    Object key = this.readFieldValue(tokenizer, token, kDesc);
                    tokenizer.expectSymbol("map kv sep", new char[]{':'});
                    Object value = this.readFieldValue(tokenizer, tokenizer.expect("map value"), iDesc);
                    builder.put(key, value);
                    token = tokenizer.expect("map sep, end or value");
                    if (!token.isSymbol(',')) continue;
                    token = tokenizer.expect("map end or value");
                }
                return builder.build();
            }
            case LIST: {
                if (!token.isSymbol('[')) {
                    throw new TokenizerException(token, "Expected list start, got '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                PList pList = (PList)descriptor;
                PDescriptor iDesc = pList.itemDescriptor();
                PList.Builder builder = pList.builder();
                token = tokenizer.expect("list end or value");
                while (!token.isSymbol(']')) {
                    builder.add(this.readFieldValue(tokenizer, token, iDesc));
                    token = tokenizer.expect("list sep, end or value");
                    if (!token.isSymbol(',')) continue;
                    token = tokenizer.expect("list end or value");
                }
                return builder.build();
            }
            case SET: {
                if (!token.isSymbol('[')) {
                    throw new TokenizerException(token, "Expected set start, got '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                PSet pList = (PSet)descriptor;
                PDescriptor iDesc = pList.itemDescriptor();
                PSet.Builder builder = pList.builder();
                token = tokenizer.expect("set end or value");
                while (!token.isSymbol(']')) {
                    builder.add(this.readFieldValue(tokenizer, token, iDesc));
                    token = tokenizer.expect("set sep, end or value");
                    if (!token.isSymbol(',')) continue;
                    token = tokenizer.expect("set end or value");
                }
                return builder.build();
            }
        }
        throw new IllegalStateException("Unhandled field type: " + descriptor.getType());
    }

    private static Map<String, String> propertiesMap(Properties properties) {
        TreeMap<String, String> overrides = new TreeMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            overrides.put(key, properties.getProperty(key));
        }
        return overrides;
    }
}

