/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import net.morimekta.config.Config;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.ProvidenceConfigUtil;
import net.morimekta.providence.descriptor.PField;

public class MessageConfig<Message extends PMessage<Message, Field>, Field extends PField>
implements Config {
    private final String prefix;
    private final Message instance;
    private final Set<String> valueKeySet;

    public MessageConfig(Message instance) {
        this(null, instance);
    }

    public MessageConfig(String prefix, Message instance) {
        this.prefix = prefix;
        this.instance = instance;
        HashSet<String> valueKeySet = new HashSet<String>();
        ProvidenceConfigUtil.buildKeySet(prefix, instance, valueKeySet);
        this.valueKeySet = ImmutableSet.copyOf(valueKeySet);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Message getMessage() {
        return this.instance;
    }

    public Object get(String key) {
        if (this.containsKey(key)) {
            return ProvidenceConfigUtil.getInMessage(this.instance, this.cutPrefix(key));
        }
        return null;
    }

    public boolean containsKey(String key) {
        return this.valueKeySet.contains(key);
    }

    public Set<String> keySet() {
        return this.valueKeySet;
    }

    private String cutPrefix(String key) {
        if (this.prefix != null && key.startsWith(this.prefix + ".")) {
            return key.substring(this.prefix.length() + 1);
        }
        return key;
    }
}

