/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.morimekta.config.IncompatibleValueException;
import net.morimekta.config.KeyNotFoundException;
import net.morimekta.config.util.ConfigUtil;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.config.ProvidenceConfigContext;
import net.morimekta.providence.config.ProvidenceConfigUtil;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.util.TypeRegistry;
import net.morimekta.providence.util.pretty.Token;
import net.morimekta.providence.util.pretty.Tokenizer;
import net.morimekta.providence.util.pretty.TokenizerException;
import net.morimekta.util.Binary;

public class ProvidenceConfig {
    private static final String IDENTIFIER_SEP = ".";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String DEF = "def";
    static final String UNDEFINED = "undefined";
    private static final String INCLUDE = "include";
    private static final String AS = "as";
    static final Set<String> RESERVED_WORDS = ImmutableSet.of((Object)"true", (Object)"false", (Object)"undefined", (Object)"def", (Object)"as", (Object)"include", (Object[])new String[0]);
    private static final char kDefineReference = '&';
    private final Map<String, AtomicReference<PMessage>> loaded;
    private final Map<String, Supplier<PMessage>> parents;
    private final TypeRegistry registry;
    private final Map<String, Set<String>> reverseDependencies;
    private final boolean strict;

    public ProvidenceConfig(TypeRegistry registry) {
        this(registry, false);
    }

    public ProvidenceConfig(TypeRegistry registry, boolean strict) {
        this.registry = registry;
        this.loaded = new ConcurrentHashMap<String, AtomicReference<PMessage>>();
        this.parents = new ConcurrentHashMap<String, Supplier<PMessage>>();
        this.reverseDependencies = new ConcurrentHashMap<String, Set<String>>();
        this.strict = strict;
    }

    public <M extends PMessage<M, F>, F extends PField> M getConfig(File file) throws IOException {
        Supplier<M> supplier = this.getSupplier(file);
        return (M)((PMessage)supplier.get());
    }

    public <M extends PMessage<M, F>, F extends PField> M getConfig(File file, PMessageDescriptor<M, F> descriptor) throws IOException {
        return (M)((PMessage)this.getSupplier(file, descriptor).get());
    }

    public synchronized <M extends PMessage<M, F>, F extends PField> Supplier<M> getSupplier(File file) throws IOException {
        try {
            AtomicReference<M> reference = this.loadRecursively(this.resolveFile(null, file.getPath()), new String[0]);
            return reference::get;
        }
        catch (FileNotFoundException e) {
            throw new TokenizerException(e.getMessage(), new Object[]{e}).setFile(file.getName());
        }
    }

    public synchronized <M extends PMessage<M, F>, F extends PField> Supplier<M> getSupplierWithParent(File file, Supplier<M> parent) throws IOException {
        try {
            File config = this.resolveFile(null, file.getPath());
            String path = config.getCanonicalFile().getAbsolutePath();
            this.parents.computeIfAbsent(path, name -> parent);
            AtomicReference<M> reference = this.loadRecursively(config, new String[0]);
            return reference::get;
        }
        catch (FileNotFoundException e) {
            throw new TokenizerException(e.getMessage(), new Object[]{e}).setFile(file.getName());
        }
    }

    public synchronized <M extends PMessage<M, F>, F extends PField> Supplier<M> getSupplierWithParent(File configFile, File parentFile) throws IOException {
        return this.getSupplierWithParent(configFile, parentFile, null);
    }

    public synchronized <M extends PMessage<M, F>, F extends PField> Supplier<M> getSupplierWithParent(File configFile, File parentFile, PMessageDescriptor<M, F> descriptor) throws IOException {
        try {
            String configPath = this.resolveFile(null, configFile.getPath()).getCanonicalFile().getAbsolutePath();
            String parentPath = this.resolveFile(null, parentFile.getPath()).getCanonicalFile().getAbsolutePath();
            AtomicReference<PMessage> parent = this.loaded.get(parentPath);
            if (parent == null) {
                throw new TokenizerException("Parent file " + parentFile.getName() + " is not loaded.", new Object[0]).setFile(configFile.getName());
            }
            if (descriptor != null && !parent.get().descriptor().equals(descriptor)) {
                throw new TokenizerException(String.format(Locale.ENGLISH, "Incompatible message type: Expected %s, got %s", descriptor.getQualifiedName(), parent.get().descriptor().getQualifiedName()), new Object[0]).setFile(configFile.getPath());
            }
            Supplier<PMessage> supplier = this.getSupplierWithParent(configFile, parent::get);
            if (descriptor != null && !supplier.get().descriptor().equals(descriptor)) {
                throw new TokenizerException(String.format(Locale.ENGLISH, "Incompatible message type: Expected %s, got %s", descriptor.getQualifiedName(), supplier.get().descriptor().getQualifiedName()), new Object[0]).setFile(configFile.getPath());
            }
            this.getReverseDeps(parentPath).add(configPath);
            return supplier;
        }
        catch (FileNotFoundException e) {
            throw new TokenizerException(e.getMessage(), new Object[]{e}).setFile(configFile.getName());
        }
    }

    public <M extends PMessage<M, F>, F extends PField> Supplier<M> getSupplier(File file, PMessageDescriptor<M, F> descriptor) throws IOException {
        try {
            Supplier<M> supplier = this.getSupplier(file);
            if (descriptor != null && !((PMessage)supplier.get()).descriptor().equals(descriptor)) {
                throw new TokenizerException(String.format(Locale.ENGLISH, "Incompatible message type: Expected %s, got %s", descriptor.getQualifiedName(), ((PMessage)supplier.get()).descriptor().getQualifiedName()), new Object[0]).setFile(file.getPath());
            }
            return supplier;
        }
        catch (FileNotFoundException e) {
            throw new TokenizerException(e.getMessage(), new Object[0]).setFile(file.getName());
        }
    }

    public void reload(File file) throws IOException {
        String canonicalPath = file.getCanonicalFile().getAbsolutePath();
        AtomicReference<PMessage> reference = this.loaded.get(canonicalPath);
        if (reference == null) {
            return;
        }
        TreeSet<String> dependencies = new TreeSet<String>(this.getReverseDeps(canonicalPath));
        try {
            Object reloaded = this.parseConfigRecursively(file, new String[]{canonicalPath});
            if (reference.get().equals(reloaded)) {
                return;
            }
            reference.set((PMessage)reloaded);
            for (String dep : dependencies) {
                this.reload(new File(dep));
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @VisibleForTesting
    File resolveFile(File ref, String path) throws IOException {
        File tmp;
        if (ref == null) {
            File tmp2 = new File(path).getCanonicalFile().getAbsoluteFile();
            if (tmp2.exists()) {
                if (tmp2.isFile()) {
                    return tmp2;
                }
                throw new FileNotFoundException(path + " is a directory, expected file");
            }
            throw new FileNotFoundException("File " + path + " not found");
        }
        if (path.startsWith("/")) {
            throw new FileNotFoundException("Absolute path includes not allowed: " + path);
        }
        if (!ref.isDirectory()) {
            ref = ref.getParentFile();
        }
        if ((tmp = new File(ref, path).getCanonicalFile().getAbsoluteFile()).exists()) {
            if (tmp.isFile()) {
                return tmp;
            }
            throw new FileNotFoundException(path + " is a directory, expected file");
        }
        throw new FileNotFoundException("Included file " + path + " not found");
    }

    private Set<String> getReverseDeps(String to) {
        return this.reverseDependencies.computeIfAbsent(to, k -> new HashSet());
    }

    @Nonnull
    private <M extends PMessage<M, F>, F extends PField> AtomicReference<M> loadRecursively(File file, String ... stack) throws IOException {
        try {
            AtomicReference<Object> ref;
            file = file.getCanonicalFile().getAbsoluteFile();
            String filePath = file.toString();
            LinkedList<String> stackList = new LinkedList<String>();
            Collections.addAll(stackList, stack);
            if (stackList.contains(filePath)) {
                stackList.add(filePath);
                throw new TokenizerException("Circular includes detected: " + String.join((CharSequence)" -> ", stackList.stream().map(p -> new File((String)p).getName()).collect(Collectors.toList())), new Object[0]);
            }
            if (this.loaded.containsKey(filePath)) {
                if (stack.length > 0) {
                    this.getReverseDeps(filePath).add(stack[stack.length - 1]);
                }
                return this.loaded.get(filePath);
            }
            stackList.add(filePath);
            M result = this.parseConfigRecursively(file, stackList.toArray(new String[stackList.size()]));
            if (result == null) {
                return new AtomicReference();
            }
            stackList.add(filePath);
            if (stack.length > 0) {
                this.getReverseDeps(filePath).add(stack[stack.length - 1]);
            }
            if ((ref = this.loaded.get(filePath)) == null) {
                ref = new AtomicReference<M>(result);
                this.loaded.put(filePath, ref);
            } else {
                ref.set((PMessage)result);
            }
            return ref;
        }
        catch (TokenizerException e) {
            throw new TokenizerException(e, file);
        }
    }

    private <M extends PMessage<M, F>, F extends PField> M parseConfigRecursively(File file, String[] stack) throws IOException {
        Tokenizer tokenizer;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            tokenizer = new Tokenizer((InputStream)in, false);
        }
        ProvidenceConfigContext context = new ProvidenceConfigContext();
        Stage lastStage = Stage.INCLUDES;
        M result = null;
        Token token = tokenizer.peek();
        while (token != null) {
            tokenizer.next();
            if (lastStage == Stage.MESSAGE) {
                throw new TokenizerException(token, "Unexpected token '" + token.asString() + "', expected end of file.", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            if (INCLUDE.equals(token.asString())) {
                PMessage included;
                if (lastStage != Stage.INCLUDES) {
                    throw new TokenizerException(token, "Include added after defines or message. Only one def block allowed.", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
                token = tokenizer.expectStringLiteral("file to be included");
                String includedFilePath = token.decodeLiteral();
                try {
                    File includedFile = this.resolveFile(file, includedFilePath);
                    included = (PMessage)this.loadRecursively(includedFile, stack).get();
                }
                catch (FileNotFoundException e) {
                    throw new TokenizerException(token, "Included file \"%s\" not found.", new Object[]{includedFilePath}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                token = tokenizer.expectIdentifier("the token 'as'");
                if (!AS.equals(token.asString())) {
                    throw new TokenizerException(token, "Expected token 'as' after included file \"%s\".", new Object[]{includedFilePath}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                token = tokenizer.expectIdentifier("Include alias");
                String alias = token.asString();
                if (RESERVED_WORDS.contains(alias)) {
                    throw new TokenizerException(token, "Alias \"%s\" is a reserved word.", new Object[]{alias}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                if (context.containsReference(alias)) {
                    throw new TokenizerException(token, "Alias \"%s\" is already used.", new Object[]{alias}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                context.setInclude(alias, included);
            } else if (DEF.equals(token.asString())) {
                if (lastStage != Stage.INCLUDES) {
                    throw new TokenizerException(token, "Defines already complete or passed.", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
                lastStage = Stage.DEFINES;
                this.parseDefinitions(context, tokenizer);
            } else if (token.isQualifiedIdentifier()) {
                PMessageDescriptor descriptor;
                lastStage = Stage.MESSAGE;
                try {
                    descriptor = (PMessageDescriptor)this.registry.getDeclaredType(token.asString());
                }
                catch (IllegalArgumentException e) {
                    if (this.strict || stack.length == 1) {
                        throw new TokenizerException(token, "Unknown declared type: %s", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    return null;
                }
                result = this.parseConfigMessage(tokenizer, context, descriptor.builder(), file);
            } else {
                throw new TokenizerException(token, "Unexpected token '" + token.asString() + "'. Expected include, defines or message type", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            token = tokenizer.peek();
        }
        if (result == null) {
            throw new TokenizerException("No message in config: " + file.getName(), new Object[0]);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void parseDefinitions(ProvidenceConfigContext context, Tokenizer tokenizer) throws IOException {
        tokenizer.expectSymbol("defines start", new char[]{'{'});
        token = tokenizer.expect("define or end");
        while (!token.isSymbol('}')) {
            if (!token.isIdentifier()) {
                throw new TokenizerException(token, "Reference name '%s' is not valid.", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
            }
            name = context.initReference(token, tokenizer);
            tokenizer.expectSymbol("def value sep", new char[]{'='});
            token = tokenizer.expect("def value");
            if (token.isReal()) {
                context.setReference(name, Double.parseDouble(token.asString()));
            } else if (token.isInteger()) {
                context.setReference(name, Long.parseLong(token.asString()));
            } else if (token.isStringLiteral()) {
                context.setReference(name, token.decodeLiteral());
            } else if ("true".equalsIgnoreCase(token.asString())) {
                context.setReference(name, true);
            } else if ("false".equalsIgnoreCase(token.asString())) {
                context.setReference(name, false);
            } else if ("b64".equals(token.asString())) {
                tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                context.setReference(name, Binary.fromBase64((String)tokenizer.readBinary(')')));
            } else if ("hex".equals(token.asString())) {
                tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                context.setReference(name, Binary.fromHexString((String)tokenizer.readBinary(')')));
            } else if (token.isDoubleQualifiedIdentifier()) {
                id = token.asString();
                l = id.lastIndexOf(46);
                try {
                    ed = (PEnumDescriptor)this.registry.getDeclaredType(id.substring(0, l));
                    val = ed.getValueByName(id.substring(l + 1));
                    if (val == null && this.strict) {
                        throw new TokenizerException(token, "Unknown %s value: %s", new Object[]{id.substring(0, l), id.substring(l + 1)}).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    context.setReference(name, val);
                }
                catch (IllegalArgumentException e) {
                    if (!this.strict) ** GOTO lbl79
                    throw new TokenizerException(token, "Unknown enum identifier: %s", new Object[]{id.substring(0, l)}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                catch (ClassCastException e) {
                    throw new TokenizerException(token, "Identifier " + id + " does not reference an enum, from " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
            } else if (token.isQualifiedIdentifier()) {
                try {
                    descriptor = (PMessageDescriptor)this.registry.getDeclaredType(token.asString());
                }
                catch (IllegalArgumentException e) {
                    if (!this.strict) continue;
                    throw new TokenizerException(token, "Unknown declared type: %s", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                builder = descriptor.builder();
                if (tokenizer.expectSymbol("message start or inherits", new char[]{'{', ':'}) == ':') {
                    token = tokenizer.expect("inherits reference");
                    inheritsFrom = (PMessage)this.resolve(context, token, tokenizer, (PDescriptor)descriptor);
                    builder.merge(inheritsFrom);
                    tokenizer.expectSymbol("message start", new char[]{'{'});
                }
                message = this.parseMessage(tokenizer, context, builder);
                context.setReference(name, message);
            } else {
                throw new TokenizerException(token, "Invalid define value " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
lbl79:
            // 10 sources

            token = tokenizer.expect("next define or end");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <M extends PMessage<M, F>, F extends PField> M parseConfigMessage(Tokenizer tokenizer, ProvidenceConfigContext context, PMessageBuilder<M, F> builder, File file) throws IOException {
        String path = file.getCanonicalFile().getAbsolutePath();
        if (tokenizer.expectSymbol("extension marker", new char[]{':', '{'}) == ':') {
            Token token = tokenizer.expect("extension object");
            if (this.parents.containsKey(path)) {
                throw new TokenizerException(token, "Config in '" + file.getName() + "' has both defined parent and inherits from", new Object[0]).setLine(tokenizer.getLine(token.getLineNo())).setFile(file.getName());
            }
            if (!token.isReferenceIdentifier()) throw new TokenizerException(token, "Unexpected token " + token.asString() + ", expected reference identifier", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            try {
                builder.merge((PMessage)this.resolve(context, token, tokenizer, (PDescriptor)builder.descriptor()));
            }
            catch (ClassCastException e) {
                throw new TokenizerException(token, "Config type mismatch, expected  ", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            catch (KeyNotFoundException e) {
                throw new TokenizerException(token, e.getMessage(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            tokenizer.expectSymbol("object begin", new char[]{'{'});
            return this.parseMessage(tokenizer, context, builder);
        }
        if (!this.parents.containsKey(path)) return this.parseMessage(tokenizer, context, builder);
        builder.merge(this.parents.get(path).get());
        return this.parseMessage(tokenizer, context, builder);
    }

    private void consumeValue(ProvidenceConfigContext context, Tokenizer tokenizer, Token token) throws IOException {
        if (UNDEFINED.equals(token.asString())) {
            return;
        }
        if (token.isReferenceIdentifier()) {
            if (!tokenizer.peek().isSymbol('{')) {
                return;
            }
            token = tokenizer.next();
        }
        if (token.isSymbol('{')) {
            token = tokenizer.expect("map or message first entry");
            if (!token.isSymbol('}') && !token.isIdentifier()) {
                while (!token.isSymbol('}')) {
                    if (token.isIdentifier() || token.isReferenceIdentifier()) {
                        throw new TokenizerException(token, "Invalid map key: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    this.consumeValue(context, tokenizer, token);
                    tokenizer.expectSymbol("key value sep.", new char[]{':'});
                    this.consumeValue(context, tokenizer, tokenizer.expect("map value"));
                    token = tokenizer.expect("map key, end or sep");
                    if (!token.isSymbol(',')) continue;
                    token = tokenizer.expect("map key or end");
                }
            } else {
                while (!token.isSymbol('}')) {
                    if (!token.isIdentifier()) {
                        throw new TokenizerException(token, "Invalid field name: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    if (tokenizer.peek().isSymbol('&')) {
                        tokenizer.next();
                        context.setReference(context.initReference(tokenizer.expectIdentifier("reference name"), tokenizer), null);
                    }
                    if (tokenizer.peek().isSymbol('{')) {
                        this.consumeValue(context, tokenizer, tokenizer.next());
                    } else {
                        tokenizer.expectSymbol("field value sep.", new char[]{'='});
                        this.consumeValue(context, tokenizer, tokenizer.next());
                    }
                    token = this.nextNotLineSep(tokenizer, "message field or end");
                }
            }
        } else if (token.isSymbol('[')) {
            token = tokenizer.next();
            while (!token.isSymbol(']')) {
                this.consumeValue(context, tokenizer, token);
                if (tokenizer.expectSymbol("list separator or end", new char[]{',', ']'}) != ']') {
                    token = tokenizer.expect("list value or end");
                    continue;
                }
                break;
            }
        } else if (token.asString().equals("hex")) {
            tokenizer.expectSymbol("hex body start", new char[]{'('});
            tokenizer.readBinary(')');
        } else if (!(token.isReal() || token.isInteger() || token.isStringLiteral() || token.isIdentifier())) {
            throw new TokenizerException(token, "Unknown value token '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
        }
    }

    private <M extends PMessage<M, F>, F extends PField> M parseMessage(Tokenizer tokenizer, ProvidenceConfigContext context, PMessageBuilder<M, F> builder) throws IOException {
        PMessageDescriptor descriptor = builder.descriptor();
        Token token = tokenizer.expect("object end or field");
        while (!token.isSymbol('}')) {
            String reference;
            if (!token.isIdentifier()) {
                throw new TokenizerException(token, "Invalid field name: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            PField field = descriptor.getField(token.asString());
            if (field == null) {
                if (this.strict) {
                    throw new TokenizerException("No such field " + token.asString() + " in " + descriptor.getQualifiedName(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
                token = tokenizer.expect("field value sep, message start or reference start");
                if (token.isSymbol('&')) {
                    context.setReference(context.initReference(tokenizer.expectIdentifier("reference name"), tokenizer), null);
                    token = tokenizer.expect("field value sep or message start");
                }
                if (token.isSymbol('=')) {
                    token = tokenizer.expect("value declaration");
                } else if (!token.isSymbol('{')) {
                    throw new TokenizerException(token, "Expected field-value separator or inherited message", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
                this.consumeValue(context, tokenizer, token);
                token = this.nextNotLineSep(tokenizer, "field or message end");
                continue;
            }
            if (field.getType() == PType.MESSAGE) {
                PMessageBuilder bld;
                reference = null;
                char symbol = tokenizer.expectSymbol("Message assigner or start", new char[]{'=', '{', '&'});
                if (symbol == '&') {
                    reference = context.initReference(tokenizer.expectIdentifier("reference name"), tokenizer);
                    symbol = tokenizer.expectSymbol("Message assigner or start after " + reference, new char[]{'=', '{'});
                }
                if (symbol == '=') {
                    token = tokenizer.expect("reference or message start");
                    if (UNDEFINED.equals(token.asString())) {
                        builder.clear(field.getKey());
                        context.setReference(reference, null);
                        token = this.nextNotLineSep(tokenizer, "field or message end");
                        continue;
                    }
                    bld = ((PMessageDescriptor)field.getDescriptor()).builder();
                    if (token.isReferenceIdentifier()) {
                        try {
                            PMessage ref = (PMessage)this.resolve(context, token, tokenizer, field.getDescriptor());
                            if (ref != null) {
                                bld.merge(ref);
                            } else {
                                if (tokenizer.peek().isSymbol('{')) {
                                    throw new TokenizerException(token, "Inherit from unknown reference %s", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                                }
                                if (this.strict) {
                                    throw new TokenizerException(token, "Unknown reference %s", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                                }
                            }
                        }
                        catch (KeyNotFoundException e) {
                            throw new TokenizerException(token, "Unknown inherited reference '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                        }
                        token = tokenizer.expect("after message reference");
                        if (!token.isSymbol('{')) {
                            builder.set(field.getKey(), context.setReference(reference, bld.build()));
                            continue;
                        }
                    } else if (!token.isSymbol('{')) {
                        throw new TokenizerException(token, "Unexpected token " + token.asString() + ", expected message start", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                } else {
                    bld = builder.mutator(field.getKey());
                }
                builder.set(field.getKey(), context.setReference(reference, this.parseMessage(tokenizer, context, bld)));
            } else if (field.getType() == PType.MAP) {
                token = tokenizer.expect("field sep or value start");
                Map baseValue = new HashMap();
                String reference2 = null;
                if (token.isSymbol('&')) {
                    reference2 = context.initReference(tokenizer.expectIdentifier("reference name"), tokenizer);
                    token = tokenizer.expect("field sep or value start");
                }
                if (token.isSymbol('=')) {
                    token = tokenizer.expect("field id or start");
                    if (UNDEFINED.equals(token.asString())) {
                        builder.clear(field.getKey());
                        context.setReference(reference2, null);
                        token = tokenizer.expect("message end or field");
                        continue;
                    }
                    if (token.isReferenceIdentifier()) {
                        try {
                            baseValue = (Map)this.resolve(context, token, tokenizer, field.getDescriptor());
                        }
                        catch (KeyNotFoundException e) {
                            throw new TokenizerException(token, e.getMessage(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                        }
                        token = tokenizer.expect("map start or next field");
                        if (!token.isSymbol('{')) {
                            builder.set(field.getKey(), context.setReference(reference2, baseValue));
                            continue;
                        }
                        if (baseValue == null) {
                            baseValue = new HashMap();
                        }
                    }
                } else {
                    baseValue.putAll((Map)((PMessage)builder.build()).get(field.getKey()));
                }
                if (!token.isSymbol('{')) {
                    throw new TokenizerException(token, "Expected map start, but got '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                Map map = this.parseMapValue(tokenizer, context, (PMap)field.getDescriptor(), baseValue);
                builder.set(field.getKey(), context.setReference(reference2, map));
            } else {
                reference = null;
                if (tokenizer.expectSymbol("field value sep", new char[]{'=', '&'}) == '&') {
                    reference = context.initReference(tokenizer.expectIdentifier("reference name"), tokenizer);
                    tokenizer.expectSymbol("field value sep", new char[]{'='});
                }
                if (UNDEFINED.equals((token = tokenizer.expect("field value")).asString())) {
                    builder.clear(field.getKey());
                    context.setReference(reference, null);
                } else {
                    Object value = this.parseFieldValue(token, tokenizer, context, field.getDescriptor());
                    builder.set(field.getKey(), context.setReference(reference, value));
                }
            }
            token = this.nextNotLineSep(tokenizer, "field or message end");
        }
        return (M)((PMessage)builder.build());
    }

    private Map parseMapValue(Tokenizer tokenizer, ProvidenceConfigContext context, PMap descriptor, Map builder) throws IOException {
        Token next = tokenizer.expect("map key or end");
        while (!next.isSymbol('}')) {
            Object key = this.parseFieldValue(next, tokenizer, context, descriptor.keyDescriptor());
            tokenizer.expectSymbol("map key value sep", new char[]{':'});
            next = tokenizer.expect("map value");
            if (UNDEFINED.equals(next.asString())) {
                builder.remove(key);
            } else {
                Object value = this.parseFieldValue(next, tokenizer, context, descriptor.itemDescriptor());
                builder.put(key, value);
            }
            if (!(next = tokenizer.expect("map key, end or sep")).isSymbol(',')) continue;
            next = tokenizer.expect("map key or end");
        }
        return descriptor.builder().putAll(builder).build();
    }

    private Object parseFieldValue(Token next, Tokenizer tokenizer, ProvidenceConfigContext context, PDescriptor descriptor) throws IOException {
        try {
            switch (descriptor.getType()) {
                case BOOL: {
                    if (TRUE.equals(next.asString())) {
                        return true;
                    }
                    if (FALSE.equals(next.asString())) {
                        return false;
                    }
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    break;
                }
                case BYTE: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isInteger()) {
                        return (byte)next.parseInteger();
                    }
                    break;
                }
                case I16: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isInteger()) {
                        return (short)next.parseInteger();
                    }
                    break;
                }
                case I32: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isInteger()) {
                        return (int)next.parseInteger();
                    }
                    break;
                }
                case I64: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isInteger()) {
                        return next.parseInteger();
                    }
                    break;
                }
                case DOUBLE: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isInteger() || next.isReal()) {
                        return next.parseDouble();
                    }
                    break;
                }
                case STRING: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isStringLiteral()) {
                        return next.decodeLiteral();
                    }
                    break;
                }
                case BINARY: {
                    if ("b64".equals(next.asString())) {
                        tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                        return Binary.fromBase64((String)tokenizer.readBinary(')'));
                    }
                    if ("hex".equals(next.asString())) {
                        tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                        return Binary.fromHexString((String)tokenizer.readBinary(')'));
                    }
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    break;
                }
                case ENUM: {
                    PEnumValue value;
                    PEnumDescriptor ed = (PEnumDescriptor)descriptor;
                    if (next.isInteger()) {
                        value = ed.getValueById((int)next.parseInteger());
                    } else if (next.isIdentifier()) {
                        value = ed.getValueByName(next.asString());
                        if (value == null && context.containsReference(next.asString())) {
                            value = (PEnumValue)this.resolve(context, next, tokenizer, (PDescriptor)ed);
                        }
                    } else {
                        if (!next.isReferenceIdentifier()) break;
                        value = (PEnumValue)this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (value == null && this.strict) {
                        throw new TokenizerException(next, "No such enum value %s for %s.", new Object[]{next.asString(), ed.getQualifiedName()}).setLine(tokenizer.getLine(next.getLineNo()));
                    }
                    return value;
                }
                case MESSAGE: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isSymbol('{')) {
                        return this.parseMessage(tokenizer, context, ((PMessageDescriptor)descriptor).builder());
                    }
                    break;
                }
                case MAP: {
                    if (next.isReferenceIdentifier()) {
                        Map resolved;
                        try {
                            resolved = (Map)this.resolve(context, next, tokenizer, descriptor);
                        }
                        catch (ClassCastException e) {
                            throw new TokenizerException(next, "Reference %s is not a map field ", new Object[]{next.asString()}).setLine(tokenizer.getLine(next.getLineNo()));
                        }
                        return resolved;
                    }
                    if (next.isSymbol('{')) {
                        return this.parseMapValue(tokenizer, context, (PMap)descriptor, new HashMap());
                    }
                    break;
                }
                case SET: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isSymbol('[')) {
                        PSet ct = (PSet)descriptor;
                        HashSet<Object> value = new HashSet<Object>();
                        next = tokenizer.expect("set value or end");
                        while (!next.isSymbol(']')) {
                            value.add(this.parseFieldValue(next, tokenizer, context, ct.itemDescriptor()));
                            if (tokenizer.expectSymbol("set separator or end", new char[]{',', ']'}) == ']') break;
                            next = tokenizer.expect("set value or end");
                        }
                        return ct.builder().addAll(value).build();
                    }
                    break;
                }
                case LIST: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(context, next, tokenizer, descriptor);
                    }
                    if (next.isSymbol('[')) {
                        PList ct = (PList)descriptor;
                        PList.Builder builder = ct.builder();
                        next = tokenizer.expect("list value or end");
                        while (!next.isSymbol(']')) {
                            builder.add(this.parseFieldValue(next, tokenizer, context, ct.itemDescriptor()));
                            if (tokenizer.expectSymbol("list separator or end", new char[]{',', ']'}) == ']') break;
                            next = tokenizer.expect("list value or end");
                        }
                        return builder.build();
                    }
                    break;
                }
                default: {
                    throw new TokenizerException(next, descriptor.getType() + " not supported!", new Object[0]).setLine(tokenizer.getLine(next.getLineNo()));
                }
            }
        }
        catch (KeyNotFoundException e) {
            throw new TokenizerException(next, e.getMessage(), new Object[0]).setLine(tokenizer.getLine(next.getLineNo()));
        }
        throw new TokenizerException(next, "Unhandled value \"%s\" for type %s", new Object[]{next.asString(), descriptor.getType()}).setLine(tokenizer.getLine(next.getLineNo()));
    }

    private Token nextNotLineSep(Tokenizer tokenizer, String message) throws IOException {
        if (tokenizer.peek().isSymbol(',') || tokenizer.peek().isSymbol(';')) {
            tokenizer.expect(message);
        }
        return tokenizer.expect(message);
    }

    private <V> V resolve(ProvidenceConfigContext context, Token token, Tokenizer tokenizer, PDescriptor descriptor) throws TokenizerException {
        Object value = this.resolveAny(context, token, tokenizer);
        if (value == null) {
            return null;
        }
        switch (descriptor.getType()) {
            case BOOL: {
                return (V)Boolean.valueOf(ConfigUtil.asBoolean((Object)value));
            }
            case BYTE: {
                return (V)Byte.valueOf((byte)ConfigUtil.asInteger((Object)value));
            }
            case I16: {
                return (V)Short.valueOf((short)ConfigUtil.asInteger((Object)value));
            }
            case I32: {
                return (V)Integer.valueOf(ConfigUtil.asInteger((Object)value));
            }
            case I64: {
                return (V)Long.valueOf(ConfigUtil.asLong((Object)value));
            }
            case DOUBLE: {
                return (V)Double.valueOf(ConfigUtil.asDouble((Object)value));
            }
            case ENUM: {
                if (value instanceof PEnumValue) {
                    PEnumValue verified = ((PEnumDescriptor)descriptor).getValueById(((PEnumValue)value).getValue());
                    if (value.equals(verified)) {
                        return (V)value;
                    }
                } else {
                    if (value instanceof Number) {
                        return (V)((PEnumDescriptor)descriptor).getValueById(((Number)value).intValue());
                    }
                    if (value instanceof CharSequence) {
                        return (V)((PEnumDescriptor)descriptor).getValueByName(value.toString());
                    }
                }
                throw new IncompatibleValueException(value.getClass().getSimpleName() + " is not compatible with " + descriptor.getQualifiedName(), new Object[0]);
            }
            case STRING: {
                return (V)ConfigUtil.asString((Object)value);
            }
            case BINARY: {
                if (value instanceof Binary) {
                    return (V)value;
                }
                if (value instanceof CharSequence) {
                    return (V)Binary.fromBase64((String)value.toString());
                }
                throw new IncompatibleValueException(value.getClass().getSimpleName() + " is not compatible with binary", new Object[0]);
            }
            case MAP: {
                if (value instanceof Map) {
                    return (V)value;
                }
                throw new IncompatibleValueException(value.getClass().getSimpleName() + " is not compatible with map", new Object[0]);
            }
            case SET: 
            case LIST: {
                if (value instanceof Collection) {
                    return (V)value;
                }
                throw new IncompatibleValueException(value.getClass().getSimpleName() + " is not compatible with " + descriptor.getType(), new Object[0]);
            }
            case MESSAGE: {
                if (value instanceof PMessage && descriptor.equals(((PMessage)value).descriptor())) {
                    return (V)value;
                }
                throw new IncompatibleValueException(value.getClass().getSimpleName() + " is not compatible with " + descriptor.getQualifiedName(), new Object[0]);
            }
        }
        throw new IllegalArgumentException("Type " + descriptor.getType() + " is not handled by config.");
    }

    private Object resolveAny(ProvidenceConfigContext context, Token token, Tokenizer tokenizer) throws TokenizerException {
        String key;
        String name = key = token.asString();
        String subKey = null;
        if (key.contains(IDENTIFIER_SEP)) {
            int idx = key.indexOf(IDENTIFIER_SEP);
            name = key.substring(0, idx);
            subKey = key.substring(idx + 1);
        }
        Object value = context.getReference(name, token, tokenizer);
        if (subKey != null) {
            if (!(value instanceof PMessage)) {
                throw new TokenizerException(token, "Reference name " + key + " not declared", new Object[0]);
            }
            try {
                return ProvidenceConfigUtil.getInMessage((PMessage)value, subKey, null);
            }
            catch (IncompatibleValueException | KeyNotFoundException e) {
                throw new TokenizerException(token, e.getMessage(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo())).initCause(e);
            }
        }
        return value;
    }

    private static enum Stage {
        INCLUDES,
        DEFINES,
        MESSAGE;

    }
}

