/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.util.Map;
import java.util.Set;
import net.morimekta.config.IncompatibleValueException;
import net.morimekta.config.KeyNotFoundException;
import net.morimekta.config.util.ConfigUtil;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.util.Binary;
import net.morimekta.util.Numeric;

public class ProvidenceConfigUtil {
    public static Object getInMessage(PMessage message, String key) {
        return ProvidenceConfigUtil.getInMessage(message, key, null);
    }

    public static Object getInMessage(PMessage message, String key, Object defValue) {
        PMessageDescriptor descriptor = message.descriptor();
        if (key.contains(".")) {
            int idx = key.indexOf(".");
            String name = key.substring(0, idx);
            String sub = key.substring(idx + 1);
            PField field = descriptor.getField(name);
            if (field == null) {
                throw new KeyNotFoundException("Message " + message.descriptor().getQualifiedName() + " has no field named " + name, new Object[0]);
            }
            PDescriptor fieldDesc = field.getDescriptor();
            if (fieldDesc.getType() != PType.MESSAGE) {
                throw new IncompatibleValueException("Field " + name + " is not of message type in " + descriptor.getQualifiedName(), new Object[0]);
            }
            if (!message.has(field.getKey())) {
                while (sub.contains(".")) {
                    if (fieldDesc.getType() != PType.MESSAGE) {
                        throw new IncompatibleValueException("Field " + name + " is not of message type in " + descriptor.getQualifiedName(), new Object[0]);
                    }
                    idx = sub.indexOf(".");
                    name = sub.substring(0, idx);
                    sub = sub.substring(idx + 1);
                    field = ((PMessageDescriptor)fieldDesc).getField(name);
                    fieldDesc = field.getDescriptor();
                }
                return ProvidenceConfigUtil.asFieldType(field, defValue);
            }
            return ProvidenceConfigUtil.getInMessage((PMessage)message.get(field.getKey()), sub, defValue);
        }
        PField field = message.descriptor().getField(key);
        if (field == null) {
            throw new KeyNotFoundException("Message " + message.descriptor().getQualifiedName() + " has no field named " + key, new Object[0]);
        }
        if (!message.has(field.getKey())) {
            return ProvidenceConfigUtil.asFieldType(field, defValue);
        }
        return message.get(field.getKey());
    }

    protected static void buildKeySet(String prefix, PMessage message, Set<String> valueKeySet) {
        for (PField field : message.descriptor().getFields()) {
            if (!message.has(field.getKey())) continue;
            String key = ProvidenceConfigUtil.makeKey(prefix, field);
            if (field.getType() == PType.MESSAGE) {
                ProvidenceConfigUtil.buildKeySet(key, (PMessage)message.get(field.getKey()), valueKeySet);
                continue;
            }
            valueKeySet.add(key);
        }
    }

    private static String makeKey(String prefix, PField field) {
        if (prefix == null) {
            return field.getName();
        }
        return prefix + "." + field.getName();
    }

    private static Object asFieldType(PField field, Object o) {
        if (o == null) {
            return field.getDefaultValue();
        }
        switch (field.getType()) {
            case VOID: {
                return null;
            }
            case BOOL: {
                return ConfigUtil.asBoolean((Object)o);
            }
            case BYTE: {
                return (byte)ConfigUtil.asInteger((Object)o);
            }
            case I16: {
                return (short)ConfigUtil.asInteger((Object)o);
            }
            case I32: {
                return ConfigUtil.asInteger((Object)o);
            }
            case I64: {
                return ConfigUtil.asLong((Object)o);
            }
            case DOUBLE: {
                return ConfigUtil.asDouble((Object)o);
            }
            case ENUM: {
                if (o instanceof Number) {
                    return ((PEnumDescriptor)field.getDescriptor()).getValueById(((Number)o).intValue());
                }
                if (o instanceof Numeric) {
                    return ((PEnumDescriptor)field.getDescriptor()).getValueById(((Numeric)o).asInteger());
                }
                if (o instanceof CharSequence) {
                    return ((PEnumDescriptor)field.getDescriptor()).getValueByName(o.toString());
                }
                throw new IncompatibleValueException("Unable to cast " + o.getClass().getSimpleName() + " to enum type.", new Object[0]);
            }
            case MESSAGE: {
                if (o instanceof PMessage) {
                    return o;
                }
                throw new IncompatibleValueException("Unable to cast " + o.getClass().getSimpleName() + " to message.", new Object[0]);
            }
            case STRING: {
                return ConfigUtil.asString((Object)o);
            }
            case BINARY: {
                if (o instanceof Binary) {
                    return o;
                }
                if (o instanceof CharSequence) {
                    return Binary.fromBase64((String)o.toString());
                }
                throw new IncompatibleValueException("Unable to cast " + o.getClass().getSimpleName() + " to binary.", new Object[0]);
            }
            case LIST: {
                return ((PList)field.getDescriptor()).builder().addAll(ConfigUtil.asCollection((Object)o)).build();
            }
            case SET: {
                return ((PSet)field.getDescriptor()).builder().addAll(ConfigUtil.asCollection((Object)o)).build();
            }
            case MAP: {
                if (o instanceof Map) {
                    return o;
                }
                throw new IncompatibleValueException("Unable to cast " + o.getClass().getSimpleName() + " to map.", new Object[0]);
            }
        }
        throw new IllegalStateException("Unhandled field type: " + field.getType());
    }
}

