/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.morimekta.config.KeyNotFoundException;
import net.morimekta.config.util.ConfigUtil;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.config.ProvidenceConfigParam;
import net.morimekta.providence.config.ProvidenceConfigUtil;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.util.TypeRegistry;
import net.morimekta.providence.util.pretty.Token;
import net.morimekta.providence.util.pretty.Tokenizer;
import net.morimekta.providence.util.pretty.TokenizerException;
import net.morimekta.util.Binary;

public class ProvidenceConfig {
    private static final String IDENTIFIER_SEP = ".";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String PARAMS = "params";
    static final String UNDEFINED = "undefined";
    private static final String INCLUDE = "include";
    private static final String AS = "as";
    private final Map<String, AtomicReference<PMessage>> loaded;
    private final Map<String, Supplier<PMessage>> parents;
    private final TypeRegistry registry;
    private final Map<String, String> inputParams;
    private final Map<String, Set<String>> reverseDependencies;
    private final boolean strict;

    public ProvidenceConfig(TypeRegistry registry) {
        this(registry, (Map<String, String>)ImmutableMap.of());
    }

    public ProvidenceConfig(TypeRegistry registry, Map<String, String> inputParams) {
        this(registry, inputParams, false);
    }

    public ProvidenceConfig(TypeRegistry registry, Map<String, String> inputParams, boolean strict) {
        this.registry = registry;
        this.inputParams = ImmutableMap.copyOf(inputParams);
        this.loaded = new ConcurrentHashMap<String, AtomicReference<PMessage>>();
        this.parents = new ConcurrentHashMap<String, Supplier<PMessage>>();
        this.reverseDependencies = new HashMap<String, Set<String>>();
        this.strict = strict;
    }

    private Set<String> getReverseDeps(String to) {
        return this.reverseDependencies.computeIfAbsent(to, k -> new HashSet());
    }

    public <M extends PMessage<M, F>, F extends PField> M getConfig(File file) throws IOException {
        Supplier<M> supplier = this.getSupplier(file);
        return (M)((PMessage)supplier.get());
    }

    public <M extends PMessage<M, F>, F extends PField> M getConfig(File file, PMessageDescriptor<M, F> descriptor) throws IOException {
        return (M)((PMessage)this.getSupplier(file, descriptor).get());
    }

    public synchronized <M extends PMessage<M, F>, F extends PField> Supplier<M> getSupplier(File file) throws IOException {
        try {
            AtomicReference<M> reference = this.loadConfigRecursively(this.resolveFile(null, file.getPath()), new String[0]);
            return reference::get;
        }
        catch (FileNotFoundException e) {
            throw new TokenizerException(e.getMessage(), new Object[]{e}).setFile(file.getName());
        }
    }

    public synchronized <M extends PMessage<M, F>, F extends PField> Supplier<M> getSupplierWithParent(File file, Supplier<M> parent) throws IOException {
        try {
            File config = this.resolveFile(null, file.getPath());
            String path = config.getCanonicalFile().getAbsolutePath();
            this.parents.computeIfAbsent(path, name -> parent);
            AtomicReference<M> reference = this.loadConfigRecursively(config, new String[0]);
            return reference::get;
        }
        catch (FileNotFoundException e) {
            throw new TokenizerException(e.getMessage(), new Object[]{e}).setFile(file.getName());
        }
    }

    public synchronized <M extends PMessage<M, F>, F extends PField> Supplier<M> getSupplierWithParent(File configFile, File parentFile) throws IOException {
        return this.getSupplierWithParent(configFile, parentFile, null);
    }

    public synchronized <M extends PMessage<M, F>, F extends PField> Supplier<M> getSupplierWithParent(File configFile, File parentFile, PMessageDescriptor<M, F> descriptor) throws IOException {
        try {
            String configPath = this.resolveFile(null, configFile.getPath()).getCanonicalFile().getAbsolutePath();
            String parentPath = this.resolveFile(null, parentFile.getPath()).getCanonicalFile().getAbsolutePath();
            AtomicReference<PMessage> parent = this.loaded.get(parentPath);
            if (parent == null) {
                throw new TokenizerException("Parent file " + parentFile.getName() + " is not loaded.", new Object[0]).setFile(configFile.getName());
            }
            if (descriptor != null && !parent.get().descriptor().equals(descriptor)) {
                throw new TokenizerException(String.format(Locale.ENGLISH, "Incompatible message type: Expected %s, got %s", descriptor.getQualifiedName(), parent.get().descriptor().getQualifiedName()), new Object[0]).setFile(configFile.getPath());
            }
            Supplier<PMessage> supplier = this.getSupplierWithParent(configFile, parent::get);
            if (descriptor != null && !supplier.get().descriptor().equals(descriptor)) {
                throw new TokenizerException(String.format(Locale.ENGLISH, "Incompatible message type: Expected %s, got %s", descriptor.getQualifiedName(), supplier.get().descriptor().getQualifiedName()), new Object[0]).setFile(configFile.getPath());
            }
            this.getReverseDeps(parentPath).add(configPath);
            return supplier;
        }
        catch (FileNotFoundException e) {
            throw new TokenizerException(e.getMessage(), new Object[]{e}).setFile(configFile.getName());
        }
    }

    public <M extends PMessage<M, F>, F extends PField> Supplier<M> getSupplier(File file, PMessageDescriptor<M, F> descriptor) throws IOException {
        try {
            Supplier<M> supplier = this.getSupplier(file);
            if (descriptor != null && !((PMessage)supplier.get()).descriptor().equals(descriptor)) {
                throw new TokenizerException(String.format(Locale.ENGLISH, "Incompatible message type: Expected %s, got %s", descriptor.getQualifiedName(), ((PMessage)supplier.get()).descriptor().getQualifiedName()), new Object[0]).setFile(file.getPath());
            }
            return supplier;
        }
        catch (FileNotFoundException e) {
            throw new TokenizerException(e.getMessage(), new Object[0]).setFile(file.getName());
        }
    }

    public List<ProvidenceConfigParam> params(File file) throws IOException {
        return this.loadParamsRecursively(this.resolveFile(null, file.toString()), new String[0]);
    }

    public void reload(File file) throws IOException {
        String canonicalPath = file.getCanonicalFile().getAbsolutePath();
        AtomicReference<PMessage> reference = this.loaded.get(canonicalPath);
        if (reference == null) {
            return;
        }
        TreeSet<String> dependencies = new TreeSet<String>(this.getReverseDeps(canonicalPath));
        try {
            Object reloaded = this.parseConfigRecursively(file, new String[]{canonicalPath});
            if (reference.get().equals(reloaded)) {
                return;
            }
            reference.set((PMessage)reloaded);
            for (String dep : dependencies) {
                this.reload(new File(dep));
            }
        }
        catch (IOException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    File resolveFile(File ref, String path) throws IOException {
        File tmp;
        if (ref == null) {
            File tmp2 = new File(path).getCanonicalFile().getAbsoluteFile();
            if (tmp2.exists()) {
                if (tmp2.isFile()) {
                    return tmp2;
                }
                throw new FileNotFoundException(path + " is a directory, expected file");
            }
            throw new FileNotFoundException("File " + path + " not found");
        }
        if (path.startsWith("/")) {
            throw new FileNotFoundException("Absolute path includes not allowed: " + path);
        }
        if (!ref.isDirectory()) {
            ref = ref.getParentFile();
        }
        if ((tmp = new File(ref, path).getCanonicalFile().getAbsoluteFile()).exists()) {
            if (tmp.isFile()) {
                return tmp;
            }
            throw new FileNotFoundException(path + " is a directory, expected file");
        }
        throw new FileNotFoundException("Included file " + path + " not found");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<ProvidenceConfigParam> loadParamsRecursively(File file, String ... stack) throws IOException {
        try {
            Tokenizer tokenizer;
            File canonicalFile = file.getCanonicalFile().getAbsoluteFile();
            String filePath = canonicalFile.toString();
            LinkedList<String> stackList = new LinkedList<String>();
            Collections.addAll(stackList, stack);
            if (stackList.contains(filePath)) {
                stackList.add(filePath);
                throw new TokenizerException("Circular includes detected: " + String.join((CharSequence)" -> ", stackList.stream().map(p -> new File((String)p).getName()).collect(Collectors.toList())), new Object[0]);
            }
            stackList.add(filePath);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(canonicalFile));){
                tokenizer = new Tokenizer((InputStream)in, false);
            }
            LinkedList<ProvidenceConfigParam> result = new LinkedList<ProvidenceConfigParam>();
            Stage stage = Stage.PARAMS;
            Token token = tokenizer.peek();
            while (token != null) {
                tokenizer.next();
                if (token.isQualifiedIdentifier()) {
                    return result;
                }
                if (!token.isIdentifier()) throw new TokenizerException(token, "Unexpected token " + token.asString() + "expected include, params or message type", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                if (PARAMS.equals(token.asString())) {
                    if (stage != Stage.PARAMS) {
                        throw new TokenizerException(token, "Params already defined.", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    stage = Stage.INCLUDES;
                    this.parseParams(tokenizer).entrySet().forEach(e -> result.add(new ProvidenceConfigParam((String)e.getKey(), e.getValue(), canonicalFile)));
                } else {
                    File includedFile;
                    if (!INCLUDE.equals(token.asString())) throw new TokenizerException(token, "Unexpected token " + token.asString() + "expected include, params or message type", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    token = tokenizer.expect("file to be included");
                    try {
                        includedFile = this.resolveFile(file, token.decodeLiteral());
                        result.addAll(this.loadParamsRecursively(includedFile, stackList.toArray(new String[stackList.size()])));
                    }
                    catch (FileNotFoundException e2) {
                        throw new TokenizerException(token, "Included file " + token.asString() + " not found", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    if (!AS.equals(tokenizer.expectIdentifier("the token 'as'").asString())) {
                        throw new TokenizerException(token, "Missing alias for included file " + includedFile, new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    tokenizer.expectIdentifier("Include alias").asString();
                }
                token = tokenizer.peek();
            }
            throw new TokenizerException("No message in config: " + filePath, new Object[0]);
        }
        catch (TokenizerException e3) {
            throw new TokenizerException(e3, file);
        }
    }

    @Nonnull
    private <M extends PMessage<M, F>, F extends PField> AtomicReference<M> loadConfigRecursively(File file, String ... stack) throws IOException {
        try {
            AtomicReference<Object> ref;
            file = file.getCanonicalFile().getAbsoluteFile();
            String filePath = file.toString();
            LinkedList<String> stackList = new LinkedList<String>();
            Collections.addAll(stackList, stack);
            if (stackList.contains(filePath)) {
                stackList.add(filePath);
                throw new TokenizerException("Circular includes detected: " + String.join((CharSequence)" -> ", stackList.stream().map(p -> new File((String)p).getName()).collect(Collectors.toList())), new Object[0]);
            }
            if (this.loaded.containsKey(filePath)) {
                if (stack.length > 0) {
                    this.getReverseDeps(filePath).add(stack[stack.length - 1]);
                }
                return this.loaded.get(filePath);
            }
            stackList.add(filePath);
            M result = this.parseConfigRecursively(file, stackList.toArray(new String[stackList.size()]));
            if (result == null) {
                return new AtomicReference();
            }
            stackList.add(filePath);
            if (stack.length > 0) {
                this.getReverseDeps(filePath).add(stack[stack.length - 1]);
            }
            if ((ref = this.loaded.get(filePath)) == null) {
                ref = new AtomicReference<M>(result);
                this.loaded.put(filePath, ref);
            } else {
                ref.set((PMessage)result);
            }
            return ref;
        }
        catch (TokenizerException e) {
            throw new TokenizerException(e, file);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <M extends PMessage<M, F>, F extends PField> M parseConfigRecursively(File file, String[] stack) throws IOException {
        Tokenizer tokenizer;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            tokenizer = new Tokenizer((InputStream)bufferedInputStream, false);
        }
        HashMap hashMap = new HashMap();
        HashMap<String, PMessage> includes = new HashMap<String, PMessage>();
        Stage stage = Stage.PARAMS;
        M result = null;
        Token token = tokenizer.peek();
        while (token != null) {
            tokenizer.next();
            if (stage == Stage.MESSAGE) {
                throw new TokenizerException(token, "Unexpected token " + token.asString() + ", expected end of file.", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            if (token.isQualifiedIdentifier()) {
                void var4_5;
                PMessageDescriptor descriptor;
                stage = Stage.MESSAGE;
                try {
                    descriptor = (PMessageDescriptor)this.registry.getDeclaredType(token.asString());
                }
                catch (IllegalArgumentException e) {
                    if (!this.strict && stack.length != 1) return null;
                    throw new TokenizerException(token, "Unknown declared type: %s", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                result = this.parseConfigMessage(tokenizer, includes, this.mkParams((Map<String, Object>)var4_5), descriptor.builder(), file);
            } else {
                if (!token.isIdentifier()) throw new TokenizerException(token, "Unexpected token " + token.asString() + "expected include, params or message type", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                if (PARAMS.equals(token.asString())) {
                    if (stage != Stage.PARAMS) {
                        throw new TokenizerException(token, "Params already defined, or passed; must be at head of file", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    stage = Stage.INCLUDES;
                    Map<String, Object> map = this.parseParams(tokenizer);
                } else {
                    PMessage included;
                    File includedFile;
                    if (!INCLUDE.equals(token.asString())) throw new TokenizerException(token, "Unexpected token " + token.asString() + "expected include, params or message type", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    stage = Stage.INCLUDES;
                    token = tokenizer.expectStringLiteral("file to be included");
                    try {
                        includedFile = this.resolveFile(file, token.decodeLiteral());
                        included = (PMessage)this.loadConfigRecursively(includedFile, stack).get();
                    }
                    catch (FileNotFoundException e) {
                        throw new TokenizerException(token, "Included file " + token.asString() + " not found", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    if (!AS.equals(tokenizer.expectIdentifier("the token 'as'").asString())) {
                        throw new TokenizerException(token, "Missing alias for included file " + includedFile, new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    String alias = tokenizer.expectIdentifier("Include alias").asString();
                    if (includes.containsKey(alias)) {
                        throw new TokenizerException(token, "Alias \"" + alias + "\" is already used", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    if (PARAMS.equals(alias) || INCLUDE.equals(alias) || AS.equals(alias)) {
                        throw new TokenizerException(token, "Alias \"" + alias + "\" is reserved word", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    includes.put(alias, included);
                }
            }
            token = tokenizer.peek();
        }
        if (result != null) return result;
        throw new TokenizerException("No message in config: " + file.getName(), new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> parseParams(Tokenizer tokenizer) throws IOException {
        HashMap<String, Object> out = new HashMap<String, Object>();
        tokenizer.expectSymbol("params start", new char[]{'{'});
        Token token = tokenizer.expect("param or end");
        while (!token.isSymbol('}')) {
            if (!token.isIdentifier()) {
                throw new TokenizerException(token, "Param name " + token.asString() + " not valid", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            String name = token.asString();
            tokenizer.expectSymbol("param value sep", new char[]{'='});
            token = tokenizer.expect("param value");
            if (token.isReal()) {
                out.put(name, Double.parseDouble(token.asString()));
            } else if (token.isInteger()) {
                out.put(name, Long.parseLong(token.asString()));
            } else if (token.isStringLiteral()) {
                out.put(name, token.decodeLiteral());
            } else if (TRUE.equalsIgnoreCase(token.asString())) {
                out.put(name, true);
            } else if (FALSE.equalsIgnoreCase(token.asString())) {
                out.put(name, false);
            } else if ("b64".equals(token.asString())) {
                tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                out.put(name, Binary.fromBase64((String)tokenizer.readUntil(')', false, false)));
            } else if ("hex".equals(token.asString())) {
                tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                out.put(name, Binary.fromHexString((String)tokenizer.readUntil(')', false, false)));
            } else {
                if (!token.isDoubleQualifiedIdentifier()) throw new TokenizerException(token, "Invalid param value " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                String id = token.asString();
                int l = id.lastIndexOf(46);
                try {
                    PEnumDescriptor ed = (PEnumDescriptor)this.registry.getDeclaredType(id.substring(0, l));
                    PEnumValue val = ed.getValueByName(id.substring(l + 1));
                    if (val == null && this.strict) {
                        throw new TokenizerException(token, "Unknown %s value: %s", new Object[]{id.substring(0, l), id.substring(l + 1)}).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    out.put(name, val);
                }
                catch (IllegalArgumentException e) {
                    if (this.strict) {
                        throw new TokenizerException(token, "Unknown enum identifier: %s", new Object[]{id.substring(0, l)}).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                }
                catch (ClassCastException e) {
                    throw new TokenizerException(token, "Identifier " + id + " does not reference an enum, from " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
            }
            token = tokenizer.expect("next param or end");
        }
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <M extends PMessage<M, F>, F extends PField> M parseConfigMessage(Tokenizer tokenizer, Map<String, PMessage> includes, Map<String, Object> params, PMessageBuilder<M, F> builder, File file) throws IOException {
        String path = file.getCanonicalFile().getAbsolutePath();
        if (tokenizer.expectSymbol("extension marker", new char[]{':', '{'}) == ':') {
            Token token = tokenizer.expect("extension object");
            if (this.parents.containsKey(path)) {
                throw new TokenizerException(token, "Config in '" + file.getName() + "' has both defined parent and inherits from", new Object[0]).setLine(tokenizer.getLine(token.getLineNo())).setFile(file.getName());
            }
            if (!token.isReferenceIdentifier()) throw new TokenizerException(token, "Unexpected token " + token.asString() + ", expected reference identifier", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            try {
                builder.merge((PMessage)this.resolve(includes, params, token.asString()));
            }
            catch (KeyNotFoundException e) {
                throw new TokenizerException(token, e.getMessage(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            tokenizer.expectSymbol("object begin", new char[]{'{'});
            return this.parseMessage(tokenizer, includes, params, builder);
        }
        if (!this.parents.containsKey(path)) return this.parseMessage(tokenizer, includes, params, builder);
        builder.merge(this.parents.get(path).get());
        return this.parseMessage(tokenizer, includes, params, builder);
    }

    private void consumeValue(Tokenizer tokenizer, Token token) throws IOException {
        if (UNDEFINED.equals(token.asString())) {
            return;
        }
        if (token.isReferenceIdentifier()) {
            if (!tokenizer.peek().isSymbol('{')) {
                return;
            }
            token = tokenizer.next();
        }
        if (token.isSymbol('{')) {
            token = tokenizer.expect("map or message first entry");
            if (!token.isSymbol('}') && !token.isIdentifier()) {
                while (!token.isSymbol('}')) {
                    if (token.isIdentifier() || token.isReferenceIdentifier()) {
                        throw new TokenizerException(token, "Invalid map key: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    this.consumeValue(tokenizer, token);
                    tokenizer.expectSymbol("key value sep.", new char[]{':'});
                    this.consumeValue(tokenizer, tokenizer.expect("map value"));
                    token = tokenizer.expect("map key, end or sep");
                    if (!token.isSymbol(',')) continue;
                    token = tokenizer.expect("map key or end");
                }
            } else {
                while (!token.isSymbol('}')) {
                    if (!token.isIdentifier()) {
                        throw new TokenizerException(token, "Invalid field name: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    if (tokenizer.peek().isSymbol('{')) {
                        this.consumeValue(tokenizer, tokenizer.next());
                    } else {
                        tokenizer.expectSymbol("field value sep.", new char[]{'='});
                        this.consumeValue(tokenizer, tokenizer.next());
                    }
                    token = this.nextNotLineSep(tokenizer, "message field or end");
                }
            }
        } else if (token.isSymbol('[')) {
            token = tokenizer.next();
            while (!token.isSymbol(']')) {
                this.consumeValue(tokenizer, token);
                if (tokenizer.expectSymbol("list separator or end", new char[]{',', ']'}) != ']') {
                    token = tokenizer.expect("list value or end");
                    continue;
                }
                break;
            }
        } else if (token.asString().equals("hex")) {
            tokenizer.expectSymbol("hex body start", new char[]{'('});
            tokenizer.readUntil(')', false, false);
        } else if (!(token.isReal() || token.isInteger() || token.isStringLiteral() || token.isIdentifier())) {
            throw new TokenizerException(token, "Unknown value token '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
        }
    }

    private <M extends PMessage<M, F>, F extends PField> M parseMessage(Tokenizer tokenizer, Map<String, PMessage> includes, Map<String, Object> params, PMessageBuilder<M, F> builder) throws IOException {
        PMessageDescriptor descriptor = builder.descriptor();
        Token token = tokenizer.expect("object end or field");
        while (!token.isSymbol('}')) {
            if (!token.isIdentifier()) {
                throw new TokenizerException(token, "Invalid field name: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            PField field = descriptor.getField(token.asString());
            if (field == null) {
                if (this.strict) {
                    throw new TokenizerException("No such field " + token.asString() + " in " + descriptor.getQualifiedName(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
                token = tokenizer.expect("field value sep or message start");
                if (token.isSymbol('=')) {
                    token = tokenizer.expect("value declaration");
                } else if (!token.isSymbol('{')) {
                    throw new TokenizerException(token, "Expected field-value separator or inherited message", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
                this.consumeValue(tokenizer, token);
                token = this.nextNotLineSep(tokenizer, "field or message end");
                continue;
            }
            if (field.getType() == PType.MESSAGE) {
                PMessageBuilder bld;
                char symbol = tokenizer.expectSymbol("Message assigner or start", new char[]{'=', '{'});
                if (symbol == '=') {
                    token = tokenizer.expect("reference or message start");
                    if (UNDEFINED.equals(token.asString())) {
                        builder.clear(field.getKey());
                        token = this.nextNotLineSep(tokenizer, "field or message end");
                        continue;
                    }
                    bld = ((PMessageDescriptor)field.getDescriptor()).builder();
                    if (token.isReferenceIdentifier()) {
                        try {
                            PMessage ref = (PMessage)this.resolve(includes, params, token.asString());
                            if (ref != null) {
                                bld.merge(ref);
                            } else {
                                if (tokenizer.peek().isSymbol('{')) {
                                    throw new TokenizerException(token, "Inherit from unknown reference %s", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                                }
                                if (this.strict) {
                                    throw new TokenizerException(token, "Unknown reference %s", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                                }
                            }
                        }
                        catch (KeyNotFoundException e) {
                            throw new TokenizerException(token, "Unknown inherited reference '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                        }
                        token = tokenizer.expect("after message reference");
                        if (!token.isSymbol('{')) {
                            builder.set(field.getKey(), bld.build());
                            continue;
                        }
                    } else if (!token.isSymbol('{')) {
                        throw new TokenizerException(token, "Unexpected token " + token.asString() + ", expected message start", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                } else {
                    bld = builder.mutator(field.getKey());
                }
                builder.set(field.getKey(), this.parseMessage(tokenizer, includes, params, bld));
            } else if (field.getType() == PType.MAP) {
                token = tokenizer.expect("field sep or value start");
                HashMap baseValue = new HashMap();
                if (token.isSymbol('=')) {
                    token = tokenizer.expect("field id or start");
                    if (UNDEFINED.equals(token.asString())) {
                        builder.clear(field.getKey());
                        token = tokenizer.expect("message end or field");
                        continue;
                    }
                    if (token.isReferenceIdentifier()) {
                        try {
                            baseValue.putAll((Map)this.resolve(includes, params, token.asString()));
                        }
                        catch (KeyNotFoundException e) {
                            throw new TokenizerException(token, e.getMessage(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                        }
                        catch (ClassCastException e) {
                            throw new TokenizerException(token, "Reference %s not pointing to a map.", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                        }
                        token = tokenizer.expect("map start or next field");
                        if (!token.isSymbol('{')) {
                            continue;
                        }
                    }
                } else {
                    baseValue.putAll((Map)((PMessage)builder.build()).get(field.getKey()));
                }
                if (!token.isSymbol('{')) {
                    throw new TokenizerException(token, "Expected map start, but got '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                builder.set(field.getKey(), (Object)this.parseMapValue(tokenizer, includes, params, (PMap)field.getDescriptor(), baseValue));
            } else {
                tokenizer.expectSymbol("field value sep", new char[]{'='});
                token = tokenizer.expect("field value");
                if (UNDEFINED.equals(token.asString())) {
                    builder.clear(field.getKey());
                } else {
                    builder.set(field.getKey(), this.parseFieldValue(token, tokenizer, includes, params, field.getDescriptor()));
                }
            }
            token = this.nextNotLineSep(tokenizer, "field or message end");
        }
        return (M)((PMessage)builder.build());
    }

    private Map parseMapValue(Tokenizer tokenizer, Map<String, PMessage> includes, Map<String, Object> params, PMap descriptor, Map builder) throws IOException {
        Token next = tokenizer.expect("map key or end");
        while (!next.isSymbol('}')) {
            Object key = this.parseFieldValue(next, tokenizer, includes, params, descriptor.keyDescriptor());
            tokenizer.expectSymbol("map key value sep", new char[]{':'});
            next = tokenizer.expect("map value");
            if (UNDEFINED.equals(next.asString())) {
                builder.remove(key);
            } else {
                Object value = this.parseFieldValue(next, tokenizer, includes, params, descriptor.itemDescriptor());
                builder.put(key, value);
            }
            if (!(next = tokenizer.expect("map key, end or sep")).isSymbol(',')) continue;
            next = tokenizer.expect("map key or end");
        }
        return descriptor.builder().putAll(builder).build();
    }

    private Object parseFieldValue(Token next, Tokenizer tokenizer, Map<String, PMessage> includes, Map<String, Object> params, PDescriptor descriptor) throws IOException {
        try {
            switch (descriptor.getType()) {
                case BOOL: {
                    if (TRUE.equals(next.asString())) {
                        return true;
                    }
                    if (FALSE.equals(next.asString())) {
                        return false;
                    }
                    if (next.isReferenceIdentifier()) {
                        return ConfigUtil.asBoolean(this.resolve(includes, params, next.asString()));
                    }
                    break;
                }
                case BYTE: {
                    if (next.isReferenceIdentifier()) {
                        return (byte)ConfigUtil.asInteger(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isInteger()) {
                        return (byte)next.parseInteger();
                    }
                    break;
                }
                case I16: {
                    if (next.isReferenceIdentifier()) {
                        return (short)ConfigUtil.asInteger(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isInteger()) {
                        return (short)next.parseInteger();
                    }
                    break;
                }
                case I32: {
                    if (next.isReferenceIdentifier()) {
                        return ConfigUtil.asInteger(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isInteger()) {
                        return (int)next.parseInteger();
                    }
                    break;
                }
                case I64: {
                    if (next.isReferenceIdentifier()) {
                        return ConfigUtil.asLong(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isInteger()) {
                        return next.parseInteger();
                    }
                    break;
                }
                case DOUBLE: {
                    if (next.isReferenceIdentifier()) {
                        return ConfigUtil.asDouble(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isInteger() || next.isReal()) {
                        return next.parseDouble();
                    }
                    break;
                }
                case STRING: {
                    if (next.isReferenceIdentifier()) {
                        return ConfigUtil.asString(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isStringLiteral()) {
                        return next.decodeLiteral();
                    }
                    break;
                }
                case BINARY: {
                    if ("b64".equals(next.asString())) {
                        tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                        return Binary.fromBase64((String)tokenizer.readUntil(')', false, false));
                    }
                    if ("hex".equals(next.asString())) {
                        tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                        return Binary.fromHexString((String)tokenizer.readUntil(')', false, false));
                    }
                    if (next.isReferenceIdentifier()) {
                        Object o = this.resolve(includes, params, next.asString());
                        if (o instanceof Binary) {
                            return o;
                        }
                        if (o instanceof CharSequence) {
                            return Binary.fromBase64((String)((String)o));
                        }
                        throw new TokenizerException(next, "Reference %s (%s) is not a binary", new Object[]{next.asString(), o.getClass().getSimpleName()}).setLine(tokenizer.getLine(next.getLineNo()));
                    }
                    break;
                }
                case ENUM: {
                    PEnumValue value;
                    PEnumDescriptor ed = (PEnumDescriptor)descriptor;
                    if (next.isInteger()) {
                        value = ed.getValueById((int)next.parseInteger());
                    } else if (next.isIdentifier()) {
                        value = ed.getValueByName(next.asString());
                    } else {
                        if (!next.isReferenceIdentifier()) break;
                        value = (PEnumValue)this.resolve(includes, params, next.asString());
                    }
                    if (value == null && this.strict) {
                        throw new TokenizerException(next, "No such enum value %s for %s.", new Object[]{next.asString(), ed.getQualifiedName()}).setLine(tokenizer.getLine(next.getLineNo()));
                    }
                    return value;
                }
                case MESSAGE: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(includes, params, next.asString());
                    }
                    if (next.isSymbol('{')) {
                        return this.parseMessage(tokenizer, includes, params, ((PMessageDescriptor)descriptor).builder());
                    }
                    break;
                }
                case MAP: {
                    if (next.isReferenceIdentifier()) {
                        Map resolved;
                        try {
                            resolved = (Map)this.resolve(includes, params, next.asString());
                        }
                        catch (ClassCastException e) {
                            throw new TokenizerException(next, "Reference %s is not a map field ", new Object[]{next.asString()}).setLine(tokenizer.getLine(next.getLineNo()));
                        }
                        return resolved;
                    }
                    if (next.isSymbol('{')) {
                        return this.parseMapValue(tokenizer, includes, params, (PMap)descriptor, new HashMap());
                    }
                    break;
                }
                case SET: {
                    if (next.isReferenceIdentifier()) {
                        return ConfigUtil.asCollection(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isSymbol('[')) {
                        PSet ct = (PSet)descriptor;
                        HashSet<Object> value = new HashSet<Object>();
                        next = tokenizer.expect("set value or end");
                        while (!next.isSymbol(']')) {
                            value.add(this.parseFieldValue(next, tokenizer, includes, params, ct.itemDescriptor()));
                            if (tokenizer.expectSymbol("set separator or end", new char[]{',', ']'}) == ']') break;
                            next = tokenizer.expect("set value or end");
                        }
                        return ct.builder().addAll(value).build();
                    }
                    break;
                }
                case LIST: {
                    if (next.isReferenceIdentifier()) {
                        return ConfigUtil.asCollection(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isSymbol('[')) {
                        PList ct = (PList)descriptor;
                        PList.Builder builder = ct.builder();
                        next = tokenizer.expect("list value or end");
                        while (!next.isSymbol(']')) {
                            builder.add(this.parseFieldValue(next, tokenizer, includes, params, ct.itemDescriptor()));
                            if (tokenizer.expectSymbol("list separator or end", new char[]{',', ']'}) == ']') break;
                            next = tokenizer.expect("list value or end");
                        }
                        return builder.build();
                    }
                    break;
                }
                default: {
                    throw new TokenizerException(next, descriptor.getType() + " not supported!", new Object[0]).setLine(tokenizer.getLine(next.getLineNo()));
                }
            }
        }
        catch (KeyNotFoundException e) {
            throw new TokenizerException(next, e.getMessage(), new Object[0]).setLine(tokenizer.getLine(next.getLineNo()));
        }
        throw new TokenizerException(next, "Unhandled value \"%s\" for type %s", new Object[]{next.asString(), descriptor.getType()}).setLine(tokenizer.getLine(next.getLineNo()));
    }

    private Token nextNotLineSep(Tokenizer tokenizer, String message) throws IOException {
        if (tokenizer.peek().isSymbol(',') || tokenizer.peek().isSymbol(';')) {
            tokenizer.expect(message);
        }
        return tokenizer.expect(message);
    }

    private Map<String, Object> mkParams(Map<String, Object> declared) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, Object> entry : declared.entrySet()) {
            Object orig = entry.getValue();
            String key = entry.getKey();
            if (this.inputParams.containsKey(key)) {
                if (orig instanceof CharSequence) {
                    builder.put((Object)key, (Object)this.inputParams.get(key));
                    continue;
                }
                if (orig instanceof Double) {
                    builder.put((Object)key, (Object)ConfigUtil.asDouble((Object)this.inputParams.get(key)));
                    continue;
                }
                if (orig instanceof Long) {
                    builder.put((Object)key, (Object)ConfigUtil.asLong((Object)this.inputParams.get(key)));
                    continue;
                }
                if (orig instanceof Integer) {
                    builder.put((Object)key, (Object)ConfigUtil.asInteger((Object)this.inputParams.get(key)));
                    continue;
                }
                if (!(orig instanceof Boolean)) continue;
                builder.put((Object)key, (Object)ConfigUtil.asBoolean((Object)this.inputParams.get(key)));
                continue;
            }
            builder.put((Object)key, orig);
        }
        return builder.build();
    }

    private <V> V resolve(Map<String, PMessage> includes, Map<String, Object> params, String key) {
        if (key.contains(IDENTIFIER_SEP)) {
            int idx = key.indexOf(IDENTIFIER_SEP);
            String name = key.substring(0, idx);
            String sub = key.substring(idx + 1);
            if (PARAMS.equals(name)) {
                if (!params.containsKey(sub)) {
                    throw new KeyNotFoundException("Name " + sub + " not in params (\"" + key + "\")", new Object[0]);
                }
                return (V)params.get(sub);
            }
            if (includes.containsKey(name)) {
                PMessage include = includes.get(name);
                if (include == null) {
                    if (this.strict) {
                        throw new KeyNotFoundException("Included file with alias %s not parsed", new Object[]{name});
                    }
                    return null;
                }
                return (V)ProvidenceConfigUtil.getInMessage(include, sub, null);
            }
            throw new KeyNotFoundException("Reference name " + key + " not declared", new Object[0]);
        }
        if (includes.containsKey(key)) {
            return (V)includes.get(key);
        }
        throw new KeyNotFoundException("Reference name " + key + " not declared", new Object[0]);
    }

    private static enum Stage {
        PARAMS,
        INCLUDES,
        MESSAGE;

    }
}

