/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.io.File;
import java.util.Objects;
import net.morimekta.config.util.ConfigUtil;
import net.morimekta.providence.PEnumValue;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;

public class ProvidenceConfigParam {
    public final String name;
    public final Object value;
    public final File file;

    ProvidenceConfigParam(String name, Object value, File file) {
        this.name = name;
        this.value = value;
        this.file = file;
    }

    public int hashCode() {
        return Objects.hash(ProvidenceConfigParam.class, this.name, this.value, this.file);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        ProvidenceConfigParam p = (ProvidenceConfigParam)o;
        return Objects.equals(this.name, p.name) && Objects.equals(this.value, p.value) && Objects.equals(this.file, p.file);
    }

    public String toString() {
        if (this.value == null) {
            return String.format("%s = null (%s)", this.name, this.file.getName());
        }
        if (this.value instanceof Binary) {
            return String.format("%s = b64(%s) (%s)", this.name, ((Binary)this.value).toBase64(), this.file.getName());
        }
        if (this.value instanceof PEnumValue) {
            return String.format("%s = %s.%s (%s)", this.name, ((PEnumValue)this.value).descriptor().getQualifiedName(), ConfigUtil.asString((Object)this.value), this.file.getName());
        }
        if (this.value instanceof CharSequence) {
            return String.format("%s = \"%s\" (%s)", this.name, Strings.escape((CharSequence)((CharSequence)this.value)), this.file.getName());
        }
        return String.format("%s = %s (%s)", this.name, ConfigUtil.asString((Object)this.value), this.file.getName());
    }
}

