/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.morimekta.config.ConfigException;
import net.morimekta.config.KeyNotFoundException;
import net.morimekta.config.util.ConfigUtil;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.config.ProvidenceConfigUtil;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.util.TypeRegistry;
import net.morimekta.providence.util.pretty.Token;
import net.morimekta.providence.util.pretty.Tokenizer;
import net.morimekta.providence.util.pretty.TokenizerException;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;

public class ProvidenceConfig {
    private static final String IDENTIFIER_SEP = ".";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String PARAMS = "params";
    private static final String UNDEFINED = "undefined";
    private static final String INCLUDE = "include";
    private static final String AS = "as";
    private final TypeRegistry registry;
    private final Map<String, String> inputParams;
    private final Map<String, PMessage> loaded;
    private final List<File> sourceRoots;

    public ProvidenceConfig(TypeRegistry registry, Map<String, String> inputParams) {
        this(registry, inputParams, (List<File>)ImmutableList.of());
    }

    public ProvidenceConfig(TypeRegistry registry, Map<String, String> inputParams, List<File> sourceRoots) {
        this.registry = registry;
        this.inputParams = ImmutableMap.copyOf(inputParams);
        this.loaded = new HashMap<String, PMessage>();
        this.sourceRoots = ImmutableList.copyOf(sourceRoots);
    }

    public <M extends PMessage<M, F>, F extends PField> M load(File file) throws IOException, SerializerException {
        try {
            return this.loadConfigRecursively(this.resolveFile(null, file.toString()), new String[0]);
        }
        catch (FileNotFoundException e) {
            throw new TokenizerException(e.getMessage(), new Object[0]).setFile(file.toString());
        }
    }

    public List<Param> params(File file) throws IOException, SerializerException {
        return this.loadParamsRecursively(this.resolveFile(null, file.toString()), new String[0]);
    }

    public File resolveFile(File ref, String path) throws IOException {
        File tmp;
        if (ref == null) {
            tmp = new File(path);
            if (tmp.exists()) {
                if (tmp.isFile()) {
                    return tmp;
                }
                throw new FileNotFoundException(path + " is a directory, expected file");
            }
        } else {
            if (path.startsWith("/")) {
                throw new FileNotFoundException("Absolute path includes not allowed: " + path);
            }
            if (!ref.isDirectory()) {
                ref = ref.getParentFile();
            }
            if ((tmp = new File(ref, path).getAbsoluteFile().getCanonicalFile()).exists()) {
                if (tmp.isFile()) {
                    return tmp;
                }
                throw new FileNotFoundException(path + " is a directory, expected file");
            }
        }
        if (!path.startsWith(IDENTIFIER_SEP)) {
            if (path.contains("/../")) {
                throw new ConfigException("Parent directory part not allowed: " + path, new Object[0]);
            }
            for (File root : this.sourceRoots) {
                File tmp2 = new File(root, path).getAbsoluteFile().getCanonicalFile();
                if (!tmp2.exists()) continue;
                if (tmp2.isFile()) {
                    return tmp2;
                }
                throw new FileNotFoundException(path + " is a directory, expected file");
            }
        }
        if (ref == null) {
            throw new FileNotFoundException("File " + path + " not found");
        }
        throw new FileNotFoundException("Included file " + path + " not found");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Param> loadParamsRecursively(File file, String ... stack) throws SerializerException, IOException {
        try {
            Tokenizer tokenizer;
            File canonicalFile = file.getCanonicalFile().getAbsoluteFile();
            String filePath = canonicalFile.toString();
            LinkedList<String> stackList = new LinkedList<String>();
            Collections.addAll(stackList, stack);
            if (stackList.contains(filePath)) {
                stackList.add(filePath);
                throw new SerializerException("Circular includes detected: " + String.join((CharSequence)" -> ", stackList.stream().map(p -> new File((String)p).getName()).collect(Collectors.toList())), new Object[0]);
            }
            stackList.add(filePath);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(canonicalFile));){
                tokenizer = new Tokenizer((InputStream)in, false);
            }
            LinkedList<Param> result = new LinkedList<Param>();
            Stage stage = Stage.PARAMS;
            Token token = tokenizer.peek();
            while (token != null) {
                tokenizer.next();
                if (token.isQualifiedIdentifier()) {
                    return result;
                }
                if (!token.isIdentifier()) throw new TokenizerException(token, "Unexpected token " + token.asString() + "expected include, params or message type", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                if (PARAMS.equals(token.asString())) {
                    if (stage != Stage.PARAMS) {
                        throw new TokenizerException(token, "Params already defined.", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    stage = Stage.INCLUDES;
                    this.parseParams(tokenizer).entrySet().forEach(e -> result.add(new Param((String)e.getKey(), e.getValue(), canonicalFile)));
                } else {
                    File includedFile;
                    if (!INCLUDE.equals(token.asString())) throw new TokenizerException(token, "Unexpected token " + token.asString() + "expected include, params or message type", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    token = tokenizer.expect("file to be included");
                    try {
                        includedFile = this.resolveFile(file, token.decodeLiteral());
                        result.addAll(this.loadParamsRecursively(includedFile, stackList.toArray(new String[stackList.size()])));
                    }
                    catch (FileNotFoundException e2) {
                        throw new TokenizerException(token, "Included file " + token.asString() + " not found", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    if (!AS.equals(tokenizer.expectIdentifier("the token 'as'").asString())) {
                        throw new TokenizerException(token, "Missing alias for included file " + includedFile, new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                    tokenizer.expectIdentifier("Include alias").asString();
                }
                token = tokenizer.peek();
            }
            throw new ConfigException("No message in config: " + filePath, new Object[0]);
        }
        catch (TokenizerException e3) {
            throw new TokenizerException(e3, file);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <M extends PMessage<M, F>, F extends PField> M loadConfigRecursively(File file, String ... stack) throws IOException, SerializerException {
        M result = null;
        try {
            Tokenizer tokenizer;
            file = file.getCanonicalFile().getAbsoluteFile();
            String filePath = file.toString();
            LinkedList<String> stackList = new LinkedList<String>();
            Collections.addAll(stackList, stack);
            if (stackList.contains(filePath)) {
                stackList.add(filePath);
                throw new SerializerException("Circular includes detected: " + String.join((CharSequence)" -> ", stackList.stream().map(p -> new File((String)p).getName()).collect(Collectors.toList())), new Object[0]);
            }
            if (this.loaded.containsKey(filePath)) {
                return (M)this.loaded.get(filePath);
            }
            stackList.add(filePath);
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
                tokenizer = new Tokenizer((InputStream)bufferedInputStream, false);
            }
            HashMap hashMap = new HashMap();
            HashMap<String, PMessage> includes = new HashMap<String, PMessage>();
            Stage stage = Stage.PARAMS;
            Token token = tokenizer.peek();
            while (token != null) {
                tokenizer.next();
                if (stage == Stage.MESSAGE) {
                    throw new TokenizerException(token, "Unexpected token " + token.asString() + ", expected end of file.", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
                if (token.isQualifiedIdentifier()) {
                    void var7_9;
                    stage = Stage.MESSAGE;
                    PStructDescriptor descriptor = (PStructDescriptor)this.registry.getDeclaredType(token.asString());
                    result = this.parseConfigMessage(tokenizer, includes, this.mkParams((Map<String, Object>)var7_9), descriptor.builder());
                } else {
                    if (!token.isIdentifier()) throw new TokenizerException(token, "Unexpected token " + token.asString() + "expected include, params or message type", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    if (PARAMS.equals(token.asString())) {
                        if (stage != Stage.PARAMS) {
                            throw new TokenizerException(token, "Params already defined, or passed; must be at head of file", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                        }
                        stage = Stage.INCLUDES;
                        Map<String, Object> map = this.parseParams(tokenizer);
                    } else {
                        M included;
                        File includedFile;
                        if (!INCLUDE.equals(token.asString())) throw new TokenizerException(token, "Unexpected token " + token.asString() + "expected include, params or message type", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                        stage = Stage.INCLUDES;
                        token = tokenizer.expectStringLiteral("file to be included");
                        try {
                            includedFile = this.resolveFile(file, token.decodeLiteral());
                            included = this.loadConfigRecursively(includedFile, stackList.toArray(new String[stackList.size()]));
                        }
                        catch (FileNotFoundException e) {
                            throw new TokenizerException(token, "Included file " + token.asString() + " not found", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                        }
                        if (!AS.equals(tokenizer.expectIdentifier("the token 'as'").asString())) {
                            throw new TokenizerException(token, "Missing alias for included file " + includedFile, new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                        }
                        String alias = tokenizer.expectIdentifier("Include alias").asString();
                        if (includes.containsKey(alias)) {
                            throw new TokenizerException(token, "Alias \"" + alias + "\" is already used", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                        }
                        if (PARAMS.equals(alias) || INCLUDE.equals(alias) || AS.equals(alias)) {
                            throw new TokenizerException(token, "Alias \"" + alias + "\" is reserved word.", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                        }
                        includes.put(alias, (PMessage)included);
                    }
                }
                token = tokenizer.peek();
            }
        }
        catch (TokenizerException e) {
            throw new TokenizerException(e, file);
        }
        if (result != null) return result;
        throw new ConfigException("No message in config: " + file.getName(), new Object[0]);
    }

    private Map<String, Object> parseParams(Tokenizer tokenizer) throws IOException, SerializerException {
        HashMap<String, Object> out = new HashMap<String, Object>();
        tokenizer.expectSymbol("params start", new char[]{'{'});
        Token token = tokenizer.expect("param or end");
        while (!token.isSymbol('}')) {
            if (!token.isIdentifier()) {
                throw new TokenizerException(token, "Param name " + token.asString() + " not valid", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            String name = token.asString();
            tokenizer.expectSymbol("param value sep", new char[]{'='});
            token = tokenizer.expect("param value");
            if (token.isReal()) {
                out.put(name, Double.parseDouble(token.asString()));
            } else if (token.isInteger()) {
                out.put(name, Long.parseLong(token.asString()));
            } else if (token.isStringLiteral()) {
                out.put(name, token.decodeLiteral());
            } else if (TRUE.equalsIgnoreCase(token.asString())) {
                out.put(name, true);
            } else if (FALSE.equalsIgnoreCase(token.asString())) {
                out.put(name, false);
            } else if ("b64".equals(token.asString())) {
                tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                out.put(name, Binary.fromBase64((String)tokenizer.readUntil(')', false, false)));
            } else if ("hex".equals(token.asString())) {
                tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                out.put(name, Binary.fromHexString((String)tokenizer.readUntil(')', false, false)));
            } else if (token.isDoubleQualifiedIdentifier()) {
                String id = token.asString();
                int l = id.lastIndexOf(46);
                try {
                    PEnumDescriptor ed = (PEnumDescriptor)this.registry.getDeclaredType(id.substring(0, l));
                    out.put(name, ed.getValueByName(id.substring(l + 1)));
                }
                catch (ClassCastException e) {
                    throw new TokenizerException(token, "Identifier " + id + " does not reference an enum, from " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
            } else {
                throw new TokenizerException(token, "Invalid param value " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            token = tokenizer.expect("next param or end");
        }
        return out;
    }

    private <M extends PMessage<M, F>, F extends PField> M parseConfigMessage(Tokenizer tokenizer, Map<String, PMessage> includes, Map<String, Object> params, PMessageBuilder<M, F> builder) throws IOException, SerializerException {
        PStructDescriptor descriptor = builder.descriptor();
        if (tokenizer.expectSymbol("extension marker", new char[]{':', '{'}) == ':') {
            Token token = tokenizer.expect("extension object");
            if (token.isReferenceIdentifier()) {
                builder = descriptor.builder();
                try {
                    builder.merge((PMessage)this.resolve(includes, params, token.asString()));
                }
                catch (KeyNotFoundException e) {
                    throw new TokenizerException(token, e.getMessage(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                }
                tokenizer.expectSymbol("object begin", new char[]{'{'});
            } else {
                throw new TokenizerException(token, "Unexpected token " + token.asString() + ", expected message begin", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
        }
        return this.parseMessage(tokenizer, includes, params, builder);
    }

    private <M extends PMessage<M, F>, F extends PField> M parseMessage(Tokenizer tokenizer, Map<String, PMessage> includes, Map<String, Object> params, PMessageBuilder<M, F> builder) throws IOException, SerializerException {
        PStructDescriptor descriptor = builder.descriptor();
        Token token = tokenizer.expect("object end or field");
        while (!token.isSymbol('}')) {
            if (!token.isIdentifier()) {
                throw new TokenizerException(token, "Invalid field name: " + token.asString(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            PField field = descriptor.getField(token.asString());
            if (field == null) {
                throw new TokenizerException("No such field " + token.asString() + " in " + descriptor.getQualifiedName(null), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
            }
            if (field.getType() == PType.MESSAGE) {
                PMessageBuilder bld;
                char symbol = tokenizer.expectSymbol("Message assigner or start", new char[]{'=', '{'});
                if (symbol == '=') {
                    token = tokenizer.expect("reference or message start");
                    if (UNDEFINED.equals(token.asString())) {
                        builder.clear(field.getKey());
                        token = tokenizer.expect("message end or field");
                        continue;
                    }
                    bld = ((PStructDescriptor)field.getDescriptor()).builder();
                    if (token.isReferenceIdentifier()) {
                        try {
                            bld.merge((PMessage)this.resolve(includes, params, token.asString()));
                        }
                        catch (KeyNotFoundException e) {
                            throw new TokenizerException(token, e.getMessage(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                        }
                        token = tokenizer.expect("after message reference");
                        if (!token.isSymbol('{')) {
                            continue;
                        }
                    } else if (!token.isSymbol('{')) {
                        throw new TokenizerException(token, "Unexpected token " + token.asString() + ", expected message start.", new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                    }
                } else {
                    bld = builder.mutator(field.getKey());
                }
                builder.set(field.getKey(), this.parseMessage(tokenizer, includes, params, bld));
            } else if (field.getType() == PType.MAP) {
                token = tokenizer.expect("field sep or value start");
                HashMap baseValue = new HashMap();
                if (token.isSymbol('=')) {
                    token = tokenizer.expect("field id or start");
                    if (UNDEFINED.equals(token.asString())) {
                        builder.clear(field.getKey());
                        token = tokenizer.expect("message end or field");
                        continue;
                    }
                    if (token.isReferenceIdentifier()) {
                        try {
                            baseValue.putAll((Map)this.resolve(includes, params, token.asString()));
                        }
                        catch (KeyNotFoundException e) {
                            throw new TokenizerException(token, e.getMessage(), new Object[0]).setLine(tokenizer.getLine(token.getLineNo()));
                        }
                        catch (ClassCastException e) {
                            throw new TokenizerException(token, "Reference %s not pointing to a map.", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                        }
                        token = tokenizer.expect("map start or next field");
                        if (!token.isSymbol('{')) {
                            continue;
                        }
                    }
                } else {
                    baseValue.putAll((Map)((PMessage)builder.build()).get(field.getKey()));
                }
                if (!token.isSymbol('{')) {
                    throw new TokenizerException(token, "Expected map start, but got '%s'", new Object[]{token.asString()}).setLine(tokenizer.getLine(token.getLineNo()));
                }
                builder.set(field.getKey(), (Object)this.parseMapValue(tokenizer, includes, params, (PMap)field.getDescriptor(), baseValue));
            } else {
                tokenizer.expectSymbol("field value sep", new char[]{'='});
                token = tokenizer.expect("field value");
                if (UNDEFINED.equals(token.asString())) {
                    builder.clear(field.getKey());
                } else {
                    builder.set(field.getKey(), this.parseFieldValue(token, tokenizer, includes, params, field.getDescriptor()));
                }
            }
            if (!(token = tokenizer.expect("message end, field sep or field name")).isSymbol(',') && !token.isSymbol(';')) continue;
            token = tokenizer.expect("message end or field name");
        }
        return (M)((PMessage)builder.build());
    }

    private Map parseMapValue(Tokenizer tokenizer, Map<String, PMessage> includes, Map<String, Object> params, PMap descriptor, Map builder) throws IOException, SerializerException {
        Token next = tokenizer.expect("map key or end");
        while (!next.isSymbol('}')) {
            Object key = this.parseFieldValue(next, tokenizer, includes, params, descriptor.keyDescriptor());
            tokenizer.expectSymbol("map key value sep", new char[]{':'});
            next = tokenizer.expect("map value");
            if (UNDEFINED.equals(next.asString())) {
                builder.remove(key);
            } else {
                Object value = this.parseFieldValue(next, tokenizer, includes, params, descriptor.itemDescriptor());
                builder.put(key, value);
            }
            if (!(next = tokenizer.expect("map key, end or sep")).isSymbol(',')) continue;
            next = tokenizer.expect("map key or end");
        }
        return descriptor.builder().putAll(builder).build();
    }

    private Object parseFieldValue(Token next, Tokenizer tokenizer, Map<String, PMessage> includes, Map<String, Object> params, PDescriptor descriptor) throws IOException, SerializerException {
        try {
            switch (descriptor.getType()) {
                case BOOL: {
                    if (TRUE.equals(next.asString())) {
                        return true;
                    }
                    if (FALSE.equals(next.asString())) {
                        return false;
                    }
                    if (next.isReferenceIdentifier()) {
                        return ConfigUtil.asBoolean(this.resolve(includes, params, next.asString()));
                    }
                    break;
                }
                case BYTE: {
                    if (next.isReferenceIdentifier()) {
                        return (byte)ConfigUtil.asInteger(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isInteger()) {
                        return (byte)next.parseInteger();
                    }
                    break;
                }
                case I16: {
                    if (next.isReferenceIdentifier()) {
                        return (short)ConfigUtil.asInteger(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isInteger()) {
                        return (short)next.parseInteger();
                    }
                    break;
                }
                case I32: {
                    if (next.isReferenceIdentifier()) {
                        return ConfigUtil.asInteger(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isInteger()) {
                        return (int)next.parseInteger();
                    }
                    break;
                }
                case I64: {
                    if (next.isReferenceIdentifier()) {
                        return ConfigUtil.asLong(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isInteger()) {
                        return next.parseInteger();
                    }
                    break;
                }
                case DOUBLE: {
                    if (next.isReferenceIdentifier()) {
                        return ConfigUtil.asDouble(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isInteger() || next.isReal()) {
                        return next.parseDouble();
                    }
                    break;
                }
                case STRING: {
                    if (next.isReferenceIdentifier()) {
                        return ConfigUtil.asString(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isStringLiteral()) {
                        return next.decodeLiteral();
                    }
                    break;
                }
                case BINARY: {
                    if ("b64".equals(next.asString())) {
                        tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                        return Binary.fromBase64((String)tokenizer.readUntil(')', false, false));
                    }
                    if ("hex".equals(next.asString())) {
                        tokenizer.expectSymbol("binary data enclosing start", new char[]{'('});
                        return Binary.fromHexString((String)tokenizer.readUntil(')', false, false));
                    }
                    if (next.isReferenceIdentifier()) {
                        Object o = this.resolve(includes, params, next.asString());
                        if (o instanceof Binary) {
                            return o;
                        }
                        if (o instanceof CharSequence) {
                            return Binary.fromBase64((String)((String)o));
                        }
                        throw new TokenizerException(next, "Reference %s (%s) is not a binary", new Object[]{next.asString(), o.getClass().getSimpleName()}).setLine(tokenizer.getLine(next.getLineNo()));
                    }
                    break;
                }
                case ENUM: {
                    PEnumDescriptor ed = (PEnumDescriptor)descriptor;
                    if (next.isInteger()) {
                        return ed.getValueById((int)next.parseInteger());
                    }
                    if (next.isIdentifier()) {
                        PEnumValue value = ed.getValueByName(next.asString());
                        if (value != null) {
                            return value;
                        }
                        return this.resolve(includes, params, next.asString());
                    }
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(includes, params, next.asString());
                    }
                    break;
                }
                case MESSAGE: {
                    if (next.isReferenceIdentifier()) {
                        return this.resolve(includes, params, next.asString());
                    }
                    if (next.isSymbol('{')) {
                        return this.parseMessage(tokenizer, includes, params, ((PStructDescriptor)descriptor).builder());
                    }
                    break;
                }
                case MAP: {
                    if (next.isReferenceIdentifier()) {
                        return ConfigUtil.asCollection(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isSymbol('{')) {
                        return this.parseMapValue(tokenizer, includes, params, (PMap)descriptor, new HashMap());
                    }
                    break;
                }
                case SET: {
                    if (next.isReferenceIdentifier()) {
                        return ConfigUtil.asCollection(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isSymbol('[')) {
                        PSet ct = (PSet)descriptor;
                        HashSet<Object> value = new HashSet<Object>();
                        next = tokenizer.expect("set value or end");
                        while (!next.isSymbol(']')) {
                            value.add(this.parseFieldValue(next, tokenizer, includes, params, ct.itemDescriptor()));
                            if (tokenizer.expectSymbol("set separator or end", new char[]{',', ']'}) == ']') break;
                            next = tokenizer.expect("set value or end");
                        }
                        return ct.builder().addAll(value).build();
                    }
                    break;
                }
                case LIST: {
                    if (next.isReferenceIdentifier()) {
                        return ConfigUtil.asCollection(this.resolve(includes, params, next.asString()));
                    }
                    if (next.isSymbol('[')) {
                        PList ct = (PList)descriptor;
                        PList.Builder builder = ct.builder();
                        next = tokenizer.expect("list value or end");
                        while (!next.isSymbol(']')) {
                            builder.add(this.parseFieldValue(next, tokenizer, includes, params, ct.itemDescriptor()));
                            if (tokenizer.expectSymbol("list separator or end", new char[]{',', ']'}) == ']') break;
                            next = tokenizer.expect("list value or end");
                        }
                        return builder.build();
                    }
                    break;
                }
                default: {
                    throw new TokenizerException(next, descriptor.getType() + " not supported!", new Object[0]).setLine(tokenizer.getLine(next.getLineNo()));
                }
            }
        }
        catch (KeyNotFoundException e) {
            throw new TokenizerException(next, e.getMessage(), new Object[0]).setLine(tokenizer.getLine(next.getLineNo()));
        }
        throw new TokenizerException(next, "Unhandled value \"%s\" for type %s", new Object[]{next.asString(), descriptor.getType()}).setLine(tokenizer.getLine(next.getLineNo()));
    }

    private Map<String, Object> mkParams(Map<String, Object> declared) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : declared.keySet()) {
            Object orig = declared.get(key);
            if (this.inputParams.containsKey(key)) {
                if (orig instanceof CharSequence) {
                    builder.put((Object)key, (Object)this.inputParams.get(key));
                    continue;
                }
                if (orig instanceof Double) {
                    builder.put((Object)key, (Object)ConfigUtil.asDouble((Object)this.inputParams.get(key)));
                    continue;
                }
                if (orig instanceof Long) {
                    builder.put((Object)key, (Object)ConfigUtil.asLong((Object)this.inputParams.get(key)));
                    continue;
                }
                if (orig instanceof Integer) {
                    builder.put((Object)key, (Object)ConfigUtil.asInteger((Object)this.inputParams.get(key)));
                    continue;
                }
                if (!(orig instanceof Boolean)) continue;
                builder.put((Object)key, (Object)ConfigUtil.asBoolean((Object)this.inputParams.get(key)));
                continue;
            }
            builder.put((Object)key, orig);
        }
        return builder.build();
    }

    private <V> V resolve(Map<String, PMessage> includes, Map<String, Object> params, String key) {
        if (key.contains(IDENTIFIER_SEP)) {
            int idx = key.indexOf(IDENTIFIER_SEP);
            String name = key.substring(0, idx);
            String sub = key.substring(idx + 1);
            if (PARAMS.equals(name)) {
                if (!params.containsKey(sub)) {
                    throw new KeyNotFoundException("Name " + sub + " not in params (\"" + key + "\")", new Object[0]);
                }
                return (V)params.get(sub);
            }
            if (includes.containsKey(name)) {
                return (V)ProvidenceConfigUtil.getInMessage(includes.get(name), sub);
            }
            throw new KeyNotFoundException("Reference name " + key + " not declared.", new Object[0]);
        }
        if (includes.containsKey(key)) {
            return (V)includes.get(key);
        }
        throw new KeyNotFoundException("Reference name " + key + " not declared.", new Object[0]);
    }

    public static class Param {
        public final String name;
        public final Object value;
        public final File file;

        public Param(String name, Object value, File file) {
            this.name = name;
            this.value = value;
            this.file = file;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value, this.file);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !this.getClass().equals(o.getClass())) {
                return false;
            }
            Param p = (Param)o;
            return Objects.equals(this.name, p.name) && Objects.equals(this.value, p.value) && Objects.equals(this.file, p.file);
        }

        public String toString() {
            if (this.value == null) {
                return String.format("%s = null (%s)", this.name, this.file.getName());
            }
            if (this.value instanceof Binary) {
                return String.format("%s = b64(%s) (%s)", this.name, ((Binary)this.value).toBase64(), this.file.getName());
            }
            if (this.value instanceof PEnumValue) {
                return String.format("%s = %s.%s (%s)", this.name, ((PEnumValue)this.value).descriptor().getQualifiedName(null), ConfigUtil.asString((Object)this.value), this.file.getName());
            }
            if (this.value instanceof CharSequence) {
                return String.format("%s = \"%s\" (%s)", this.name, Strings.escape((CharSequence)((CharSequence)this.value)), this.file.getName());
            }
            return String.format("%s = %s (%s)", this.name, ConfigUtil.asString((Object)this.value), this.file.getName());
        }
    }

    private static enum Stage {
        PARAMS,
        INCLUDES,
        MESSAGE;

    }
}

