/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.util.Set;
import net.morimekta.config.IncompatibleValueException;
import net.morimekta.config.KeyNotFoundException;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PStructDescriptor;

public class ProvidenceConfigUtil {
    public static Object getInMessage(PMessage message, String key) {
        PStructDescriptor descriptor = message.descriptor();
        if (key.contains(".")) {
            int idx = key.indexOf(".");
            String name = key.substring(0, idx);
            String sub = key.substring(idx + 1);
            PField field = descriptor.getField(name);
            if (field == null) {
                throw new KeyNotFoundException("Message " + message.descriptor().getQualifiedName(null) + " has no field named " + name, new Object[0]);
            }
            if (field.getDescriptor().getType() != PType.MESSAGE) {
                throw new IncompatibleValueException("Field " + name + " is not of message type in " + descriptor.getQualifiedName(null), new Object[0]);
            }
            if (!message.has(field.getKey())) {
                throw new KeyNotFoundException("Field " + name + " not a set.", new Object[0]);
            }
            return ProvidenceConfigUtil.getInMessage((PMessage)message.get(field.getKey()), sub);
        }
        PField field = message.descriptor().getField(key);
        if (field == null) {
            throw new KeyNotFoundException("Message " + message.descriptor().getQualifiedName(null) + " has no field named " + key, new Object[0]);
        }
        return message.get(field.getKey());
    }

    protected static void buildKeySet(String prefix, PMessage message, Set<String> valueKeySet) {
        for (PField field : message.descriptor().getFields()) {
            if (!message.has(field.getKey())) continue;
            String key = ProvidenceConfigUtil.makeKey(prefix, field);
            if (field.getType() == PType.MESSAGE) {
                ProvidenceConfigUtil.buildKeySet(key, (PMessage)message.get(field.getKey()), valueKeySet);
                continue;
            }
            valueKeySet.add(key);
        }
    }

    private static String makeKey(String prefix, PField field) {
        if (prefix == null) {
            return field.getName();
        }
        return prefix + "." + field.getName();
    }
}

