/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.util.HashSet;
import java.util.Set;
import net.morimekta.config.ConfigException;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PField;

public class ProvidenceConfigUtil {
    public static <Message extends PMessage<Message, Field>, Field extends PField> Message asMessage(Object value) {
        if (!(value instanceof PMessage)) {
            throw new ConfigException("Cannot convert " + value.getClass().getSimpleName() + " to providence message.", new Object[0]);
        }
        return (Message)((PMessage)value);
    }

    public static Set<String> buildKeySet(PMessage<?, ?> message) {
        HashSet<String> keys = new HashSet<String>();
        ProvidenceConfigUtil.buildKeySet(null, message, keys);
        return keys;
    }

    public static Object getFromMessage(PMessage message, String key) {
        if (key.contains(".")) {
            String[] parts = key.split("[.]", 2);
            PField field = message.descriptor().getField(parts[0]);
            if (field == null) {
                throw new ConfigException("Message " + message.descriptor().getQualifiedName(null) + " has no field named " + parts[0], new Object[0]);
            }
            Object value = message.get(field.getKey());
            if (value == null) {
                return null;
            }
            if (value instanceof PMessage) {
                return ProvidenceConfigUtil.getFromMessage((PMessage)value, parts[1]);
            }
            throw new ConfigException("Unable to fetch sub-keys from " + key + ", " + value.getClass().getSimpleName() + " is not a message", new Object[0]);
        }
        PField field = message.descriptor().getField(key);
        if (field == null) {
            throw new ConfigException("Message " + message.descriptor().getQualifiedName(null) + " has no field named " + key, new Object[0]);
        }
        return message.get(field.getKey());
    }

    private static void buildKeySet(String prefix, PMessage message, Set<String> into) {
        for (PField field : message.descriptor().getFields()) {
            if (!message.has(field.getKey())) continue;
            String key = ProvidenceConfigUtil.makeKey(prefix, field);
            into.add(key);
            if (field.getType() != PType.MESSAGE) continue;
            ProvidenceConfigUtil.buildKeySet(key, (PMessage)message.get(field.getKey()), into);
        }
    }

    private static String makeKey(String prefix, PField field) {
        if (prefix == null) {
            return field.getName();
        }
        return prefix + "." + field.getName();
    }
}

