/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.config.ProvidenceConfig;
import net.morimekta.providence.config.ProvidenceConfigUtil;
import net.morimekta.providence.descriptor.PField;

public class MessageConfig<Message extends PMessage<Message, Field>, Field extends PField>
implements ProvidenceConfig {
    private final Message instance;
    private final Set<String> instanceKeySet;

    public MessageConfig(Message instance) {
        this.instance = instance;
        this.instanceKeySet = ImmutableSet.copyOf(ProvidenceConfigUtil.buildKeySet(instance));
    }

    public Message getMessage() {
        return this.instance;
    }

    public Object get(String key) {
        if (this.containsKey(key)) {
            return ProvidenceConfigUtil.getFromMessage(this.instance, key);
        }
        return null;
    }

    public boolean containsKey(String key) {
        return this.instanceKeySet.contains(key);
    }

    public Set<String> keySet() {
        return this.instanceKeySet;
    }
}

