/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.config;

import java.util.Set;
import net.morimekta.config.ConfigException;
import net.morimekta.config.util.ConfigUtil;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.config.ProvidenceConfigBuilder;
import net.morimekta.providence.config.ProvidenceConfigUtil;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PStructDescriptor;

public class MessageBuilderConfig<Message extends PMessage<Message, Field>, Field extends PField>
implements ProvidenceConfigBuilder<MessageBuilderConfig<Message, Field>> {
    private final PMessageBuilder<Message, Field> builder;

    public MessageBuilderConfig(PStructDescriptor<Message, Field> descriptor) {
        this.builder = descriptor.builder();
    }

    public Message getSnapshot() {
        return (Message)((PMessage)this.builder.build());
    }

    public PMessageBuilder<Message, Field> getBuilder() {
        return this.builder;
    }

    public Object get(String key) {
        return ProvidenceConfigUtil.getFromMessage(this.getSnapshot(), key);
    }

    public boolean containsKey(String key) {
        try {
            return ProvidenceConfigUtil.getFromMessage(this.getSnapshot(), key) != null;
        }
        catch (ConfigException e) {
            return false;
        }
    }

    public Set<String> keySet() {
        return ProvidenceConfigUtil.buildKeySet(this.getSnapshot());
    }

    public Object put(String key, Object value) {
        String[] parts = key.split("[.]");
        PMessageBuilder current = this.builder;
        for (int i = 0; i < parts.length - 1; ++i) {
            String name = parts[i];
            PField field = current.descriptor().getField(name);
            if (field == null) {
                throw new ConfigException("", new Object[0]);
            }
            if (field.getType() != PType.MESSAGE) {
                throw new ConfigException("", new Object[0]);
            }
            current = current.mutator(field.getKey());
        }
        String name = parts[parts.length - 1];
        PField field = current.descriptor().getField(name);
        if (field == null) {
            throw new ConfigException("", new Object[0]);
        }
        switch (field.getType()) {
            case BOOL: {
                current.set(field.getKey(), (Object)ConfigUtil.asBoolean((Object)value));
                break;
            }
            case BYTE: {
                current.set(field.getKey(), (Object)((byte)ConfigUtil.asInteger((Object)value)));
                break;
            }
            case I16: {
                current.set(field.getKey(), (Object)((short)ConfigUtil.asInteger((Object)value)));
                break;
            }
            case I32: {
                current.set(field.getKey(), (Object)ConfigUtil.asInteger((Object)value));
                break;
            }
            case I64: {
                current.set(field.getKey(), (Object)ConfigUtil.asLong((Object)value));
                break;
            }
            case DOUBLE: {
                current.set(field.getKey(), (Object)ConfigUtil.asDouble((Object)value));
                break;
            }
            case STRING: {
                current.set(field.getKey(), (Object)ConfigUtil.asString((Object)value));
                break;
            }
            case MESSAGE: {
                current.set(field.getKey(), ProvidenceConfigUtil.asMessage(value));
                break;
            }
            case LIST: 
            case SET: {
                current.set(field.getKey(), (Object)ConfigUtil.asCollection((Object)value));
                break;
            }
            default: {
                throw new ConfigException("Unable to set providence type " + field.getType() + " from " + value.getClass().getSimpleName(), new Object[0]);
            }
        }
        return null;
    }
}

