/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util.json;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Stack;
import net.morimekta.util.Binary;
import net.morimekta.util.json.JsonContext;
import net.morimekta.util.json.JsonException;

public class JsonWriter {
    public static final String kNull = "null";
    public static final String kTrue = "true";
    public static final String kFalse = "false";
    private final PrintWriter writer;
    private final Stack<JsonContext> stack;
    protected JsonContext context;

    public JsonWriter(OutputStream out) {
        this(new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
    }

    public JsonWriter(PrintWriter writer) {
        this.writer = writer;
        this.stack = new Stack();
        this.context = new JsonContext(JsonContext.Mode.VALUE);
    }

    protected void reset() {
        this.writer.flush();
        this.stack.clear();
        this.context = new JsonContext(JsonContext.Mode.VALUE);
    }

    public void flush() {
        this.writer.flush();
    }

    public JsonWriter object() throws JsonException {
        this.startValue();
        this.stack.push(this.context);
        this.context = new JsonContext(JsonContext.Mode.MAP);
        this.writer.write(123);
        return this;
    }

    public JsonWriter array() throws JsonException {
        this.startValue();
        this.stack.push(this.context);
        this.context = new JsonContext(JsonContext.Mode.LIST);
        this.writer.write(91);
        return this;
    }

    public JsonWriter endObject() throws JsonException {
        if (!this.context.map()) {
            throw new JsonException("Unexpected end, not in object.");
        }
        if (this.context.value()) {
            throw new JsonException("Expected map value but got end.");
        }
        this.writer.write(125);
        this.context = this.stack.pop();
        return this;
    }

    public JsonWriter endArray() throws JsonException {
        if (!this.context.list()) {
            throw new JsonException("Unexpected end, not in list.");
        }
        this.writer.write(93);
        this.context = this.stack.pop();
        return this;
    }

    public JsonWriter key(boolean key) throws JsonException {
        this.startKey();
        this.writer.write(key ? "\"true\":" : "\"false\":");
        return this;
    }

    public JsonWriter key(byte key) throws JsonException {
        this.startKey();
        this.writer.write(34);
        this.writer.print(key);
        this.writer.write(34);
        this.writer.write(58);
        return this;
    }

    public JsonWriter key(short key) throws JsonException {
        this.startKey();
        this.writer.write(34);
        this.writer.print(key);
        this.writer.write(34);
        this.writer.write(58);
        return this;
    }

    public JsonWriter key(int key) throws JsonException {
        this.startKey();
        this.writer.write(34);
        this.writer.print(key);
        this.writer.write(34);
        this.writer.write(58);
        return this;
    }

    public JsonWriter key(long key) throws JsonException {
        this.startKey();
        this.writer.write(34);
        this.writer.print(key);
        this.writer.write(34);
        this.writer.write(58);
        return this;
    }

    public JsonWriter key(double key) throws JsonException {
        this.startKey();
        this.writer.write(34);
        long i = (long)key;
        if (key == (double)i) {
            this.writer.print(i);
        } else {
            this.writer.print(key);
        }
        this.writer.write(34);
        this.writer.write(58);
        return this;
    }

    public JsonWriter key(CharSequence key) throws JsonException {
        this.startKey();
        if (key == null) {
            throw new JsonException("Expected map key, but got null.");
        }
        this.writeQuoted(key);
        this.writer.write(58);
        return this;
    }

    public JsonWriter key(Binary key) throws JsonException {
        this.startKey();
        if (key == null) {
            throw new JsonException("Expected map key, but got null.");
        }
        this.writer.write(34);
        this.writer.write(key.toBase64());
        this.writer.write(34);
        this.writer.write(58);
        return this;
    }

    public JsonWriter keyLiteral(CharSequence key) throws JsonException {
        this.startKey();
        if (key == null) {
            throw new JsonException("Expected map key, but got null.");
        }
        this.writer.write(key.toString());
        this.writer.write(58);
        return this;
    }

    public JsonWriter value(boolean value) throws JsonException {
        this.startValue();
        this.writer.write(value ? kTrue : kFalse);
        return this;
    }

    public JsonWriter value(byte value) throws JsonException {
        this.startValue();
        this.writer.print(value);
        return this;
    }

    public JsonWriter value(short value) throws JsonException {
        this.startValue();
        this.writer.print(value);
        return this;
    }

    public JsonWriter value(int value) throws JsonException {
        this.startValue();
        this.writer.print(value);
        return this;
    }

    public JsonWriter value(long number) throws JsonException {
        this.startValue();
        this.writer.print(number);
        return this;
    }

    public JsonWriter value(double number) throws JsonException {
        this.startValue();
        long i = (long)number;
        if (number == (double)i) {
            this.writer.print(i);
        } else {
            this.writer.print(number);
        }
        return this;
    }

    public JsonWriter value(CharSequence value) throws JsonException {
        this.startValue();
        if (value == null) {
            this.writer.write(kNull);
        } else {
            this.writeQuoted(value);
        }
        return this;
    }

    public JsonWriter value(Binary value) throws JsonException {
        this.startValue();
        if (value == null) {
            this.writer.write(kNull);
        } else {
            this.writer.write(34);
            this.writer.write(value.toBase64());
            this.writer.write(34);
        }
        return this;
    }

    public JsonWriter valueLiteral(CharSequence value) throws JsonException {
        this.startValue();
        if (value == null) {
            this.writer.write(kNull);
        } else {
            this.writer.write(value.toString());
        }
        return this;
    }

    protected void startKey() throws JsonException {
        if (!this.context.map()) {
            throw new JsonException("Unexpected map key outside map.");
        }
        if (!this.context.key()) {
            throw new JsonException("Unexpected map key, expected value or end.");
        }
        if (this.context.num > 0) {
            this.writer.write(44);
        }
        ++this.context.num;
        this.context.expect = JsonContext.Expect.VALUE;
    }

    protected boolean startValue() throws JsonException {
        if (!this.context.value()) {
            if (this.context.expect == JsonContext.Expect.VALUE) {
                throw new JsonException("Value already written, and not in container.");
            }
            throw new JsonException("Expected map key, but got value.");
        }
        if (this.context.list()) {
            if (this.context.num > 0) {
                this.writer.write(44);
            }
            ++this.context.num;
            return true;
        }
        if (this.context.map()) {
            this.context.expect = JsonContext.Expect.KEY;
        } else {
            ++this.context.num;
        }
        return false;
    }

    private void writeQuoted(CharSequence string) {
        if (string != null && string.length() != 0) {
            int len = string.length();
            this.writer.write(34);
            block8: for (int i = 0; i < len; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\b': {
                        this.writer.write("\\b");
                        continue block8;
                    }
                    case '\t': {
                        this.writer.write("\\t");
                        continue block8;
                    }
                    case '\n': {
                        this.writer.write("\\n");
                        continue block8;
                    }
                    case '\f': {
                        this.writer.write("\\f");
                        continue block8;
                    }
                    case '\r': {
                        this.writer.write("\\r");
                        continue block8;
                    }
                    case '\"': 
                    case '\\': {
                        this.writer.write(92);
                        this.writer.write(c);
                        continue block8;
                    }
                    default: {
                        if (c < ' ' || '\u007f' <= c && c < '\u00a0' || '\u2000' <= c && c < '\u2100' || !Character.isDefined(c)) {
                            this.writer.format("\\u%04x", c);
                            continue block8;
                        }
                        this.writer.write(c);
                    }
                }
            }
            this.writer.write(34);
        } else {
            this.writer.write("\"\"");
        }
    }
}

