/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IOUtils;
import net.morimekta.util.io.Utf8StreamReader;
import net.morimekta.util.json.JsonException;
import net.morimekta.util.json.JsonToken;

public class JsonTokenizer {
    private static final int CONSOLIDATE_LINE_ON = 128;
    private final InputStream reader;
    private final ArrayList<String> lines;
    private final ByteBuffer lineBuffer;
    private final ByteArrayOutputStream stringBuffer;
    private int line;
    private int linePos;
    private int lastByte;
    private StringBuilder lineBuilder;
    private JsonToken unreadToken;

    public JsonTokenizer(InputStream in) {
        this.reader = in;
        this.line = 1;
        this.linePos = 0;
        this.lastByte = 0;
        this.lineBuffer = ByteBuffer.allocate(65536);
        this.stringBuffer = new ByteArrayOutputStream(4096);
        this.lines = new ArrayList(1024);
        this.lineBuilder = new StringBuilder();
        this.unreadToken = null;
    }

    public JsonToken expect(String message) throws JsonException, IOException {
        if (!this.hasNext()) {
            throw this.newParseException("Unexpected end of file while %s", message);
        }
        return this.next();
    }

    public JsonToken expectString(String message) throws IOException, JsonException {
        if (!this.hasNext()) {
            throw this.newParseException("Unexpected end of stream while %s", message);
        }
        if (this.unreadToken.isLiteral()) {
            return this.next();
        }
        throw this.newMismatchException("Expected string literal, but found %s while %s", this.unreadToken.type.toString().toLowerCase(), message);
    }

    public JsonToken expectNumber(String message) throws IOException, JsonException {
        if (!this.hasNext()) {
            throw this.newParseException("Unexpected end of stream while %s", message);
        }
        if (this.unreadToken.isInteger() || this.unreadToken.isDouble()) {
            return this.next();
        }
        throw this.newMismatchException("Expected number, but found %s while %s", this.unreadToken.type.toString().toLowerCase(), message);
    }

    public char expectSymbol(String message, char ... symbols) throws IOException, JsonException {
        if (symbols.length == 0) {
            throw new IllegalArgumentException("No symbols to match.");
        }
        if (!this.hasNext()) {
            throw this.newParseException("Unexpected end of stream while %s", message);
        }
        for (char symbol : symbols) {
            if (!this.unreadToken.isSymbol(symbol)) continue;
            this.unreadToken = null;
            return symbol;
        }
        throw this.newMismatchException("Expected one of \"%s\", but found \"%s\" while %s", Strings.joinP("", symbols), this.unreadToken.toString(), message);
    }

    public boolean hasNext() throws IOException, JsonException {
        if (this.unreadToken == null) {
            this.unreadToken = this.next();
        }
        return this.unreadToken != null;
    }

    public JsonToken peek(String message) throws IOException, JsonException {
        if (!this.hasNext()) {
            throw this.newParseException("Unexpected end of stream while %s", message);
        }
        return this.unreadToken;
    }

    public JsonToken next() throws IOException, JsonException {
        if (this.unreadToken != null) {
            JsonToken tmp = this.unreadToken;
            this.unreadToken = null;
            return tmp;
        }
        while (this.lastByte >= 0) {
            if (this.lastByte == 0) {
                if (this.lineBuffer.position() == this.lineBuffer.capacity() - 128) {
                    this.flushLineBuffer();
                }
                this.lastByte = this.reader.read();
                if (this.lastByte < 0) break;
                if (this.lastByte != 10 && this.lastByte != 13) {
                    this.lineBuffer.put((byte)this.lastByte);
                    ++this.linePos;
                }
            }
            if (this.lastByte == 10 || this.lastByte == 13) {
                this.flushLineBuffer();
                this.lines.add(this.lineBuilder.toString());
                this.linePos = 0;
                this.lineBuilder = new StringBuilder();
                ++this.line;
                if (this.lastByte == 13) {
                    this.lastByte = this.reader.read();
                    if (this.lastByte == 10) {
                        this.lastByte = 0;
                        continue;
                    }
                    if (this.lastByte == 13) continue;
                    this.lineBuffer.put((byte)this.lastByte);
                    ++this.linePos;
                    continue;
                }
                this.lastByte = 0;
                continue;
            }
            if (this.lastByte == 32 || this.lastByte == 9) {
                this.lastByte = 0;
                continue;
            }
            if (this.lastByte == 34) {
                return this.nextString();
            }
            if (this.lastByte == 45 || this.lastByte >= 48 && this.lastByte <= 57) {
                return this.nextNumber();
            }
            if (this.lastByte == 91 || this.lastByte == 93 || this.lastByte == 123 || this.lastByte == 125 || this.lastByte == 58 || this.lastByte == 44 || this.lastByte == 61) {
                return this.nextSymbol();
            }
            if (this.lastByte < 32 || this.lastByte >= 127) {
                throw this.newParseException("Illegal character in JSON structure: '\\u%04x'", this.lastByte);
            }
            return this.nextToken();
        }
        return null;
    }

    public String getLine(int line) throws IOException {
        if (line < 1) {
            throw new IllegalArgumentException("Invalid line number requested: " + line);
        }
        if (this.lines.size() >= line) {
            return this.lines.get(line - 1);
        }
        this.flushLineBuffer();
        this.lineBuilder.append(IOUtils.readString((Reader)new Utf8StreamReader(this.reader), '\n'));
        String ln = this.lineBuilder.toString();
        this.lines.add(ln);
        return ln;
    }

    private JsonToken nextSymbol() {
        this.lastByte = 0;
        return new JsonToken(JsonToken.Type.SYMBOL, this.lineBuffer.array(), this.lineBuffer.position() - 1, 1, this.line, this.linePos);
    }

    private JsonToken nextToken() throws IOException {
        int startPos = this.linePos;
        int startOffset = this.lineBuffer.position() - 1;
        int len = 0;
        while (this.lastByte == 95 || this.lastByte == 46 || this.lastByte >= 48 && this.lastByte <= 57 || this.lastByte >= 97 && this.lastByte <= 122 || this.lastByte >= 65 && this.lastByte <= 90) {
            ++len;
            this.lastByte = this.reader.read();
            if (this.lastByte < 0) break;
            this.lineBuffer.put((byte)this.lastByte);
            ++this.linePos;
        }
        return new JsonToken(JsonToken.Type.TOKEN, this.lineBuffer.array(), startOffset, len, this.line, startPos);
    }

    private JsonToken nextNumber() throws IOException, JsonException {
        int startPos = this.linePos++;
        int startOffset = this.lineBuffer.position() - 1;
        int len = 0;
        if (this.lastByte == 45) {
            ++len;
            this.lastByte = this.reader.read();
            if (this.lastByte < 0) {
                throw this.newParseException("Negative indicator without number.", new Object[0]);
            }
            this.lineBuffer.put((byte)this.lastByte);
            if (this.lastByte != 46 && (this.lastByte < 48 || this.lastByte > 57)) {
                throw this.newParseException("No decimal after negative indicator.", new Object[0]);
            }
        }
        while (this.lastByte >= 48 && this.lastByte <= 57) {
            ++len;
            this.lastByte = this.reader.read();
            if (this.lastByte < 0) break;
            this.lineBuffer.put((byte)this.lastByte);
            ++this.linePos;
        }
        if (this.lastByte == 46) {
            ++len;
            this.lastByte = this.reader.read();
            if (this.lastByte >= 0) {
                this.lineBuffer.put((byte)this.lastByte);
                ++this.linePos;
                while (this.lastByte >= 48 && this.lastByte <= 57) {
                    ++len;
                    this.lastByte = this.reader.read();
                    if (this.lastByte < 0) break;
                    this.lineBuffer.put((byte)this.lastByte);
                    ++this.linePos;
                }
            }
        }
        if (this.lastByte == 101 || this.lastByte == 69) {
            ++len;
            this.lastByte = this.reader.read();
            if (this.lastByte >= 0) {
                this.lineBuffer.put((byte)this.lastByte);
                ++this.linePos;
                if (this.lastByte == 45 || this.lastByte == 43) {
                    ++len;
                    this.lastByte = this.reader.read();
                    if (this.lastByte >= 0) {
                        this.lineBuffer.put((byte)this.lastByte);
                        ++this.linePos;
                    }
                }
                while (this.lastByte >= 48 && this.lastByte <= 57) {
                    ++len;
                    this.lastByte = this.reader.read();
                    if (this.lastByte < 0) break;
                    this.lineBuffer.put((byte)this.lastByte);
                    ++this.linePos;
                }
            }
        }
        if (this.lastByte < 0 || this.lastByte == 44 || this.lastByte == 125 || this.lastByte == 93 || this.lastByte == 32 || this.lastByte == 9 || this.lastByte == 10 || this.lastByte == 13) {
            return new JsonToken(JsonToken.Type.NUMBER, this.lineBuffer.array(), startOffset, len, this.line, startPos);
        }
        throw this.newParseException("Wrongly terminated JSON number: %c.", this.lastByte);
    }

    private JsonToken nextString() throws IOException, JsonException {
        this.stringBuffer.reset();
        this.stringBuffer.write(this.lastByte);
        int startPos = this.linePos;
        int startOffset = this.lineBuffer.position() - 1;
        boolean consolidated = false;
        boolean esc = false;
        while (true) {
            if (this.lineBuffer.position() >= this.lineBuffer.capacity() - 1) {
                this.stringBuffer.write(this.lineBuffer.array(), startOffset, this.lineBuffer.position() - startOffset);
                startOffset = 0;
                consolidated = true;
                this.flushLineBuffer();
            }
            this.lastByte = this.reader.read();
            if (this.lastByte < 0) {
                throw this.newParseException("Unexpected end of stream in string literal.", new Object[0]);
            }
            this.lineBuffer.put((byte)this.lastByte);
            ++this.linePos;
            if (esc) {
                esc = false;
                continue;
            }
            if (this.lastByte == 92) {
                esc = true;
                continue;
            }
            if (this.lastByte == 34) break;
        }
        this.lastByte = 0;
        if (consolidated) {
            this.stringBuffer.write(this.lineBuffer.array(), 0, this.lineBuffer.position());
            return new JsonToken(JsonToken.Type.LITERAL, this.stringBuffer.toByteArray(), 0, this.stringBuffer.size(), this.line, startPos);
        }
        return new JsonToken(JsonToken.Type.LITERAL, this.lineBuffer.array(), startOffset, this.lineBuffer.position() - startOffset, this.line, startPos);
    }

    private void flushLineBuffer() {
        this.lineBuilder.append(new String(this.lineBuffer.array(), 0, this.lineBuffer.position()));
        this.lineBuffer.clear();
    }

    private JsonException newMismatchException(String format, Object ... params) throws IOException {
        if (params.length > 0) {
            format = String.format(format, params);
        }
        return new JsonException(format, this, this.unreadToken);
    }

    private JsonException newParseException(String format, Object ... params) throws IOException, JsonException {
        if (params.length > 0) {
            format = String.format(format, params);
        }
        return new JsonException(format, this.getLine(this.line), this.line, this.linePos, 0);
    }
}

