/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class Utf8StreamReader
extends Reader {
    private final int[] buffer;
    private InputStream in;
    private char surrogate;

    public Utf8StreamReader(InputStream in) {
        this.in = in;
        this.buffer = new int[6];
        this.surrogate = '\u0000';
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.in == null) {
            throw new IOException("Reading from a closed stream.");
        }
        for (int i = 0; i < len; ++i) {
            if (this.surrogate != '\u0000') {
                cbuf[off + i] = this.surrogate;
                this.surrogate = '\u0000';
                continue;
            }
            int r = this.in.read();
            if (r < 0) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            if (r < 128) {
                cbuf[off + i] = (char)r;
                continue;
            }
            if ((r & 0xC0) == 128) {
                cbuf[off + i] = 63;
                continue;
            }
            if ((r & 0xFE) == 254) {
                cbuf[off + i] = 63;
                continue;
            }
            this.buffer[0] = r;
            int c = 1;
            if ((r & 0xC0) == 192) {
                this.buffer[c++] = this.in.read();
                if ((r & 0xE0) == 224) {
                    this.buffer[c++] = this.in.read();
                    if ((r & 0xF0) == 240) {
                        this.buffer[c++] = this.in.read();
                        if ((r & 0xF8) == 248) {
                            this.buffer[c++] = this.in.read();
                            if ((r & 0xFC) == 252) {
                                this.buffer[c++] = this.in.read();
                            }
                        }
                    }
                }
            }
            cbuf[off + i] = this.convert(this.buffer, c);
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public boolean ready() throws IOException {
        return this.in != null && this.in.available() > 0;
    }

    private char convert(int[] arr, int num) throws IOException {
        int cp = 0;
        switch (num) {
            case 2: {
                cp = arr[0] & 0x1F;
                break;
            }
            case 3: {
                cp = arr[0] & 0xF;
                break;
            }
            case 4: {
                cp = arr[0] & 7;
                break;
            }
            case 5: {
                cp = arr[0] & 3;
                break;
            }
            case 6: {
                cp = arr[0] & 1;
            }
        }
        for (int i = 1; i < num; ++i) {
            if (arr[i] == -1) {
                throw new IOException("End of stream inside utf-8 encoded entity.");
            }
            if ((arr[i] & 0xC0) != 128) {
                throw new UnsupportedEncodingException(String.format(Locale.ENGLISH, "Unexpected non-entity utf-8 char in entity extra bytes: %2x", arr[i]));
            }
            cp = cp << 6 | arr[i] & 0x3F;
        }
        if (Character.isBmpCodePoint(cp)) {
            return (char)cp;
        }
        this.surrogate = Character.lowSurrogate(cp);
        return Character.highSurrogate(cp);
    }
}

