/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util.io;

import java.io.IOException;
import java.io.InputStream;
import net.morimekta.util.Binary;

public class BinaryReader
extends InputStream {
    private final InputStream in;

    public BinaryReader(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] out) throws IOException {
        int off;
        int i;
        for (off = 0; off < out.length && (i = this.in.read(out, off, out.length - off)) > 0; off += i) {
        }
        return off;
    }

    @Override
    public int read(byte[] out, int off, int len) throws IOException {
        int pos;
        int i;
        if (off < 0 || len < 0 || off + len > out.length) {
            throw new IllegalArgumentException(String.format("Illegal arguments for read: byte[%d], off:%d, len:%d", out.length, off, len));
        }
        int end = off + len;
        for (pos = off; pos < end && (i = this.in.read(out, off, end - off)) >= 0; pos += i) {
        }
        return pos - off;
    }

    public void expect(byte[] out) throws IOException {
        int off;
        int i;
        for (off = 0; off < out.length && (i = this.in.read(out, off, out.length - off)) > 0; off += i) {
        }
        if (off < out.length) {
            throw new IOException("Not enough data available on stream: " + off + " < " + out.length);
        }
    }

    @Override
    public void close() {
    }

    public byte expectByte() throws IOException {
        int read = this.in.read();
        if (read < 0) {
            throw new IOException("Missing expected byte");
        }
        return (byte)read;
    }

    public short expectShort() throws IOException {
        int b1 = this.in.read();
        if (b1 < 0) {
            throw new IOException("Missing byte 1 to expected short");
        }
        int b2 = this.in.read();
        if (b2 < 0) {
            throw new IOException("Missing byte 2 to expected short");
        }
        return (short)this.unshift2bytes(b1, b2);
    }

    public int expectInt() throws IOException {
        int b1 = this.in.read();
        if (b1 < 0) {
            throw new IOException("Missing byte 1 to expected int");
        }
        int b2 = this.in.read();
        if (b2 < 0) {
            throw new IOException("Missing byte 2 to expected int");
        }
        int b3 = this.in.read();
        if (b3 < 0) {
            throw new IOException("Missing byte 3 to expected int");
        }
        int b4 = this.in.read();
        if (b4 < 0) {
            throw new IOException("Missing byte 4 to expected int");
        }
        return this.unshift4bytes(b1, b2, b3, b4);
    }

    public long expectLong() throws IOException {
        int b1 = this.in.read();
        if (b1 < 0) {
            throw new IOException("Missing byte 1 to expected long");
        }
        int b2 = this.in.read();
        if (b2 < 0) {
            throw new IOException("Missing byte 2 to expected long");
        }
        int b3 = this.in.read();
        if (b3 < 0) {
            throw new IOException("Missing byte 3 to expected long");
        }
        long b4 = this.in.read();
        if (b4 < 0L) {
            throw new IOException("Missing byte 4 to expected long");
        }
        long b5 = this.in.read();
        if (b5 < 0L) {
            throw new IOException("Missing byte 5 to expected long");
        }
        long b6 = this.in.read();
        if (b6 < 0L) {
            throw new IOException("Missing byte 6 to expected long");
        }
        long b7 = this.in.read();
        if (b7 < 0L) {
            throw new IOException("Missing byte 7 to expected long");
        }
        long b8 = this.in.read();
        if (b8 < 0L) {
            throw new IOException("Missing byte 8 to expected long");
        }
        return this.unshift8bytes(b1, b2, b3, b4, b5, b6, b7, b8);
    }

    public double expectDouble() throws IOException {
        return Double.longBitsToDouble(this.expectLong());
    }

    public Binary expectBinary(int bytes) throws IOException {
        return Binary.wrap(this.expectBytes(bytes));
    }

    public byte[] expectBytes(int bytes) throws IOException {
        byte[] out = new byte[bytes];
        this.expect(out);
        return out;
    }

    public int expectUInt8() throws IOException {
        int read = this.in.read();
        if (read < 0) {
            throw new IOException("Missing unsigned byte");
        }
        return read;
    }

    public int expectUInt16() throws IOException {
        int b1 = this.in.read();
        if (b1 < 0) {
            throw new IOException("Missing byte 1 to expected uint16");
        }
        int b2 = this.in.read();
        if (b2 < 0) {
            throw new IOException("Missing byte 2 to expected uint16");
        }
        return this.unshift2bytes(b1, b2);
    }

    public int readUInt16() throws IOException {
        int b1 = this.in.read();
        if (b1 < 0) {
            return 0;
        }
        int b2 = this.in.read();
        if (b2 < 0) {
            throw new IOException("Missing byte 2 to read uint16");
        }
        return this.unshift2bytes(b1, b2);
    }

    public int expectUInt24() throws IOException {
        int b1 = this.in.read();
        if (b1 < 0) {
            throw new IOException("Missing byte 1 to expected uint24");
        }
        int b2 = this.in.read();
        if (b2 < 0) {
            throw new IOException("Missing byte 2 to expected uint24");
        }
        int b3 = this.in.read();
        if (b3 < 0) {
            throw new IOException("Missing byte 3 to expected uint24");
        }
        return this.unshift3bytes(b1, b2, b3);
    }

    public int expectUInt32() throws IOException {
        return this.expectInt();
    }

    public int expectUnsigned(int bytes) throws IOException {
        switch (bytes) {
            case 4: {
                return this.expectUInt32();
            }
            case 3: {
                return this.expectUInt24();
            }
            case 2: {
                return this.expectUInt16();
            }
            case 1: {
                return this.expectUInt8();
            }
        }
        throw new IllegalArgumentException("Unsupported byte count for unsigned: " + bytes);
    }

    public long expectSigned(int bytes) throws IOException {
        switch (bytes) {
            case 8: {
                return this.expectLong();
            }
            case 4: {
                return this.expectInt();
            }
            case 2: {
                return this.expectShort();
            }
            case 1: {
                return this.expectByte();
            }
        }
        throw new IllegalArgumentException("Unsupported byte count for signed: " + bytes);
    }

    public int readIntZigzag() throws IOException {
        int value = this.readIntVarint();
        return (value & 1) != 0 ? ~(value >>> 1) : value >>> 1;
    }

    public long readLongZigzag() throws IOException {
        long value = this.readLongVarint();
        return (value & 1L) != 0L ? value >>> 1 ^ 0xFFFFFFFFFFFFFFFFL : value >>> 1;
    }

    public int readIntVarint() throws IOException {
        int i = this.in.read();
        if (i < 0) {
            return 0;
        }
        boolean c = (i & 0x80) > 0;
        int out = i & 0x7F;
        int shift = 0;
        while (c) {
            i = this.expectUInt8();
            c = (i & 0x80) > 0;
            out |= (i & 0x7F) << (shift += 7);
        }
        return out;
    }

    public long readLongVarint() throws IOException {
        int i = this.in.read();
        if (i < 0) {
            return 0L;
        }
        boolean c = (i & 0x80) > 0;
        long out = i & 0x7F;
        int shift = 0;
        while (c) {
            i = this.expectUInt8();
            c = (i & 0x80) > 0;
            out |= ((long)i & 0x7FL) << (shift += 7);
        }
        return out;
    }

    protected int unshift2bytes(int b1, int b2) {
        return b1 | b2 << 8;
    }

    protected int unshift3bytes(int b1, int b2, int b3) {
        return b1 | b2 << 8 | b3 << 16;
    }

    protected int unshift4bytes(int b1, int b2, int b3, int b4) {
        return b1 | b2 << 8 | b3 << 16 | b4 << 24;
    }

    protected long unshift8bytes(long b1, long b2, long b3, long b4, long b5, long b6, long b7, long b8) {
        return b1 | b2 << 8 | b3 << 16 | b4 << 24 | b5 << 32 | b6 << 40 | b7 << 48 | b8 << 56;
    }
}

